/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler;

import biomesoplenty.api.achievement.BOPAchievements;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.block.BlockBOPSapling;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.item.ItemJarFilled;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.JsonSerializableSet;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AchievementEventHandler {
    private static final Set<BiomeGenBase> BOP_BIOMES_TO_EXPLORE = Sets.union(BOPBiomes.REG_INSTANCE.getPresentBiomes(), (Set)BiomeGenBase.field_150597_n);

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack = event.pickedUp.func_92059_d();
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        IBlockState state = block != null ? block.func_176203_a(stack.func_77952_i()) : null;
        EntityPlayer player = event.player;
        if (block != null && block instanceof BlockBOPLog) {
            player.func_71029_a((StatBase)AchievementList.field_76005_g);
        }
        if (block != null && block instanceof BlockBOPFlower || block == Blocks.field_150328_O || block == Blocks.field_150327_N) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_flowers);
        }
        if (item != null && item == BOPItems.berries) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_berry);
        }
        if (block != null && block == BOPBlocks.coral) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_coral);
        }
        if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.MINERS_DELIGHT)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_miners_delight);
        }
        if (block != null && state == BlockBOPPlant.paging.getVariantState(BOPPlants.THORN)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_thorn);
        }
        if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.DEATHBLOOM)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_deathbloom);
        }
        if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.WILTED_LILY)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_wilted_lily);
        }
        if (item != null && item == BOPItems.turnip) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_turnip);
        }
        if (item != null && item == BOPItems.soul) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_soul);
        }
        if (item != null && item == BOPItems.filled_honeycomb) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_honeycomb);
        }
        if (item != null && item == BOPItems.pixie_dust) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_pixie_dust);
        }
        if (item != null && item == BOPItems.crystal_shard) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_celestial_crystal);
        }
    }

    @SubscribeEvent
    public void onItemUsed(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            ItemStack stack = event.entityPlayer.func_70694_bm();
            Item item = stack != null ? stack.func_77973_b() : null;
            EntityPlayer player = event.entityPlayer;
            if (item == BOPItems.enderporter) {
                player.func_71029_a((StatBase)BOPAchievements.use_enderporter);
            }
        }
    }

    @SubscribeEvent
    public void onItemUsed(PlayerUseItemEvent.Finish event) {
        ItemStack stack = event.item;
        Item item = stack.func_77973_b();
        EntityPlayer player = event.entityPlayer;
        if (item == BOPItems.shroompowder) {
            player.func_71029_a((StatBase)BOPAchievements.eat_shroom_powder);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        ItemStack stack = event.itemInHand;
        if (stack != null) {
            Item item = stack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            try {
                IBlockState state;
                IBlockState iBlockState = state = block != null ? block.func_176203_a(item.func_77647_b(stack.func_77952_i())) : null;
                if (state == BlockBOPSapling.paging.getVariantState(BOPTrees.SACRED_OAK)) {
                    event.player.func_71029_a((StatBase)BOPAchievements.grow_sacred_oak);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        if (item != null && item == BOPItems.ambrosia) {
            player.func_71029_a((StatBase)BOPAchievements.craft_ambrosia);
        }
        if (item != null && item == BOPItems.flax_string) {
            player.func_71029_a((StatBase)BOPAchievements.craft_flax_string);
        }
        if (item != null && item == BOPItems.amethyst_sword) {
            player.func_71029_a((StatBase)BOPAchievements.craft_amethyst_sword);
        }
        if (item != null && item == BOPItems.mud_pickaxe) {
            player.func_71029_a((StatBase)BOPAchievements.craft_muddy_pickaxe);
        }
        if (item != null && item == BOPItems.terrestrial_artifact) {
            player.func_71029_a((StatBase)BOPAchievements.craft_terrestrial_artifact);
        }
        if (item != null && item == BOPItems.dart_blower) {
            player.func_71029_a((StatBase)BOPAchievements.craft_dart_blower);
        }
        if (item != null && item == new ItemStack(BOPItems.jar_filled, 1, ItemJarFilled.JarContents.POISON.ordinal()).func_77973_b()) {
            player.func_71029_a((StatBase)BOPAchievements.craft_poison_jar);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            if (player.field_70173_aa % 20 * 5 == 0) {
                if (!player.func_147099_x().func_77443_a(BOPAchievements.use_biome_finder)) {
                    this.updateBiomeRadarExplore(player);
                }
                if (!player.func_147099_x().func_77443_a(BOPAchievements.explore_all_biomes)) {
                    this.updateBiomesExplored(player);
                }
            }
        }
    }

    private void updateBiomeRadarExplore(EntityPlayerMP player) {
        BiomeGenBase currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            int biomeIdToFind;
            if (stack == null || stack.func_77973_b() != BOPItems.biome_finder || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("biomeIDToFind") || (biomeIdToFind = stack.func_77978_p().func_74762_e("biomeIDToFind")) != currentBiome.field_76756_M) continue;
            player.func_71029_a((StatBase)BOPAchievements.use_biome_finder);
            return;
        }
    }

    private void updateBiomesExplored(EntityPlayerMP player) {
        BiomeGenBase currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        String biomeName = currentBiome.field_76791_y;
        JsonSerializableSet exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150870_b((StatBase)BOPAchievements.explore_all_biomes);
        if (exploredBiomeNames == null) {
            exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150872_a((StatBase)BOPAchievements.explore_all_biomes, (IJsonSerializable)new JsonSerializableSet());
        }
        exploredBiomeNames.add((Object)biomeName);
        if (player.func_147099_x().func_77442_b(BOPAchievements.explore_all_biomes) && exploredBiomeNames.size() >= BOP_BIOMES_TO_EXPLORE.size()) {
            HashSet set = Sets.newHashSet(BOP_BIOMES_TO_EXPLORE);
            for (String exploredBiomeName : exploredBiomeNames) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    BiomeGenBase biome = (BiomeGenBase)iterator.next();
                    if (!biome.field_76791_y.equals(exploredBiomeName)) continue;
                    iterator.remove();
                }
                if (!set.isEmpty()) continue;
                break;
            }
            if (set.isEmpty()) {
                player.func_71029_a((StatBase)BOPAchievements.explore_all_biomes);
            }
        }
    }
}

