/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.common.biome.overworld.BiomeGenAlps;
import biomesoplenty.common.biome.overworld.BiomeGenBambooForest;
import biomesoplenty.common.biome.overworld.BiomeGenBayou;
import biomesoplenty.common.biome.overworld.BiomeGenBog;
import biomesoplenty.common.biome.overworld.BiomeGenBorealForest;
import biomesoplenty.common.biome.overworld.BiomeGenBrushland;
import biomesoplenty.common.biome.overworld.BiomeGenChaparral;
import biomesoplenty.common.biome.overworld.BiomeGenCherryBlossomGrove;
import biomesoplenty.common.biome.overworld.BiomeGenColdDesert;
import biomesoplenty.common.biome.overworld.BiomeGenConiferousForest;
import biomesoplenty.common.biome.overworld.BiomeGenCoralReef;
import biomesoplenty.common.biome.overworld.BiomeGenCrag;
import biomesoplenty.common.biome.overworld.BiomeGenDeadForest;
import biomesoplenty.common.biome.overworld.BiomeGenDeadSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenEucalyptusForest;
import biomesoplenty.common.biome.overworld.BiomeGenFen;
import biomesoplenty.common.biome.overworld.BiomeGenFlowerField;
import biomesoplenty.common.biome.overworld.BiomeGenFlowerIsland;
import biomesoplenty.common.biome.overworld.BiomeGenGlacier;
import biomesoplenty.common.biome.overworld.BiomeGenGrassland;
import biomesoplenty.common.biome.overworld.BiomeGenGravelBeach;
import biomesoplenty.common.biome.overworld.BiomeGenGrove;
import biomesoplenty.common.biome.overworld.BiomeGenHeathland;
import biomesoplenty.common.biome.overworld.BiomeGenHighland;
import biomesoplenty.common.biome.overworld.BiomeGenKelpForest;
import biomesoplenty.common.biome.overworld.BiomeGenLandOfLakes;
import biomesoplenty.common.biome.overworld.BiomeGenLavenderFields;
import biomesoplenty.common.biome.overworld.BiomeGenLushDesert;
import biomesoplenty.common.biome.overworld.BiomeGenLushSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenMangrove;
import biomesoplenty.common.biome.overworld.BiomeGenMapleWoods;
import biomesoplenty.common.biome.overworld.BiomeGenMarsh;
import biomesoplenty.common.biome.overworld.BiomeGenMeadow;
import biomesoplenty.common.biome.overworld.BiomeGenMoor;
import biomesoplenty.common.biome.overworld.BiomeGenMountain;
import biomesoplenty.common.biome.overworld.BiomeGenMysticGrove;
import biomesoplenty.common.biome.overworld.BiomeGenOasis;
import biomesoplenty.common.biome.overworld.BiomeGenOminousWoods;
import biomesoplenty.common.biome.overworld.BiomeGenOrchard;
import biomesoplenty.common.biome.overworld.BiomeGenOriginIsland;
import biomesoplenty.common.biome.overworld.BiomeGenOutback;
import biomesoplenty.common.biome.overworld.BiomeGenOvergrownCliffs;
import biomesoplenty.common.biome.overworld.BiomeGenPrairie;
import biomesoplenty.common.biome.overworld.BiomeGenQuagmire;
import biomesoplenty.common.biome.overworld.BiomeGenRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenRedwoodForest;
import biomesoplenty.common.biome.overworld.BiomeGenSacredSprings;
import biomesoplenty.common.biome.overworld.BiomeGenSeasonalForest;
import biomesoplenty.common.biome.overworld.BiomeGenShield;
import biomesoplenty.common.biome.overworld.BiomeGenShrubland;
import biomesoplenty.common.biome.overworld.BiomeGenSnowyConiferousForest;
import biomesoplenty.common.biome.overworld.BiomeGenSnowyForest;
import biomesoplenty.common.biome.overworld.BiomeGenSteppe;
import biomesoplenty.common.biome.overworld.BiomeGenTemperateRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenTropicalIsland;
import biomesoplenty.common.biome.overworld.BiomeGenTropicalRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenTundra;
import biomesoplenty.common.biome.overworld.BiomeGenVolcanicIsland;
import biomesoplenty.common.biome.overworld.BiomeGenWasteland;
import biomesoplenty.common.biome.overworld.BiomeGenWetland;
import biomesoplenty.common.biome.overworld.BiomeGenWoodland;
import biomesoplenty.common.biome.overworld.BiomeGenXericShrubland;
import biomesoplenty.common.biome.vanilla.BiomeExtBirchForest;
import biomesoplenty.common.biome.vanilla.BiomeExtBirchForestHills;
import biomesoplenty.common.biome.vanilla.BiomeExtColdTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtColdTaigaHills;
import biomesoplenty.common.biome.vanilla.BiomeExtDesert;
import biomesoplenty.common.biome.vanilla.BiomeExtDesertHills;
import biomesoplenty.common.biome.vanilla.BiomeExtEnd;
import biomesoplenty.common.biome.vanilla.BiomeExtExtremeHills;
import biomesoplenty.common.biome.vanilla.BiomeExtExtremeHillsPlus;
import biomesoplenty.common.biome.vanilla.BiomeExtForest;
import biomesoplenty.common.biome.vanilla.BiomeExtForestHills;
import biomesoplenty.common.biome.vanilla.BiomeExtIceMountains;
import biomesoplenty.common.biome.vanilla.BiomeExtIcePlains;
import biomesoplenty.common.biome.vanilla.BiomeExtJungle;
import biomesoplenty.common.biome.vanilla.BiomeExtJungleHills;
import biomesoplenty.common.biome.vanilla.BiomeExtMegaTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtMegaTaigaHills;
import biomesoplenty.common.biome.vanilla.BiomeExtMesa;
import biomesoplenty.common.biome.vanilla.BiomeExtMesaPlateau;
import biomesoplenty.common.biome.vanilla.BiomeExtMushroomIsland;
import biomesoplenty.common.biome.vanilla.BiomeExtOcean;
import biomesoplenty.common.biome.vanilla.BiomeExtPlains;
import biomesoplenty.common.biome.vanilla.BiomeExtRoofedForest;
import biomesoplenty.common.biome.vanilla.BiomeExtSavanna;
import biomesoplenty.common.biome.vanilla.BiomeExtSavannaPlateau;
import biomesoplenty.common.biome.vanilla.BiomeExtSwampland;
import biomesoplenty.common.biome.vanilla.BiomeExtTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtTaigaHills;
import biomesoplenty.common.command.BOPCommand;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class ModBiomes
implements BOPBiomes.IBiomeRegistry {
    public static WorldTypeBOP worldTypeBOP;
    private static int nextBiomeId;
    private static File biomeIdMapFile;
    private static BOPConfig.IConfigObj biomeIdMapConf;
    protected static Map<String, Integer> biomeIdMap;
    private static Set<Integer> idsReservedInConfig;
    private static Map<Integer, IExtendedBiome> biomeWrapperMap;
    public static Set<BiomeGenBase> presentBiomes;
    public static Map<Integer, List<Integer>> subBiomesMap;
    public static Map<Integer, List<Integer>> mutatedBiomesMap;
    public static Map<Integer, Integer> islandBiomesMap;
    public static int totalIslandBiomesWeight;

    public static void init() {
        worldTypeBOP = new WorldTypeBOP();
        biomeIdMapFile = new File(BiomesOPlenty.configDirectory, "biome_ids.json");
        biomeIdMapConf = new BOPConfig.ConfigFileObj(biomeIdMapFile);
        biomeIdMap = new HashMap<String, Integer>();
        presentBiomes = Sets.newHashSet();
        idsReservedInConfig = new HashSet<Integer>();
        for (String biomeIdName : biomeIdMapConf.getKeys()) {
            Integer reservedId = biomeIdMapConf.getInt(biomeIdName);
            if (reservedId == null || reservedId <= -1) continue;
            idsReservedInConfig.add(reservedId);
        }
        File biomesDir = new File(BiomesOPlenty.configDirectory, "biomes");
        if (!biomesDir.exists()) {
            biomesDir.mkdir();
            try {
                new File(biomesDir, "Put biome config files here").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ModBiomes.initSubBiomes();
        ModBiomes.initMutatedBiomes();
        ModBiomes.registerBiomes();
        ModBiomes.registerBiomeDictionaryTags();
        ModBiomes.initExtendedBiomes();
        BOPConfig.writeFile(biomeIdMapFile, biomeIdMap);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_151360_e);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_180271_f);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77137_b);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77136_e);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77138_c);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77135_d);
    }

    public static void initSubBiomes() {
        subBiomesMap = new HashMap<Integer, List<Integer>>();
        ModBiomes.setSubBiome(BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s);
        ModBiomes.setSubBiome(BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t);
        ModBiomes.setSubBiome(BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q);
        ModBiomes.setSubBiome(BiomeGenBase.field_150585_R, BiomeGenBase.field_76772_c);
        ModBiomes.setSubBiome(BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u);
        ModBiomes.setSubBiome(BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V);
        ModBiomes.setSubBiome(BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T);
        ModBiomes.setSubBiome(BiomeGenBase.field_76772_c, BiomeGenBase.field_76785_t, BiomeGenBase.field_76767_f);
        ModBiomes.setSubBiome(BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o);
        ModBiomes.setSubBiome(BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x);
        ModBiomes.setSubBiome(BiomeGenBase.field_76770_e, BiomeGenBase.field_150580_W);
        ModBiomes.setSubBiome(BiomeGenBase.field_150588_X, BiomeGenBase.field_150587_Y);
        ModBiomes.setSubBiome(BiomeGenBase.field_150607_aa, BiomeGenBase.field_150589_Z);
        ModBiomes.setSubBiome(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M);
    }

    public static void initMutatedBiomes() {
        mutatedBiomesMap = new HashMap<Integer, List<Integer>>();
        ModBiomes.setSubBiome(BiomeGenBase.field_76772_c, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76772_c.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76769_d, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76769_d.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76767_f, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76767_f.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76768_g, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76768_g.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76780_h, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76780_h.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76774_n, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76774_n.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76782_w, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76782_w.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150574_L, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150574_L.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150584_S, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150584_S.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150588_X, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150588_X.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150587_Y, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150587_Y.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150589_Z, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150589_Z.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150608_ab, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150608_ab.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150607_aa, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150607_aa.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150583_P, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150583_P.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150582_Q, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150582_Q.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150585_R, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150585_R.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150578_U, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150578_U.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_76770_e, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76770_e.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150580_W, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150580_W.field_76756_M + 128)));
        ModBiomes.setSubBiome(BiomeGenBase.field_150581_V, BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150581_V.field_76756_M + 128)));
    }

    private static void registerBiomes() {
        BOPBiomes.gravel_beach = ModBiomes.registerBOPBiome(new BiomeGenGravelBeach(), "Gravel Beach");
        BOPBiomes.alps = ModBiomes.registerBOPBiome(new BiomeGenAlps(), "Alps");
        BOPBiomes.bamboo_forest = ModBiomes.registerBOPBiome(new BiomeGenBambooForest(), "Bamboo Forest");
        BOPBiomes.bayou = ModBiomes.registerBOPBiome(new BiomeGenBayou(), "Bayou");
        BOPBiomes.bog = ModBiomes.registerBOPBiome(new BiomeGenBog(), "Bog");
        BOPBiomes.boreal_forest = ModBiomes.registerBOPBiome(new BiomeGenBorealForest(), "Boreal Forest");
        BOPBiomes.brushland = ModBiomes.registerBOPBiome(new BiomeGenBrushland(), "Brushland");
        BOPBiomes.chaparral = ModBiomes.registerBOPBiome(new BiomeGenChaparral(), "Chaparral");
        BOPBiomes.cherry_blossom_grove = ModBiomes.registerBOPBiome(new BiomeGenCherryBlossomGrove(), "Cherry Blossom Grove");
        BOPBiomes.cold_desert = ModBiomes.registerBOPBiome(new BiomeGenColdDesert(), "Cold Desert");
        BOPBiomes.coniferous_forest = ModBiomes.registerBOPBiome(new BiomeGenConiferousForest(), "Coniferous Forest");
        BOPBiomes.crag = ModBiomes.registerBOPBiome(new BiomeGenCrag(), "Crag");
        BOPBiomes.dead_forest = ModBiomes.registerBOPBiome(new BiomeGenDeadForest(), "Dead Forest");
        BOPBiomes.dead_swamp = ModBiomes.registerBOPBiome(new BiomeGenDeadSwamp(), "Dead Swamp");
        BOPBiomes.eucalyptus_forest = ModBiomes.registerBOPBiome(new BiomeGenEucalyptusForest(), "Eucalyptus Forest");
        BOPBiomes.fen = ModBiomes.registerBOPBiome(new BiomeGenFen(), "Fen");
        BOPBiomes.flower_field = ModBiomes.registerBOPBiome(new BiomeGenFlowerField(), "Flower Field");
        BOPBiomes.grassland = ModBiomes.registerBOPBiome(new BiomeGenGrassland(), "Grassland");
        BOPBiomes.grove = ModBiomes.registerBOPBiome(new BiomeGenGrove(), "Grove");
        BOPBiomes.heathland = ModBiomes.registerBOPBiome(new BiomeGenHeathland(), "Heathland");
        BOPBiomes.highland = ModBiomes.registerBOPBiome(new BiomeGenHighland(), "Highland");
        BOPBiomes.land_of_lakes = ModBiomes.registerBOPBiome(new BiomeGenLandOfLakes(), "Land Of Lakes");
        BOPBiomes.lavender_fields = ModBiomes.registerBOPBiome(new BiomeGenLavenderFields(), "Lavender Fields");
        BOPBiomes.lush_desert = ModBiomes.registerBOPBiome(new BiomeGenLushDesert(), "Lush Desert");
        BOPBiomes.lush_swamp = ModBiomes.registerBOPBiome(new BiomeGenLushSwamp(), "Lush Swamp");
        BOPBiomes.maple_woods = ModBiomes.registerBOPBiome(new BiomeGenMapleWoods(), "Maple Woods");
        BOPBiomes.marsh = ModBiomes.registerBOPBiome(new BiomeGenMarsh(), "Marsh");
        BOPBiomes.meadow = ModBiomes.registerBOPBiome(new BiomeGenMeadow(), "Meadow");
        BOPBiomes.moor = ModBiomes.registerBOPBiome(new BiomeGenMoor(), "Moor");
        BOPBiomes.mountain = ModBiomes.registerBOPBiome(new BiomeGenMountain(BiomeGenMountain.MountainType.PEAKS), "Mountain");
        BOPBiomes.mystic_grove = ModBiomes.registerBOPBiome(new BiomeGenMysticGrove(), "Mystic Grove");
        BOPBiomes.ominous_woods = ModBiomes.registerBOPBiome(new BiomeGenOminousWoods(), "Ominous Woods");
        BOPBiomes.orchard = ModBiomes.registerBOPBiome(new BiomeGenOrchard(), "Orchard");
        BOPBiomes.outback = ModBiomes.registerBOPBiome(new BiomeGenOutback(), "Outback");
        BOPBiomes.overgrown_cliffs = ModBiomes.registerBOPBiome(new BiomeGenOvergrownCliffs(), "Overgrown Cliffs");
        BOPBiomes.prairie = ModBiomes.registerBOPBiome(new BiomeGenPrairie(), "Prairie");
        BOPBiomes.quagmire = ModBiomes.registerBOPBiome(new BiomeGenQuagmire(), "Quagmire");
        BOPBiomes.rainforest = ModBiomes.registerBOPBiome(new BiomeGenRainforest(), "Rainforest");
        BOPBiomes.redwood_forest = ModBiomes.registerBOPBiome(new BiomeGenRedwoodForest(), "Redwood Forest");
        BOPBiomes.sacred_springs = ModBiomes.registerBOPBiome(new BiomeGenSacredSprings(), "Sacred Springs");
        BOPBiomes.seasonal_forest = ModBiomes.registerBOPBiome(new BiomeGenSeasonalForest(), "Seasonal Forest");
        BOPBiomes.shield = ModBiomes.registerBOPBiome(new BiomeGenShield(), "Shield");
        BOPBiomes.shrubland = ModBiomes.registerBOPBiome(new BiomeGenShrubland(), "Shrubland");
        BOPBiomes.snowy_coniferous_forest = ModBiomes.registerBOPBiome(new BiomeGenSnowyConiferousForest(), "Snowy Coniferous Forest");
        BOPBiomes.snowy_forest = ModBiomes.registerBOPBiome(new BiomeGenSnowyForest(), "Snowy Forest");
        BOPBiomes.steppe = ModBiomes.registerBOPBiome(new BiomeGenSteppe(), "Steppe");
        BOPBiomes.temperate_rainforest = ModBiomes.registerBOPBiome(new BiomeGenTemperateRainforest(), "Temperate Rainforest");
        BOPBiomes.tropical_rainforest = ModBiomes.registerBOPBiome(new BiomeGenTropicalRainforest(), "Tropical Rainforest");
        BOPBiomes.tundra = ModBiomes.registerBOPBiome(new BiomeGenTundra(), "Tundra");
        BOPBiomes.wasteland = ModBiomes.registerBOPBiome(new BiomeGenWasteland(), "Wasteland");
        BOPBiomes.wetland = ModBiomes.registerBOPBiome(new BiomeGenWetland(), "Wetland");
        BOPBiomes.woodland = ModBiomes.registerBOPBiome(new BiomeGenWoodland(), "Woodland");
        BOPBiomes.xeric_shrubland = ModBiomes.registerBOPBiome(new BiomeGenXericShrubland(), "Xeric Shrubland");
        BOPBiomes.mountain_foothills = ModBiomes.registerBOPBiome(new BiomeGenMountain(BiomeGenMountain.MountainType.FOOTHILLS), "Mountain Foothills");
        BOPBiomes.glacier = ModBiomes.registerBOPBiome(new BiomeGenGlacier(), "Glacier");
        BOPBiomes.oasis = ModBiomes.registerBOPBiome(new BiomeGenOasis(), "Oasis");
        BOPBiomes.coral_reef = ModBiomes.registerBOPBiome(new BiomeGenCoralReef(), "Coral Reef");
        BOPBiomes.kelp_forest = ModBiomes.registerBOPBiome(new BiomeGenKelpForest(), "Kelp Forest");
        ModBiomes.setSubBiome((Optional<BiomeGenBase>)Optional.of((Object)BiomeGenBase.field_76774_n), BOPBiomes.glacier);
        ModBiomes.setSubBiome((Optional<BiomeGenBase>)Optional.of((Object)BiomeGenBase.field_76769_d), BOPBiomes.oasis);
        ModBiomes.setSubBiome((Optional<BiomeGenBase>)Optional.of((Object)BiomeGenBase.field_76771_b), BOPBiomes.coral_reef);
        ModBiomes.setSubBiome((Optional<BiomeGenBase>)Optional.of((Object)BiomeGenBase.field_76771_b), BOPBiomes.kelp_forest);
        BOPBiomes.mangrove = ModBiomes.registerBOPBiome(new BiomeGenMangrove(), "Mangrove");
        BOPBiomes.origin_island = ModBiomes.registerBOPBiome(new BiomeGenOriginIsland(), "Origin Island");
        BOPBiomes.tropical_island = ModBiomes.registerBOPBiome(new BiomeGenTropicalIsland(), "Tropical Island");
        BOPBiomes.volcanic_island = ModBiomes.registerBOPBiome(new BiomeGenVolcanicIsland(), "Volcanic Island");
        BOPBiomes.flower_island = ModBiomes.registerBOPBiome(new BiomeGenFlowerIsland(), "Flower Island");
        ModBiomes.addIslandBiome(BOPBiomes.origin_island, 1);
        ModBiomes.addIslandBiome(BOPBiomes.tropical_island, 3);
        ModBiomes.addIslandBiome(BOPBiomes.volcanic_island, 5);
        ModBiomes.addIslandBiome(BOPBiomes.flower_island, 7);
        ModBiomes.addIslandBiome(BOPBiomes.mangrove, 10);
    }

    public static void initExtendedBiomes() {
        biomeWrapperMap = new HashMap<Integer, IExtendedBiome>();
        BOPBiomes.end_extension = ModBiomes.registerWrappedBiome(new BiomeExtEnd(), "end");
        BOPBiomes.mushroom_island_extension = ModBiomes.registerWrappedBiome(new BiomeExtMushroomIsland(), "mushroom_island");
        BOPBiomes.birch_forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtBirchForest(), "birch_forest");
        BOPBiomes.birch_forest_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtBirchForestHills(), "birch_forest_hills");
        BOPBiomes.cold_taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtColdTaiga(), "cold_taiga");
        BOPBiomes.cold_taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtColdTaigaHills(), "cold_taiga_hills");
        BOPBiomes.desert_extension = ModBiomes.registerWrappedBiome(new BiomeExtDesert(), "desert");
        BOPBiomes.desert_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtDesertHills(), "desert_hills");
        BOPBiomes.extreme_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtExtremeHills(), "extreme_hills");
        BOPBiomes.extreme_hills_plus_extension = ModBiomes.registerWrappedBiome(new BiomeExtExtremeHillsPlus(), "extreme_hills+");
        BOPBiomes.forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtForest(), "forest");
        BOPBiomes.forest_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtForestHills(), "forest_hills");
        BOPBiomes.ice_plains_extension = ModBiomes.registerWrappedBiome(new BiomeExtIcePlains(), "ice_plains");
        BOPBiomes.ice_mountains_extension = ModBiomes.registerWrappedBiome(new BiomeExtIceMountains(), "ice_mountains");
        BOPBiomes.jungle_extension = ModBiomes.registerWrappedBiome(new BiomeExtJungle(), "jungle");
        BOPBiomes.jungle_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtJungleHills(), "jungle_hills");
        BOPBiomes.mega_taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtMegaTaiga(), "mega_taiga");
        BOPBiomes.mega_taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtMegaTaigaHills(), "mega_taiga_hills");
        BOPBiomes.mesa_extension = ModBiomes.registerWrappedBiome(new BiomeExtMesa(), "mesa");
        BOPBiomes.mesa_plateau_extension = ModBiomes.registerWrappedBiome(new BiomeExtMesaPlateau(), "mesa_plateau");
        BOPBiomes.ocean_extension = ModBiomes.registerWrappedBiome(new BiomeExtOcean(), "ocean");
        BOPBiomes.plains_extension = ModBiomes.registerWrappedBiome(new BiomeExtPlains(), "plains");
        BOPBiomes.roofed_forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtRoofedForest(), "roofed_forest");
        BOPBiomes.savanna_extension = ModBiomes.registerWrappedBiome(new BiomeExtSavanna(), "savanna");
        BOPBiomes.savanna_plateau_extension = ModBiomes.registerWrappedBiome(new BiomeExtSavannaPlateau(), "savanna_plateau");
        BOPBiomes.swampland_extension = ModBiomes.registerWrappedBiome(new BiomeExtSwampland(), "swampland");
        BOPBiomes.taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtTaiga(), "taiga");
        BOPBiomes.taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtTaigaHills(), "taiga_hills");
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bamboo_forest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bog, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.boreal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.brushland, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.chaparral, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cherry_blossom_grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cold_desert, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_forest, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.crag, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_swamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.eucalyptus_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fen, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_field, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.heathland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.land_of_lakes, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_fields, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_desert, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_swamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.maple_woods, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.marsh, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.moor, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mountain, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_grove, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_woods, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.outback, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.overgrown_cliffs, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.prairie, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.quagmire, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.sacred_springs, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shield, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_coniferous_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_forest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.steppe, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wasteland, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.woodland, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.xeric_shrubland, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mountain_foothills, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.glacier, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.oasis, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coral_reef, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.kelp_forest, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcanic_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.gravel_beach, BiomeDictionary.Type.BEACH);
    }

    @Override
    public IExtendedBiome registerBiome(IExtendedBiome extendedBiome, String idName) {
        if (extendedBiome == null) {
            throw new IllegalArgumentException("Extended biome to register cannot be null!");
        }
        presentBiomes.add(extendedBiome.getBaseBiome());
        ModBiomes.configureBiome(extendedBiome, idName);
        if (extendedBiome instanceof BiomeGenBase) {
            for (Map.Entry<BOPClimates, Integer> entry : extendedBiome.getWeightMap().entrySet()) {
                if (entry == null) continue;
                BOPClimates climate = entry.getKey();
                int weight = entry.getValue();
                climate.addLandBiome(weight, extendedBiome.getBaseBiome());
            }
        } else {
            biomeWrapperMap.put(extendedBiome.getBaseBiome().field_76756_M, extendedBiome);
        }
        return extendedBiome;
    }

    @Override
    public IExtendedBiome getExtendedBiome(BiomeGenBase biome) {
        if (biome instanceof IExtendedBiome) {
            return (IExtendedBiome)biome;
        }
        IExtendedBiome wrapper = biomeWrapperMap.get(biome.field_76756_M);
        if (wrapper != null) {
            return wrapper;
        }
        return null;
    }

    @Override
    public ImmutableSet<BiomeGenBase> getPresentBiomes() {
        return ImmutableSet.copyOf(presentBiomes);
    }

    private static void setSubBiome(Optional<BiomeGenBase> parent, Optional<BiomeGenBase> ... subBiomes) {
        ModBiomes.setSubBiome(parent, false, subBiomes);
    }

    private static void setSubBiome(Optional<BiomeGenBase> parent, boolean mutated, Optional<BiomeGenBase> ... subBiomes) {
        if (parent.isPresent()) {
            for (Optional<BiomeGenBase> subBiome : subBiomes) {
                if (!subBiome.isPresent()) continue;
                ModBiomes.setSubBiome((BiomeGenBase)parent.get(), mutated, (BiomeGenBase)subBiome.get());
            }
        }
    }

    private static void setSubBiome(BiomeGenBase parent, BiomeGenBase ... subBiomes) {
        ModBiomes.setSubBiome(parent, false, subBiomes);
    }

    private static void setSubBiome(BiomeGenBase parent, boolean mutated, BiomeGenBase ... subBiomes) {
        int parentId;
        Map<Integer, List<Integer>> map = mutated ? mutatedBiomesMap : subBiomesMap;
        if (!map.containsKey(parentId = parent.field_76756_M)) {
            map.put(parentId, new ArrayList());
        }
        for (BiomeGenBase subBiome : subBiomes) {
            map.get(parentId).add(subBiome.field_76756_M);
        }
    }

    private static void addIslandBiome(Optional<BiomeGenBase> biome, int weight) {
        if (biome.isPresent()) {
            totalIslandBiomesWeight += weight;
            islandBiomesMap.put(((BiomeGenBase)biome.get()).field_76756_M, weight);
        }
    }

    private static void configureBiome(IExtendedBiome biome, String idName) {
        File configFile = new File(new File(BiomesOPlenty.configDirectory, "biomes"), idName + ".json");
        BOPConfig.ConfigFileObj conf = new BOPConfig.ConfigFileObj(configFile);
        if (!conf.isEmpty()) {
            biome.configure(conf);
        }
        for (String msg : conf.flushMessages()) {
            BiomesOPlenty.logger.warn(msg);
        }
    }

    private static IExtendedBiome registerWrappedBiome(IExtendedBiome extendedBiome, String idName) {
        if (extendedBiome.getBaseBiome() instanceof IExtendedBiome) {
            throw new IllegalArgumentException("Biome already implements IExtendedBiome, it should be registered appropriately");
        }
        return BOPBiomes.REG_INSTANCE.registerBiome(extendedBiome, idName);
    }

    private static Optional<BiomeGenBase> registerBOPBiome(BOPBiome biome, String name) {
        biome.func_76735_a(name);
        String idName = BiomeUtils.getBiomeIdentifier(biome);
        Integer id = biomeIdMapConf.getInt(idName, null);
        if (id == null) {
            id = new Integer(ModBiomes.getNextFreeBiomeId());
        }
        biomeIdMap.put(idName, id);
        if (id > -1) {
            ++BOPCommand.biomeCount;
            biome.field_76756_M = id;
            BOPBiomes.REG_INSTANCE.registerBiome(biome, idName);
            BiomeGenBase.func_150565_n()[id.intValue()] = biome;
            if (biome.canSpawnInBiome) {
                BiomeManager.addSpawnBiome((BiomeGenBase)biome);
            }
            if (biome.canGenerateVillages) {
                BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
            }
            return Optional.of((Object)biome);
        }
        return Optional.absent();
    }

    private static void registerBiomeToDictionary(Optional<BiomeGenBase> biome, BiomeDictionary.Type ... types) {
        if (biome.isPresent()) {
            BiomeDictionary.registerBiomeType((BiomeGenBase)((BiomeGenBase)biome.get()), (BiomeDictionary.Type[])types);
        }
    }

    public static int getNextFreeBiomeId() {
        for (int i = nextBiomeId; i < 256; ++i) {
            if (BiomeGenBase.func_150565_n()[i] != null) {
                if (i != 255) continue;
                throw new IllegalArgumentException("There are no more biome ids avaliable!");
            }
            if (idsReservedInConfig.contains(i)) continue;
            nextBiomeId = i + 1;
            return i;
        }
        return -1;
    }

    static {
        nextBiomeId = 40;
        islandBiomesMap = new HashMap<Integer, Integer>();
    }
}

