/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.api.item.BOPItemHelper;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.enums.BOPPlants;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBOPScythe
extends Item {
    protected Item.ToolMaterial toolMaterial;

    public ItemBOPScythe(Item.ToolMaterial material) {
        this.toolMaterial = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return block.func_149688_o() == Material.field_151584_j ? 15.0f : super.func_150893_a(stack, block);
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.toolMaterial.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, Block blockIn, BlockPos pos, EntityLivingBase playerIn) {
        int height;
        if (blockIn == null || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        boolean isLeaves = blockIn.isLeaves((IBlockAccess)worldIn, pos);
        int radius = isLeaves ? 0 : 3;
        int n = height = isLeaves ? 0 : 4;
        if (this.toolMaterial == Item.ToolMaterial.IRON || this.toolMaterial == Item.ToolMaterial.GOLD) {
            radius = 4;
            height = 4;
        } else if (this.toolMaterial == Item.ToolMaterial.EMERALD) {
            radius = 5;
            height = 5;
        } else if (this.toolMaterial == BOPItemHelper.amethyst_tool_material) {
            radius = 6;
            height = 6;
        }
        stack.func_77972_a(1, playerIn);
        int numberTrimmed = 0;
        if (isLeaves) {
            numberTrimmed += this.trim(stack, playerIn, worldIn, pos, height, radius, TrimType.TRIM_LEAVES, false, 40);
        } else {
            numberTrimmed += this.trim(stack, playerIn, worldIn, pos, height, radius, TrimType.TRIM_GRASS_AND_FLOWERS, true, 70);
            if (worldIn.field_73012_v.nextInt(3) == 0) {
                numberTrimmed += this.trim(stack, playerIn, worldIn, pos, height, radius - 1, TrimType.TRIM_GRASS_AND_FLOWERS, false, 0);
            }
        }
        return numberTrimmed > 0;
    }

    public int trim(ItemStack stack, EntityLivingBase entity, World world, BlockPos pos, int height, int radius, TrimType trimType, boolean cutCorners, int damagePercentChance) {
        int numberTrimmed = 0;
        int fortune = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (cutCorners && Math.abs(dx) + Math.abs(dz) >= 2 * radius || !trimType.trimAtPos(world, pos.func_177982_a(dx, dy, dz), fortune)) continue;
                    ++numberTrimmed;
                    if (world.field_73012_v.nextInt(100) >= damagePercentChance) continue;
                    stack.func_77972_a(1, entity);
                }
            }
        }
        return numberTrimmed;
    }

    public static enum TrimType {
        TRIM_GRASS_AND_FLOWERS,
        TRIM_LEAVES;


        public boolean trimAtPos(World world, BlockPos pos, int fortune) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            switch (this) {
                case TRIM_LEAVES: {
                    if (block.isLeaves((IBlockAccess)world, pos)) {
                        block.func_176226_b(world, pos, state, fortune);
                        world.func_175698_g(pos);
                        return true;
                    }
                    return false;
                }
            }
            if (block instanceof BlockBOPPlant) {
                switch ((BOPPlants)((Object)state.func_177229_b(((BlockBOPPlant)block).variantProperty))) {
                    case SHORTGRASS: {
                        block.func_176226_b(world, pos, state, fortune);
                        world.func_175698_g(pos);
                        return true;
                    }
                    case MEDIUMGRASS: {
                        block.func_176226_b(world, pos, state, fortune);
                        world.func_175656_a(pos, BlockBOPPlant.paging.getVariantState(BOPPlants.SHORTGRASS));
                        return true;
                    }
                }
                return false;
            }
            if (block == Blocks.field_150329_H) {
                block.func_176226_b(world, pos, state, fortune);
                world.func_175656_a(pos, BlockBOPPlant.paging.getVariantState(BOPPlants.MEDIUMGRASS));
                return true;
            }
            if (block instanceof BlockFlower || block instanceof BlockBOPFlower) {
                block.func_176226_b(world, pos, state, fortune);
                world.func_175698_g(pos);
                return true;
            }
            return false;
        }
    }
}

