/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.common.util.biome.BiomeUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemBiomeFinder
extends Item {
    public ItemBiomeFinder() {
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbt = stack.func_77978_p()).func_74767_n("found")) {
            return stack;
        }
        if (nbt.func_74764_b("searchStarted") && world.func_72820_D() - nbt.func_74763_f("searchStarted") < 100L) {
            return stack;
        }
        if (!nbt.func_74764_b("biomeIDToFind")) {
            return stack;
        }
        BiomeGenBase biomeToFind = BiomeGenBase.func_150568_d((int)nbt.func_74762_e("biomeIDToFind"));
        ItemBiomeFinder.writeNBTSearching(nbt, world);
        if (world.field_72995_K) {
            return stack;
        }
        ItemBiomeFinder.sendChatMessage(player, I18n.func_135052_a((String)"biome_finder.searching", (Object[])new Object[]{biomeToFind.field_76791_y}), EnumChatFormatting.DARK_PURPLE);
        BlockPos pos = BiomeUtils.spiralOutwardsLookingForBiome(world, biomeToFind, player.field_70165_t, player.field_70161_v);
        if (pos == null) {
            ItemBiomeFinder.sendChatMessage(player, I18n.func_135052_a((String)"biome_finder.not_found", (Object[])new Object[]{biomeToFind.field_76791_y}), EnumChatFormatting.RED);
            ItemBiomeFinder.writeNBTNotFound(nbt);
        } else {
            ItemBiomeFinder.sendChatMessage(player, I18n.func_135052_a((String)"biome_finder.found", (Object[])new Object[]{biomeToFind.field_76791_y}), EnumChatFormatting.GREEN);
            ItemBiomeFinder.writeNBTFound(nbt, pos);
        }
        return stack.func_77946_l();
    }

    public static void sendChatMessage(EntityPlayer player, String msg, EnumChatFormatting color) {
        ChatComponentText chatComponent = new ChatComponentText(msg);
        chatComponent.func_150256_b().func_150238_a(color);
        player.func_145747_a((IChatComponent)chatComponent);
    }

    public static void writeNBTSearching(NBTTagCompound nbt, World world) {
        nbt.func_74757_a("found", false);
        nbt.func_74772_a("searchStarted", world.func_72820_D());
        nbt.func_82580_o("posX");
        nbt.func_82580_o("posZ");
    }

    public static void writeNBTFound(NBTTagCompound nbt, BlockPos pos) {
        nbt.func_74757_a("found", true);
        nbt.func_82580_o("searchStarted");
        nbt.func_74768_a("posX", pos.func_177958_n());
        nbt.func_74768_a("posZ", pos.func_177952_p());
    }

    public static void writeNBTNotFound(NBTTagCompound nbt) {
        nbt.func_74757_a("found", false);
        nbt.func_82580_o("searchStarted");
        nbt.func_82580_o("posX");
        nbt.func_82580_o("posZ");
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List infoList, boolean advancedItemTooltips) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt.func_74764_b("biomeIDToFind")) {
            BiomeGenBase biomeToFind = BiomeGenBase.func_150568_d((int)nbt.func_74762_e("biomeIDToFind"));
            infoList.add(biomeToFind.field_76791_y);
        }
    }
}

