/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.config;

import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.block.BlockStateUtils;
import biomesoplenty.core.BiomesOPlenty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.io.FileUtils;

public class BOPConfig {
    public static Gson serializer = new GsonBuilder().setPrettyPrinting().create();
    public static JsonParser parser = new JsonParser();

    public static boolean writeFile(File outputFile, Object obj) {
        try {
            FileUtils.write((File)outputFile, (CharSequence)serializer.toJson(obj));
            return true;
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Error writing config file " + outputFile.getAbsolutePath() + ": " + e.getMessage());
            return false;
        }
    }

    public static class ConfigChildObj
    extends ConfigObjBase {
        protected ConfigChildObj(String prefix, JsonObject obj) {
            this.prefix = prefix;
            this.members = new HashMap();
            for (Map.Entry entry : obj.entrySet()) {
                this.members.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class ConfigFileObj
    extends ConfigObjBase {
        public ConfigFileObj(File configFile) {
            this(configFile, false);
        }

        public ConfigFileObj(File configFile, boolean warnIfMissing) {
            this.prefix = configFile.getAbsolutePath();
            String jsonString = null;
            if (configFile.exists()) {
                try {
                    jsonString = FileUtils.readFileToString((File)configFile);
                }
                catch (IOException e) {
                    this.addMessage("Error reading config file " + e.getMessage());
                }
            } else if (warnIfMissing) {
                this.addMessage("File missing");
            }
            this.parse(jsonString);
        }
    }

    public static class ConfigObj
    extends ConfigObjBase {
        public ConfigObj(String jsonString) {
            this.parse(jsonString);
        }
    }

    public static abstract class ConfigObjBase
    implements IConfigObj {
        protected Map<String, JsonElement> members;
        protected List<String> messages = new ArrayList<String>();
        protected String prefix = "";

        public void parse(String jsonString) {
            this.members = new HashMap<String, JsonElement>();
            if (jsonString == null) {
                return;
            }
            JsonElement rootElement = null;
            try {
                rootElement = parser.parse(jsonString);
                if (rootElement != null) {
                    if (rootElement.isJsonObject()) {
                        for (Map.Entry entry : rootElement.getAsJsonObject().entrySet()) {
                            this.members.put((String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    } else {
                        this.addMessage("Error parsing config: not a JSON object");
                    }
                }
            }
            catch (Exception e) {
                this.addMessage("Error parsing config: " + e.getMessage());
            }
        }

        @Override
        public void addMessage(String message) {
            this.messages.add(this.prefix + ": " + message);
        }

        @Override
        public void addMessage(String extraPrefix, String message) {
            this.messages.add(this.prefix + "." + extraPrefix + ": " + message);
        }

        @Override
        public List<String> flushMessages() {
            ArrayList<String> out = new ArrayList<String>(this.messages);
            this.messages.clear();
            return out;
        }

        @Override
        public boolean isEmpty() {
            return this.members == null || this.members.isEmpty();
        }

        @Override
        public boolean has(String name) {
            return this.members != null && this.members.containsKey(name);
        }

        @Override
        public Set<String> getKeys() {
            return this.members.keySet();
        }

        @Override
        public IConfigObj getObject(String name) {
            return this.getObject(name, false);
        }

        @Override
        public IConfigObj getObject(String name, boolean warnIfMissing) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return null;
            }
            try {
                JsonObject obj = this.members.get(name).getAsJsonObject();
                return new ConfigChildObj(this.prefix + "." + name, obj);
            }
            catch (Exception e) {
                this.addMessage("Error fetching object " + name + ": " + e.getMessage());
                return null;
            }
        }

        @Override
        public ArrayList<IConfigObj> getObjectArray(String name) {
            return this.getObjectArray(name, false);
        }

        @Override
        public ArrayList<IConfigObj> getObjectArray(String name, boolean warnIfMissing) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return null;
            }
            ArrayList<IConfigObj> list = new ArrayList<IConfigObj>();
            try {
                JsonArray arr = this.members.get(name).getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    try {
                        JsonObject obj = arr.get(i).getAsJsonObject();
                        if (obj == null) continue;
                        list.add(new ConfigChildObj(this.prefix + "." + name + "." + i, obj));
                        continue;
                    }
                    catch (Exception e) {
                        this.addMessage("Error fetching object from array " + name + " at index " + i + ": " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.addMessage("Error fetching object array " + name + ": " + e.getMessage());
                return null;
            }
            return list;
        }

        @Override
        public Boolean getBool(String name, Boolean defaultVal) {
            return this.get(name, defaultVal, false, Types.BOOLEAN);
        }

        @Override
        public String getString(String name, String defaultVal) {
            return this.get(name, defaultVal, false, Types.STRING);
        }

        @Override
        public Integer getInt(String name, Integer defaultVal) {
            return this.get(name, defaultVal, false, Types.INTEGER);
        }

        @Override
        public Float getFloat(String name, Float defaultVal) {
            return this.get(name, defaultVal, false, Types.FLOAT);
        }

        @Override
        public IBlockState getBlockState(String name, IBlockState defaultVal) {
            return this.get(name, defaultVal, false, Types.BLOCKSTATE);
        }

        @Override
        public BlockQuery.IBlockPosQuery getBlockPosQuery(String name, BlockQuery.IBlockPosQuery defaultVal) {
            return this.get(name, defaultVal, false, Types.BLOCKPOSQUERY);
        }

        @Override
        public <E extends Enum> E getEnum(String name, E defaultVal, Class<E> clazz) {
            return this.getEnum(name, defaultVal, false, clazz);
        }

        @Override
        public Boolean getBool(String name) {
            return this.get(name, null, true, Types.BOOLEAN);
        }

        @Override
        public String getString(String name) {
            return this.get(name, null, true, Types.STRING);
        }

        @Override
        public Integer getInt(String name) {
            return this.get(name, null, true, Types.INTEGER);
        }

        @Override
        public Float getFloat(String name) {
            return this.get(name, null, true, Types.FLOAT);
        }

        @Override
        public IBlockState getBlockState(String name) {
            return this.get(name, null, true, Types.BLOCKSTATE);
        }

        @Override
        public BlockQuery.IBlockPosQuery getBlockPosQuery(String name) {
            return this.get(name, null, true, Types.BLOCKPOSQUERY);
        }

        @Override
        public <E extends Enum> E getEnum(String name, Class<E> clazz) {
            return this.getEnum(name, null, true, clazz);
        }

        @Override
        public ArrayList<Boolean> getBoolArray(String name, ArrayList<Boolean> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.BOOLEAN);
        }

        @Override
        public ArrayList<String> getStringArray(String name, ArrayList<String> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.STRING);
        }

        @Override
        public ArrayList<Integer> getIntArray(String name, ArrayList<Integer> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.INTEGER);
        }

        @Override
        public ArrayList<Float> getFloatArray(String name, ArrayList<Float> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.FLOAT);
        }

        @Override
        public ArrayList<IBlockState> getBlockStateArray(String name, ArrayList<IBlockState> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.BLOCKSTATE);
        }

        @Override
        public ArrayList<BlockQuery.IBlockPosQuery> getBlockPosQueryArray(String name, ArrayList<BlockQuery.IBlockPosQuery> defaultVal) {
            return this.getArray(name, defaultVal, false, Types.BLOCKPOSQUERY);
        }

        @Override
        public <E extends Enum> ArrayList<E> getEnumArray(String name, ArrayList<E> defaultVal, Class<E> clazz) {
            return this.getEnumArray(name, defaultVal, false, clazz);
        }

        @Override
        public ArrayList<Boolean> getBoolArray(String name) {
            return this.getArray(name, null, true, Types.BOOLEAN);
        }

        @Override
        public ArrayList<String> getStringArray(String name) {
            return this.getArray(name, null, true, Types.STRING);
        }

        @Override
        public ArrayList<Integer> getIntArray(String name) {
            return this.getArray(name, null, true, Types.INTEGER);
        }

        @Override
        public ArrayList<Float> getFloatArray(String name) {
            return this.getArray(name, null, true, Types.FLOAT);
        }

        @Override
        public ArrayList<IBlockState> getBlockStateArray(String name) {
            return this.getArray(name, null, true, Types.BLOCKSTATE);
        }

        @Override
        public ArrayList<BlockQuery.IBlockPosQuery> getBlockPosQueryArray(String name) {
            return this.getArray(name, null, true, Types.BLOCKPOSQUERY);
        }

        @Override
        public <E extends Enum> ArrayList<E> getEnumArray(String name, Class<E> clazz) {
            return this.getEnumArray(name, null, true, clazz);
        }

        protected <E extends Enum> ArrayList<E> getEnumArray(String name, ArrayList<E> defaultVal, boolean warnIfMissing, Class<E> clazz) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return defaultVal;
            }
            ArrayList<E> list = new ArrayList<E>();
            try {
                JsonArray arr = this.members.get(name).getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    E ele = this.asEnum(arr.get(i), clazz, name + "." + i);
                    if (ele == null) continue;
                    list.add(ele);
                }
            }
            catch (Exception e) {
                this.addMessage(name, "Error fetching " + clazz.getName() + " array: " + e.getMessage());
            }
            return list;
        }

        protected <E extends Enum> E getEnum(String name, E defaultVal, boolean warnIfMissing, Class<E> clazz) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return defaultVal;
            }
            E out = this.asEnum(this.members.get(name), clazz, name);
            return out == null ? defaultVal : out;
        }

        private <T> T get(String name, T defaultVal, boolean warnIfMissing, Types type) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return defaultVal;
            }
            T out = this.as(this.members.get(name), type, name);
            return out == null ? defaultVal : out;
        }

        private <T> ArrayList<T> getArray(String name, ArrayList<T> defaultVal, boolean warnIfMissing, Types type) {
            if (!this.has(name)) {
                if (warnIfMissing) {
                    this.addMessage(name, "Error - missing value");
                }
                return defaultVal;
            }
            ArrayList<T> list = new ArrayList<T>();
            try {
                JsonArray arr = this.members.get(name).getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    T ele = this.as(arr.get(i), type, name + "." + i);
                    if (ele == null) continue;
                    list.add(ele);
                }
            }
            catch (Exception e) {
                this.addMessage(name, "Error fetching " + type.toString().toLowerCase() + " array: " + e.getMessage());
            }
            return list;
        }

        private <T> T as(JsonElement ele, Types type, String extraPrefix) {
            switch (type) {
                case BOOLEAN: {
                    return (T)this.asBool(ele, extraPrefix);
                }
                case STRING: {
                    return (T)this.asString(ele, extraPrefix);
                }
                case INTEGER: {
                    return (T)this.asInt(ele, extraPrefix);
                }
                case FLOAT: {
                    return (T)this.asFloat(ele, extraPrefix);
                }
                case BLOCKSTATE: {
                    return (T)this.asBlockState(ele, extraPrefix);
                }
                case BLOCKPOSQUERY: {
                    return (T)this.asBlockPosQuery(ele, extraPrefix);
                }
            }
            return null;
        }

        protected <E extends Enum> E asEnum(JsonElement ele, Class<E> clazz, String extraPrefix) {
            try {
                String val = ele.getAsString();
                Enum[] enums = (Enum[])clazz.getEnumConstants();
                if (enums == null) {
                    this.addMessage(extraPrefix, "Class " + clazz.getName() + " contains no enum constants");
                    return null;
                }
                for (Enum enumVal : enums) {
                    if (!enumVal.name().equalsIgnoreCase(val)) continue;
                    return (E)enumVal;
                }
                this.addMessage(extraPrefix, "Value " + val + " does not exist in enum " + clazz);
                return null;
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching string: " + e.getMessage());
                return null;
            }
        }

        protected Boolean asBool(JsonElement ele, String extraPrefix) {
            try {
                return ele.getAsBoolean();
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching boolean: " + e.getMessage());
                return null;
            }
        }

        protected String asString(JsonElement ele, String extraPrefix) {
            try {
                return ele.getAsString();
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching string: " + e.getMessage());
                return null;
            }
        }

        protected Integer asInt(JsonElement ele, String extraPrefix) {
            try {
                return ele.getAsInt();
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching integer: " + e.getMessage());
                return null;
            }
        }

        protected Float asFloat(JsonElement ele, String extraPrefix) {
            try {
                return Float.valueOf(ele.getAsFloat());
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching float: " + e.getMessage());
                return null;
            }
        }

        protected BlockQuery.IBlockPosQuery asBlockPosQuery(JsonElement ele, String extraPrefix) {
            try {
                String queryString = ele.getAsString();
                try {
                    return BlockQuery.parseQueryString(queryString);
                }
                catch (BlockQuery.BlockQueryParseException e) {
                    this.addMessage(extraPrefix, "Error parsing BlockPosQuery " + queryString + " - " + e.getMessage());
                    return null;
                }
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching string: " + e.getMessage());
                return null;
            }
        }

        protected IBlockState asBlockState(JsonElement ele, String extraPrefix) {
            try {
                JsonObject obj = ele.getAsJsonObject();
                if (!obj.has("block")) {
                    this.addMessage(extraPrefix, "Block name missing");
                    return null;
                }
                JsonElement blockName = obj.get("block");
                if (!blockName.isJsonPrimitive()) {
                    this.addMessage(extraPrefix, "Invalid block name - must be a string");
                    return null;
                }
                Block block = Block.func_149684_b((String)blockName.getAsString());
                if (block == null) {
                    this.addMessage(extraPrefix, "Unrecognised block name " + blockName.getAsString());
                    return null;
                }
                IBlockState state = block.func_176223_P();
                if (obj.has("properties")) {
                    JsonElement properties = obj.get("properties");
                    if (!properties.isJsonObject()) {
                        this.addMessage(extraPrefix, "Invalid properties list - must be a JSON object");
                        return state;
                    }
                    for (Map.Entry entry : properties.getAsJsonObject().entrySet()) {
                        IProperty property = BlockStateUtils.getPropertyByName(state, (String)entry.getKey());
                        if (property != null) {
                            Comparable propertyValue = BlockStateUtils.getPropertyValueByName(state, property, ((JsonElement)entry.getValue()).getAsString());
                            if (propertyValue != null) {
                                state = state.func_177226_a(property, propertyValue);
                                continue;
                            }
                            this.addMessage(extraPrefix, "Invalid value " + ((JsonElement)entry.getValue()).getAsString() + " for property " + (String)entry.getKey());
                            continue;
                        }
                        this.addMessage(extraPrefix, "Invalid property name: " + (String)entry.getKey());
                    }
                }
                return state;
            }
            catch (Exception e) {
                this.addMessage(extraPrefix, "Error fetching blockstate: " + e.getMessage());
                return null;
            }
        }
    }

    public static interface IConfigObj {
        public void addMessage(String var1);

        public void addMessage(String var1, String var2);

        public List<String> flushMessages();

        public boolean isEmpty();

        public boolean has(String var1);

        public Set<String> getKeys();

        public IConfigObj getObject(String var1);

        public ArrayList<IConfigObj> getObjectArray(String var1);

        public IConfigObj getObject(String var1, boolean var2);

        public ArrayList<IConfigObj> getObjectArray(String var1, boolean var2);

        public Boolean getBool(String var1, Boolean var2);

        public String getString(String var1, String var2);

        public Integer getInt(String var1, Integer var2);

        public Float getFloat(String var1, Float var2);

        public IBlockState getBlockState(String var1, IBlockState var2);

        public BlockQuery.IBlockPosQuery getBlockPosQuery(String var1, BlockQuery.IBlockPosQuery var2);

        public <E extends Enum> E getEnum(String var1, E var2, Class<E> var3);

        public Boolean getBool(String var1);

        public String getString(String var1);

        public Integer getInt(String var1);

        public Float getFloat(String var1);

        public IBlockState getBlockState(String var1);

        public BlockQuery.IBlockPosQuery getBlockPosQuery(String var1);

        public <E extends Enum> E getEnum(String var1, Class<E> var2);

        public ArrayList<Boolean> getBoolArray(String var1, ArrayList<Boolean> var2);

        public ArrayList<String> getStringArray(String var1, ArrayList<String> var2);

        public ArrayList<Integer> getIntArray(String var1, ArrayList<Integer> var2);

        public ArrayList<Float> getFloatArray(String var1, ArrayList<Float> var2);

        public ArrayList<IBlockState> getBlockStateArray(String var1, ArrayList<IBlockState> var2);

        public ArrayList<BlockQuery.IBlockPosQuery> getBlockPosQueryArray(String var1, ArrayList<BlockQuery.IBlockPosQuery> var2);

        public <E extends Enum> ArrayList<E> getEnumArray(String var1, ArrayList<E> var2, Class<E> var3);

        public ArrayList<Boolean> getBoolArray(String var1);

        public ArrayList<String> getStringArray(String var1);

        public ArrayList<Integer> getIntArray(String var1);

        public ArrayList<Float> getFloatArray(String var1);

        public ArrayList<IBlockState> getBlockStateArray(String var1);

        public ArrayList<BlockQuery.IBlockPosQuery> getBlockPosQueryArray(String var1);

        public <E extends Enum> ArrayList<E> getEnumArray(String var1, Class<E> var2);
    }

    private static enum Types {
        BOOLEAN,
        STRING,
        INTEGER,
        FLOAT,
        BLOCKSTATE,
        BLOCKPOSQUERY;

    }
}

