/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.NoiseGeneratorBOPByte;
import biomesoplenty.common.world.TerrainSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderGenerateBOP
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves xyzNoiseGenA;
    private NoiseGeneratorOctaves xyzNoiseGenB;
    private NoiseGeneratorOctaves xyzBalanceNoiseGen;
    private NoiseGeneratorPerlin stoneNoiseGen;
    public NoiseGeneratorBOPByte byteNoiseGen;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private BOPWorldSettings settings;
    private IBlockState seaBlockState;
    private IBlockState stoneBlockState;
    private MapGenBase caveGenerator;
    private MapGenStronghold strongholdGenerator;
    private MapGenVillage villageGenerator;
    private MapGenMineshaft mineshaftGenerator;
    private MapGenScatteredFeature scatteredFeatureGenerator;
    private MapGenBase ravineGenerator;
    private StructureOceanMonument oceanMonumentGenerator;
    private double[] xyzBalanceNoiseArray;
    private double[] xyzNoiseArrayA;
    private double[] xyzNoiseArrayB;
    private double[] stoneNoiseArray;
    private final double[] noiseArray;
    private Map<BiomeGenBase, TerrainSettings> biomeTerrainSettings;
    private static float[] radialFalloff5x5 = new float[25];
    private static float[] radialStrongFalloff5x5 = new float[25];

    public ChunkProviderGenerateBOP(World worldIn, long seed, boolean mapFeaturesEnabled, String chunkProviderSettingsString) {
        System.out.println("ChunkProviderGenerateBOP json: " + chunkProviderSettingsString);
        this.worldObj = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        this.rand = new Random(seed);
        this.settings = new BOPWorldSettings(chunkProviderSettingsString);
        System.out.println("ChunkProviderGenerateBOP settings: " + this.settings.toJson());
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)new StructureOceanMonument(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.xyzNoiseGenA = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzNoiseGenB = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzBalanceNoiseGen = new NoiseGeneratorOctaves(this.rand, 8);
        this.stoneNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        this.byteNoiseGen = new NoiseGeneratorBOPByte(this.rand, 6, 5, 5);
        this.stoneNoiseArray = new double[256];
        this.noiseArray = new double[825];
        this.stoneBlockState = Blocks.field_150348_b.func_176223_P();
        this.seaBlockState = Blocks.field_150355_j.func_176223_P();
        this.biomeTerrainSettings = new HashMap<BiomeGenBase, TerrainSettings>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            this.biomeTerrainSettings.put(biome, biome instanceof BOPBiome ? ((BOPBiome)biome).terrainSettings : TerrainSettings.forVanillaBiome(biome));
        }
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setChunkAirStoneWater(chunkX, chunkZ, chunkprimer);
        BiomeGenBase[] biomes = this.worldObj.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, biomes);
        if (this.settings.useCaves) {
            this.caveGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useRavines) {
            this.ravineGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useMineShafts && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useVillages && this.mapFeaturesEnabled) {
            this.villageGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useStrongholds && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useTemples && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.settings.useMonuments && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175792_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int k = 0; k < chunkBiomes.length; ++k) {
            chunkBiomes[k] = (byte)biomes[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setChunkAirStoneWater(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.populateNoiseArray(chunkX, chunkZ);
        double oneEighth = 0.125;
        double oneQuarter = 0.25;
        for (int ix = 0; ix < 4; ++ix) {
            int k_x0 = ix * 5;
            int k_x1 = (ix + 1) * 5;
            for (int iz = 0; iz < 4; ++iz) {
                int k_x0z0 = (k_x0 + iz) * 33;
                int k_x0z1 = (k_x0 + iz + 1) * 33;
                int k_x1z0 = (k_x1 + iz) * 33;
                int k_x1z1 = (k_x1 + iz + 1) * 33;
                for (int iy = 0; iy < 32; ++iy) {
                    double n_x0y0z0 = this.noiseArray[k_x0z0 + iy];
                    double n_x0y0z1 = this.noiseArray[k_x0z1 + iy];
                    double n_x1y0z0 = this.noiseArray[k_x1z0 + iy];
                    double n_x1y0z1 = this.noiseArray[k_x1z1 + iy];
                    double n_x0y1z0 = this.noiseArray[k_x0z0 + iy + 1];
                    double n_x0y1z1 = this.noiseArray[k_x0z1 + iy + 1];
                    double n_x1y1z0 = this.noiseArray[k_x1z0 + iy + 1];
                    double n_x1y1z1 = this.noiseArray[k_x1z1 + iy + 1];
                    double noiseStepY00 = (n_x0y1z0 - n_x0y0z0) * oneEighth;
                    double noiseStepY01 = (n_x0y1z1 - n_x0y0z1) * oneEighth;
                    double noiseStepY10 = (n_x1y1z0 - n_x1y0z0) * oneEighth;
                    double noiseStepY11 = (n_x1y1z1 - n_x1y0z1) * oneEighth;
                    double noiseStartX0 = n_x0y0z0;
                    double noiseStartX1 = n_x0y0z1;
                    double noiseEndX0 = n_x1y0z0;
                    double noiseEndX1 = n_x1y0z1;
                    for (int jy = 0; jy < 8; ++jy) {
                        double noiseStartZ = noiseStartX0;
                        double noiseEndZ = noiseStartX1;
                        double noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        double noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int jx = 0; jx < 4; ++jx) {
                            double noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            double noiseVal = noiseStartZ;
                            for (int jz = 0; jz < 4; ++jz) {
                                if (noiseVal > 0.0) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, this.stoneBlockState);
                                } else if (iy * 8 + jy < this.settings.seaLevel) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, this.seaBlockState);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkX, chunkZ, primer, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoiseArray = this.stoneNoiseGen.func_151599_a(this.stoneNoiseArray, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                BiomeGenBase biome = biomes[localZ + localX * 16];
                biome.func_180622_a(this.worldObj, this.rand, primer, chunkX * 16 + localX, chunkZ * 16 + localZ, this.stoneNoiseArray[localZ + localX * 16]);
            }
        }
    }

    private TerrainSettings getWeightedTerrainSettings(int localX, int localZ, BiomeGenBase[] biomes) {
        BiomeGenBase centerBiome = biomes[localX + 2 + (localZ + 2) * 10];
        if (centerBiome == BiomeGenBase.field_76781_i || centerBiome == BiomeGenBase.field_76777_m || centerBiome instanceof BOPBiome && ((BOPBiome)centerBiome).noNeighborTerrainInfuence) {
            return this.biomeTerrainSettings.get(centerBiome);
        }
        TerrainSettings settings = new TerrainSettings();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float weight = radialFalloff5x5[i + 2 + (j + 2) * 5];
                TerrainSettings biomeSettings = this.biomeTerrainSettings.get(biomes[localX + i + 2 + (localZ + j + 2) * 10]);
                if (biomeSettings == null) continue;
                settings.avgHeight += (double)weight * biomeSettings.avgHeight;
                settings.variationAbove += (double)weight * biomeSettings.variationAbove;
                settings.variationBelow += (double)weight * biomeSettings.variationBelow;
                settings.minHeight += (double)weight * biomeSettings.minHeight;
                settings.maxHeight += (double)weight * biomeSettings.maxHeight;
                settings.sidewaysNoiseAmount += (double)weight * biomeSettings.sidewaysNoiseAmount;
                for (int k = 0; k < settings.octaveWeights.length; ++k) {
                    int n = k;
                    settings.octaveWeights[n] = settings.octaveWeights[n] + (double)weight * biomeSettings.octaveWeights[k];
                }
            }
        }
        return settings;
    }

    private void populateNoiseArray(int chunkX, int chunkZ) {
        BiomeGenBase[] biomes = this.worldObj.func_72959_q().func_76937_a(null, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        float coordinateScale = 684.412f;
        float heightScale = 684.412f;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        float mainNoiseScaleX = 80.0f;
        float mainNoiseScaleY = 160.0f;
        float mainNoiseScaleZ = 80.0f;
        int subchunkX = chunkX * 4;
        int subchunkY = 0;
        int subchunkZ = chunkZ * 4;
        this.byteNoiseGen.generateNoise(subchunkX, subchunkZ);
        this.xyzBalanceNoiseArray = this.xyzBalanceNoiseGen.func_76304_a(this.xyzBalanceNoiseArray, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)(coordinateScale / mainNoiseScaleX), (double)(heightScale / mainNoiseScaleY), (double)(coordinateScale / mainNoiseScaleZ));
        this.xyzNoiseArrayA = this.xyzNoiseGenA.func_76304_a(this.xyzNoiseArrayA, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        this.xyzNoiseArrayB = this.xyzNoiseGenB.func_76304_a(this.xyzNoiseArrayB, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        int xyzCounter = 0;
        int xzCounter = 0;
        for (int ix = 0; ix < 5; ++ix) {
            for (int iz = 0; iz < 5; ++iz) {
                TerrainSettings settings = this.getWeightedTerrainSettings(ix, iz, biomes);
                double xzNoiseVal = this.byteNoiseGen.getWeightedDouble(xzCounter, settings.octaveWeights);
                double xzAmplitude = (double)this.settings.amplitude * (xzNoiseVal < 0.0 ? settings.variationBelow : settings.variationAbove) * (1.0 - settings.sidewaysNoiseAmount);
                double xyzAmplitude = (double)this.settings.amplitude * (xzNoiseVal < 0.0 ? settings.variationBelow : settings.variationAbove) * settings.sidewaysNoiseAmount;
                double baseLevel = settings.avgHeight + xzNoiseVal * xzAmplitude;
                for (int iy = 0; iy < 33; ++iy) {
                    int y = iy * 8;
                    if ((double)y < settings.minHeight) {
                        this.noiseArray[xyzCounter] = settings.minHeight - (double)y;
                    } else if ((double)y > settings.maxHeight) {
                        this.noiseArray[xyzCounter] = settings.maxHeight - (double)y;
                    } else {
                        double xyzNoiseA = this.xyzNoiseArrayA[xyzCounter] / lowerLimitScale;
                        double xyzNoiseB = this.xyzNoiseArrayB[xyzCounter] / upperLimitScale;
                        double balance = (this.xyzBalanceNoiseArray[xyzCounter] / 10.0 + 1.0) / 2.0;
                        double xyzNoiseValue = MathHelper.func_151238_b((double)xyzNoiseA, (double)xyzNoiseB, (double)balance) / 50.0;
                        double depth = baseLevel - (double)y + xyzAmplitude * xyzNoiseValue;
                        if (iy > 29) {
                            double closeToTopOfChunkFactor = (float)(iy - 29) / 3.0f;
                            depth = depth * (1.0 - closeToTopOfChunkFactor) + -10.0 * closeToTopOfChunkFactor;
                        }
                        this.noiseArray[xyzCounter] = depth;
                    }
                    ++xyzCounter;
                }
                ++xzCounter;
            }
        }
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        int i;
        BlockPos target;
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        BiomeGenBase biomegenbase = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l0 = this.rand.nextLong() / 2L * 2L + 1L;
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l0 + (long)chunkZ * l1 ^ this.worldObj.func_72905_C());
        boolean hasVillageGenerated = false;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkX, chunkZ);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillageGenerated));
        if (this.settings.useMineShafts && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.useVillages && this.mapFeaturesEnabled) {
            hasVillageGenerated = this.villageGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.useStrongholds && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.useTemples && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.useMonuments && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        BlockPos decorateStart = blockpos.func_177982_a(8, 0, 8);
        if (biomegenbase.field_76751_G > 0.01f && biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && this.settings.useWaterLakes && !hasVillageGenerated && this.rand.nextInt(this.settings.waterLakeChance) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16));
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, target);
        }
        if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !hasVillageGenerated && this.rand.nextInt(this.settings.lavaLakeChance / 10) == 0 && this.settings.useLavaLakes && ((target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(248) + 8, this.rand.nextInt(16))).func_177956_o() < 63 || this.rand.nextInt(this.settings.lavaLakeChance / 8) == 0)) {
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, target);
        }
        if (this.settings.useDungeons && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (i = 0; i < this.settings.dungeonChance; ++i) {
                target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16));
                new WorldGenDungeons().func_180709_b(this.worldObj, this.rand, target);
            }
        }
        biomegenbase.func_180624_a(this.worldObj, this.rand, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    target = this.worldObj.func_175725_q(decorateStart.func_177982_a(i, 0, j));
                    BiomeGenBase biome = this.worldObj.func_180494_b(target);
                    if (this.worldObj.func_175675_v(target.func_177977_b())) {
                        this.worldObj.func_180501_a(target.func_177977_b(), Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!(biome.field_76751_G > 0.01f) || !this.worldObj.func_175708_f(target, true)) continue;
                    this.worldObj.func_180501_a(target, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillageGenerated));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_177460_a(IChunkProvider p_177460_1_, Chunk p_177460_2_, int p_177460_3_, int p_177460_4_) {
        boolean flag = false;
        if (this.settings.useMonuments && this.mapFeaturesEnabled && p_177460_2_.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkCoordIntPair(p_177460_3_, p_177460_4_));
        }
        return flag;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        BiomeGenBase biomegenbase = this.worldObj.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.settings.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return "Stronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(worldIn, position) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
        if (this.settings.useMineShafts && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.useVillages && this.mapFeaturesEnabled) {
            this.villageGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.useStrongholds && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.useTemples && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.useMonuments && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
    }

    public Chunk func_177459_a(BlockPos blockPosIn) {
        return this.func_73154_d(blockPosIn.func_177958_n() >> 4, blockPosIn.func_177952_p() >> 4);
    }

    static {
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                ChunkProviderGenerateBOP.radialFalloff5x5[j + 2 + (k + 2) * 5] = 0.064761624f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
                ChunkProviderGenerateBOP.radialStrongFalloff5x5[j + 2 + (k + 2) * 5] = 0.07616052f / ((float)(j * j + k * k) + 0.2f);
            }
        }
    }
}

