/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderGenerateVanilla
implements IChunkProvider {
    private static Random debugRand = new Random();
    private Random rand;
    private NoiseGeneratorOctaves xyzLowerLimitNoiseGen;
    private NoiseGeneratorOctaves xyzUpperLimitNoiseGen;
    private NoiseGeneratorOctaves xyzBalanceNoiseGen;
    private NoiseGeneratorPerlin noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private WorldType field_177475_o;
    private final double[] noiseArray;
    private ChunkProviderSettings settings;
    private Block seaBlock = Blocks.field_150355_j;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private StructureOceanMonument oceanMonumentGenerator = new StructureOceanMonument();
    private BiomeGenBase[] biomesForGeneration;
    double[] balanceNoiseArray;
    double[] xyzLowerLimitNoiseArray;
    double[] xyzUpperLimitNoiseArray;
    double[] xzNoiseArray;
    private static float[] radialFalloff5x5 = new float[25];

    public ChunkProviderGenerateVanilla(World worldIn, long p_i45636_2_, boolean p_i45636_4_, String p_i45636_5_) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.worldObj = worldIn;
        this.mapFeaturesEnabled = p_i45636_4_;
        this.field_177475_o = worldIn.func_72912_H().func_76067_t();
        this.rand = new Random(p_i45636_2_);
        this.xyzLowerLimitNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzUpperLimitNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzBalanceNoiseGen = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseArray = new double[825];
        if (p_i45636_5_ != null) {
            this.settings = ChunkProviderSettings.Factory.func_177865_a((String)p_i45636_5_).func_177864_b();
            this.seaBlock = this.settings.field_177778_E ? Blocks.field_150353_l : Blocks.field_150355_j;
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.xyzLowerLimitNoiseGen, this.xyzUpperLimitNoiseGen, this.xyzBalanceNoiseGen, this.noiseGen4, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (NoiseGenerator[])noiseGens);
        this.xyzLowerLimitNoiseGen = (NoiseGeneratorOctaves)noiseGens[0];
        this.xyzUpperLimitNoiseGen = (NoiseGeneratorOctaves)noiseGens[1];
        this.xyzBalanceNoiseGen = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
        this.mobSpawnerNoise = (NoiseGeneratorOctaves)noiseGens[6];
    }

    public void setBlocksInChunk(int p_180518_1_, int p_180518_2_, ChunkPrimer p_180518_3_) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, p_180518_1_ * 4 - 2, p_180518_2_ * 4 - 2, 10, 10);
        this.populateNoiseArray(p_180518_1_ * 4, 0, p_180518_2_ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.noiseArray[k1 + k2];
                    double d2 = this.noiseArray[l1 + k2];
                    double d3 = this.noiseArray[i2 + k2];
                    double d4 = this.noiseArray[j2 + k2];
                    double d5 = (this.noiseArray[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.noiseArray[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.noiseArray[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.noiseArray[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int j3 = 0; j3 < 4; ++j3) {
                                double d;
                                d15 += d16;
                                if (d > 0.0) {
                                    p_180518_3_.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + j3, Blocks.field_150348_b.func_176223_P());
                                    continue;
                                }
                                if (k2 * 8 + l2 >= this.settings.field_177841_q) continue;
                                p_180518_3_.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + j3, this.seaBlock.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int p_180517_1_, int p_180517_2_, ChunkPrimer p_180517_3_, BiomeGenBase[] p_180517_4_) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, p_180517_1_, p_180517_2_, p_180517_3_, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(p_180517_1_ * 16), (double)(p_180517_2_ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = p_180517_4_[l + k * 16];
                biomegenbase.func_180622_a(this.worldObj, this.rand, p_180517_3_, p_180517_1_ * 16 + k, p_180517_2_ * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, chunkprimer, this.biomesForGeneration);
        if (this.settings.field_177839_r) {
            this.caveGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177850_z) {
            this.ravineGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177829_w && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177831_v && this.mapFeaturesEnabled) {
            this.villageGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177833_u && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177854_x && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        if (this.settings.field_177852_y && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175792_a((IChunkProvider)this, this.worldObj, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private TerrainSettings getWeightedTerrainSettings(int localX, int localZ) {
        TerrainSettings settings = new TerrainSettings();
        float totalWeight = 0.0f;
        BiomeGenBase centerBiome = this.biomesForGeneration[localX + 2 + (localZ + 2) * 10];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BiomeGenBase surroundingBiome = this.biomesForGeneration[localX + i + 2 + (localZ + j + 2) * 10];
                float depth = this.settings.field_177813_n + surroundingBiome.field_76748_D * this.settings.field_177819_m;
                float scale = this.settings.field_177843_p + surroundingBiome.field_76749_E * this.settings.field_177815_o;
                if (this.field_177475_o == WorldType.field_151360_e && depth > 0.0f) {
                    depth = 1.0f + depth * 2.0f;
                    scale = 1.0f + scale * 4.0f;
                }
                float weight = radialFalloff5x5[i + 2 + (j + 2) * 5] / (depth + 2.0f);
                if (surroundingBiome.field_76748_D > centerBiome.field_76748_D) {
                    weight /= 2.0f;
                }
                settings.scale += (double)(scale * weight);
                settings.depth += (double)(depth * weight);
                totalWeight += weight;
            }
        }
        settings.scale /= (double)totalWeight;
        settings.depth /= (double)totalWeight;
        return settings;
    }

    private void populateNoiseArray(int subchunkX, int subchunkY, int subchunkZ) {
        float coordinateScale = this.settings.field_177811_a;
        float heightScale = this.settings.field_177809_b;
        this.xzNoiseArray = this.noiseGen6.func_76305_a(this.xzNoiseArray, subchunkX, subchunkZ, 5, 5, (double)this.settings.field_177808_e, (double)this.settings.field_177803_f, (double)this.settings.field_177804_g);
        this.balanceNoiseArray = this.xyzBalanceNoiseGen.func_76304_a(this.balanceNoiseArray, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)(coordinateScale / this.settings.field_177825_h), (double)(heightScale / this.settings.field_177827_i), (double)(coordinateScale / this.settings.field_177821_j));
        this.xyzLowerLimitNoiseArray = this.xyzLowerLimitNoiseGen.func_76304_a(this.xyzLowerLimitNoiseArray, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        this.xyzUpperLimitNoiseArray = this.xyzUpperLimitNoiseGen.func_76304_a(this.xyzUpperLimitNoiseArray, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        int xyzCounter = 0;
        int xzCounter = 0;
        for (int ix = 0; ix < 5; ++ix) {
            for (int iz = 0; iz < 5; ++iz) {
                boolean debug = debugRand.nextInt(100) == 0;
                TerrainSettings settings = this.getWeightedTerrainSettings(ix, iz);
                double xzNoiseVal = this.xzNoiseArray[xzCounter];
                if ((xzNoiseVal /= 8000.0) < 0.0) {
                    xzNoiseVal = -xzNoiseVal * 0.3;
                }
                if ((xzNoiseVal = xzNoiseVal * 3.0 - 2.0) < 0.0) {
                    if ((xzNoiseVal /= 2.0) < -1.0) {
                        xzNoiseVal = -1.0;
                    }
                    xzNoiseVal /= 2.8;
                } else {
                    if (xzNoiseVal > 1.0) {
                        xzNoiseVal = 1.0;
                    }
                    xzNoiseVal /= 8.0;
                }
                double depth = (settings.depth * 4.0 - 1.0) / 16.0;
                double scale = settings.scale * 0.9 + 0.1;
                double groundLevel = (double)this.settings.field_177823_k * (1.0 + depth + (xzNoiseVal /= 10.0));
                for (int iy = 0; iy < 33; ++iy) {
                    double distanceAboveGroundFactor = ((double)iy - groundLevel) * (double)this.settings.field_177817_l * 128.0 / 256.0 / scale;
                    if (distanceAboveGroundFactor < 0.0) {
                        distanceAboveGroundFactor *= 4.0;
                    }
                    double lowerLimit = this.xyzLowerLimitNoiseArray[xyzCounter] / (double)this.settings.field_177806_d;
                    double upperLimit = this.xyzUpperLimitNoiseArray[xyzCounter] / (double)this.settings.field_177810_c;
                    double balance = (this.balanceNoiseArray[xyzCounter] / 10.0 + 1.0) / 2.0;
                    double sidewaysNoise = MathHelper.func_151238_b((double)lowerLimit, (double)upperLimit, (double)balance);
                    double noiseVal = sidewaysNoise - distanceAboveGroundFactor;
                    if (iy > 29) {
                        double closeToTopOfChunkFactor = (float)(iy - 29) / 3.0f;
                        noiseVal = noiseVal * (1.0 - closeToTopOfChunkFactor) + -10.0 * closeToTopOfChunkFactor;
                    }
                    this.noiseArray[xyzCounter] = noiseVal;
                    ++xyzCounter;
                }
                ++xzCounter;
            }
        }
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        boolean doGen;
        int i2;
        int l1;
        int k1;
        BlockFalling.field_149832_M = true;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        BiomeGenBase biomegenbase = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)p_73153_2_ * i1 + (long)p_73153_3_ * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(p_73153_2_, p_73153_3_);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(p_73153_1_, this.worldObj, this.rand, p_73153_2_, p_73153_3_, flag));
        if (this.settings.field_177829_w && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.field_177831_v && this.mapFeaturesEnabled) {
            flag = this.villageGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.field_177833_u && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.field_177854_x && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (this.settings.field_177852_y && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && this.settings.field_177781_A && !flag && this.rand.nextInt(this.settings.field_177782_B) == 0 && TerrainGen.populate((IChunkProvider)p_73153_1_, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(256);
            i2 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(k1, l1, i2));
        }
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag && this.rand.nextInt(this.settings.field_177777_D / 10) == 0 && this.settings.field_177783_C) {
            k1 = this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            i2 = this.rand.nextInt(16) + 8;
            if (l1 < 63 || this.rand.nextInt(this.settings.field_177777_D / 8) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(k1, l1, i2));
            }
        }
        if (this.settings.field_177837_s) {
            doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            for (k1 = 0; doGen && k1 < this.settings.field_177835_t; ++k1) {
                l1 = this.rand.nextInt(16) + 8;
                i2 = this.rand.nextInt(256);
                int j2 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(l1, i2, j2));
            }
        }
        biomegenbase.func_180624_a(this.worldObj, this.rand, new BlockPos(k, 0, l));
        if (TerrainGen.populate((IChunkProvider)p_73153_1_, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        doGen = TerrainGen.populate((IChunkProvider)p_73153_1_, (World)this.worldObj, (Random)this.rand, (int)p_73153_2_, (int)p_73153_3_, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k1, 0, l1));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.worldObj.func_175675_v(blockpos2)) {
                    this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(p_73153_1_, this.worldObj, this.rand, p_73153_2_, p_73153_3_, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_177460_a(IChunkProvider p_177460_1_, Chunk p_177460_2_, int p_177460_3_, int p_177460_4_) {
        boolean flag = false;
        if (this.settings.field_177852_y && this.mapFeaturesEnabled && p_177460_2_.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkCoordIntPair(p_177460_3_, p_177460_4_));
        }
        return flag;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        BiomeGenBase biomegenbase = this.worldObj.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.settings.field_177852_y && this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return "Stronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(worldIn, position) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
        if (this.settings.field_177829_w && this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.field_177831_v && this.mapFeaturesEnabled) {
            this.villageGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.field_177833_u && this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.field_177854_x && this.mapFeaturesEnabled) {
            this.scatteredFeatureGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
        if (this.settings.field_177852_y && this.mapFeaturesEnabled) {
            this.oceanMonumentGenerator.func_175792_a((IChunkProvider)this, this.worldObj, p_180514_2_, p_180514_3_, (ChunkPrimer)null);
        }
    }

    public Chunk func_177459_a(BlockPos blockPosIn) {
        return this.func_73154_d(blockPosIn.func_177958_n() >> 4, blockPosIn.func_177952_p() >> 4);
    }

    static {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkProviderGenerateVanilla.radialFalloff5x5[x + 2 + (z + 2) * 5] = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    }

    public static class TerrainSettings {
        public double depth = 0.0;
        public double scale = 0.0;
    }
}

