/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.NoiseGenerator;

public class NoiseGeneratorBOP
extends NoiseGenerator {
    private int[] permutations = new int[512];
    public double offsetU;
    public double offsetV;
    public double offsetW;
    private static final double[] rc2_a = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] rc2_b = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};
    private static final double[] rc3_a = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] rc3_b = new double[]{1.0, 1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0};
    private static final double[] rc3_c = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};

    public NoiseGeneratorBOP() {
        this(new Random());
    }

    public NoiseGeneratorBOP(Random rand) {
        int i;
        this.offsetU = rand.nextDouble() * 256.0;
        this.offsetV = rand.nextDouble() * 256.0;
        this.offsetW = rand.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.permutations[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256 - i) + i;
            int k = this.permutations[i];
            this.permutations[i] = this.permutations[j];
            this.permutations[j] = k;
            this.permutations[i + 256] = this.permutations[i];
        }
    }

    public final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public final double randomCombineTwo(int seed, double a, double b) {
        int j = seed & 0xF;
        return rc2_a[j] * a + rc2_b[j] * b;
    }

    public final double randomCombineThree(int seed, double a, double b, double c) {
        int j = seed & 0xF;
        return rc3_a[j] * a + rc3_b[j] * b + rc3_c[j] * c;
    }

    public double wraparound(double d) {
        long intD = MathHelper.func_76124_d((double)d);
        return d - (double)intD + (double)(intD % 0x1000000L);
    }

    public double[] populateNoiseArrayXZ(int chunkX, int chunkZ, int numX, int numZ, double wavelength, double amplitude) {
        int index = 0;
        double[] out = new double[numX * numZ];
        double sampleSpacing = 4.0 / wavelength;
        double startU = (double)(chunkX * 16) / wavelength + this.offsetU;
        double startV = (double)(chunkZ * 16) / wavelength + this.offsetV;
        startU = this.wraparound(startU);
        startV = this.wraparound(startV);
        for (int i = 0; i < numX; ++i) {
            double u = startU + (double)i * sampleSpacing;
            int intU = (int)u;
            if (u < (double)intU) {
                --intU;
            }
            double fracU = u - (double)intU;
            double tu = fracU * fracU * fracU * (fracU * (fracU * 6.0 - 15.0) + 10.0);
            int permX0 = this.permutations[intU &= 0xFF];
            int permX1 = this.permutations[intU + 1];
            for (int j = 0; j < numZ; ++j) {
                double v = startV + (double)j * sampleSpacing;
                int intV = (int)v;
                if (v < (double)intV) {
                    --intV;
                }
                double fracV = v - (double)intV;
                double tv = fracV * fracV * fracV * (fracV * (fracV * 6.0 - 15.0) + 10.0);
                int permZ0 = this.permutations[permX0] + (intV &= 0xFF);
                int permZ1 = this.permutations[permX1] + intV;
                double val00 = this.randomCombineTwo(this.permutations[permZ0], fracU, fracV);
                double val01 = this.randomCombineTwo(this.permutations[permZ1], fracU - 1.0, fracV);
                double val10 = this.randomCombineTwo(this.permutations[permZ0 + 1], fracU, fracV - 1.0);
                double val11 = this.randomCombineTwo(this.permutations[permZ1 + 1], fracU - 1.0, fracV - 1.0);
                double val0 = this.lerp(tu, val00, val01);
                double val1 = this.lerp(tu, val10, val11);
                double val = this.lerp(tv, val0, val1);
                out[index] = val * amplitude;
                ++index;
            }
        }
        return out;
    }

    public void populateNoiseArray(int chunkX, int chunkZ, int numX, int numY, int numZ, double wavelength, double amplitude) {
        int index = 0;
        double[] out = new double[numX * numY * numZ];
        double sampleSpacing = 4.0 / wavelength;
        double startU = (double)(chunkX * 16) / wavelength + this.offsetU;
        double startV = this.offsetV;
        double startW = (double)(chunkZ * 16) / wavelength + this.offsetW;
        startU = this.wraparound(startU);
        startV = this.wraparound(startV);
        startV = this.wraparound(startW);
        for (int i = 0; i < numX; ++i) {
            double u = startU + (double)i * sampleSpacing;
            int intU = (int)u;
            if (u < (double)intU) {
                --intU;
            }
            double fracU = u - (double)intU;
            intU &= 0xFF;
            double tu = fracU * fracU * fracU * (fracU * (fracU * 6.0 - 15.0) + 10.0);
            for (int j = 0; j < numZ; ++j) {
                double v = startV + (double)j * sampleSpacing;
                int intV = (int)v;
                if (v < (double)intV) {
                    --intV;
                }
                double fracV = v - (double)intV;
                intV &= 0xFF;
                double tv = fracV * fracV * fracV * (fracV * (fracV * 6.0 - 15.0) + 10.0);
                for (int k = 0; k < numY; ++k) {
                    double w = startW + (double)k * sampleSpacing;
                    int intW = (int)w;
                    if (w < (double)intW) {
                        --intW;
                    }
                    double fracW = w - (double)intW;
                    double tw = fracW * fracW * fracW * (fracW * (fracW * 6.0 - 15.0) + 10.0);
                    int perm0 = this.permutations[intU] + (intW &= 0xFF);
                    int perm1 = this.permutations[perm0] + intV;
                    int perm2 = this.permutations[perm0 + 1] + intV;
                    int perm3 = this.permutations[intU + 1] + intW;
                    int perm4 = this.permutations[perm3] + intV;
                    int perm5 = this.permutations[perm3 + 1] + intV;
                    double val000 = this.randomCombineThree(this.permutations[perm1], u, fracW, fracV);
                    double val001 = this.randomCombineThree(this.permutations[perm4], u - 1.0, fracW, fracV);
                    double val010 = this.randomCombineThree(this.permutations[perm2], u, fracW - 1.0, fracV);
                    double val011 = this.randomCombineThree(this.permutations[perm5], u - 1.0, fracW - 1.0, fracV);
                    double val100 = this.randomCombineThree(this.permutations[perm1 + 1], u, fracW, fracV - 1.0);
                    double val101 = this.randomCombineThree(this.permutations[perm4 + 1], u - 1.0, fracW, fracV - 1.0);
                    double val110 = this.randomCombineThree(this.permutations[perm2 + 1], u, fracW - 1.0, fracV - 1.0);
                    double val111 = this.randomCombineThree(this.permutations[perm5 + 1], u - 1.0, fracW - 1.0, fracV - 1.0);
                    double val00 = this.lerp(tu, val000, val001);
                    double val01 = this.lerp(tu, val010, val011);
                    double val10 = this.lerp(tu, val100, val101);
                    double val11 = this.lerp(tu, val110, val111);
                    double val0 = this.lerp(tw, val00, val01);
                    double val1 = this.lerp(tw, val10, val11);
                    double val = this.lerp(tv, val0, val1);
                    out[index] = val * amplitude;
                    ++index;
                }
            }
        }
    }
}

