/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.BOPGeneratorBase;
import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class GeneratorBigMushroom
extends BOPGeneratorBase {
    protected BlockQuery.IBlockPosQuery placeOn;
    protected BlockQuery.IBlockPosQuery replace;
    protected BigMushroomType mushroomType;
    protected IBlockState mushroomState;

    public GeneratorBigMushroom(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, BigMushroomType mushroomType) {
        super(amountPerChunk);
        this.placeOn = placeOn;
        this.replace = replace;
        this.setMushroomType(mushroomType);
    }

    public void setMushroomType(BigMushroomType type) {
        this.mushroomType = type;
        this.mushroomState = type.getDefaultState();
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return GeneratorUtils.ScatterYMethod.AT_SURFACE.getBlockPos(world, random, x, z);
    }

    protected void replaceWithMushroom(World world, BlockPos pos, BlockHugeMushroom.EnumType side) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.mushroomState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)side), 2);
        }
    }

    public boolean isEnoughSpace(World world, BlockPos pos, int height) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height > 255) {
            return false;
        }
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + height; ++y) {
            int radius = y <= pos.func_177956_o() + 3 ? 0 : 3;
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int y;
        int height = rand.nextInt(3) + 5;
        if (!this.isEnoughSpace(world, pos, height)) {
            return false;
        }
        if (!this.placeOn.matches(world, pos.func_177977_b())) {
            return false;
        }
        for (y = height - this.mushroomType.getCapHeight(height); y < height; ++y) {
            int radius = (this.mushroomType.getCapDiameter(y, height) - 1) / 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockHugeMushroom.EnumType side = x == -radius ? (z == radius ? BlockHugeMushroom.EnumType.SOUTH_WEST : (z == -radius ? BlockHugeMushroom.EnumType.NORTH_WEST : BlockHugeMushroom.EnumType.WEST)) : (x == radius ? (z == radius ? BlockHugeMushroom.EnumType.SOUTH_EAST : (z == -radius ? BlockHugeMushroom.EnumType.NORTH_EAST : BlockHugeMushroom.EnumType.EAST)) : (z == radius ? BlockHugeMushroom.EnumType.SOUTH : (z == -radius ? BlockHugeMushroom.EnumType.NORTH : BlockHugeMushroom.EnumType.CENTER)));
                    if (this.mushroomType.cutCorners(y, height)) {
                        if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                        if (x == -(radius - 1) && z == -radius) {
                            side = BlockHugeMushroom.EnumType.NORTH_WEST;
                        }
                        if (x == -radius && z == -(radius - 1)) {
                            side = BlockHugeMushroom.EnumType.NORTH_WEST;
                        }
                        if (x == radius - 1 && z == -radius) {
                            side = BlockHugeMushroom.EnumType.NORTH_EAST;
                        }
                        if (x == radius && z == -(radius - 1)) {
                            side = BlockHugeMushroom.EnumType.NORTH_EAST;
                        }
                        if (x == -(radius - 1) && z == radius) {
                            side = BlockHugeMushroom.EnumType.SOUTH_WEST;
                        }
                        if (x == -radius && z == radius - 1) {
                            side = BlockHugeMushroom.EnumType.SOUTH_WEST;
                        }
                        if (x == radius - 1 && z == radius) {
                            side = BlockHugeMushroom.EnumType.SOUTH_EAST;
                        }
                        if (x == radius && z == radius - 1) {
                            side = BlockHugeMushroom.EnumType.SOUTH_EAST;
                        }
                    }
                    if (side == BlockHugeMushroom.EnumType.CENTER && y < height - 1) {
                        if (height > 2) continue;
                        side = BlockHugeMushroom.EnumType.ALL_INSIDE;
                    }
                    this.replaceWithMushroom(world, pos.func_177982_a(x, y, z), side);
                }
            }
        }
        for (y = 0; y < height - 1; ++y) {
            this.replaceWithMushroom(world, pos.func_177981_b(y), BlockHugeMushroom.EnumType.STEM);
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.setMushroomType(conf.getEnum("type", this.mushroomType, BigMushroomType.class));
    }

    public static class Builder
    extends BOPGeneratorBase.InnerBuilder<Builder, GeneratorBigMushroom>
    implements IGenerator.IGeneratorBuilder<GeneratorBigMushroom> {
        protected BigMushroomType mushroomType;
        protected BlockQuery.IBlockPosQuery placeOn;
        protected BlockQuery.IBlockPosQuery replace;

        public Builder mushroomType(BigMushroomType a) {
            this.mushroomType = a;
            return this;
        }

        public Builder placeOn(BlockQuery.IBlockPosQuery a) {
            this.placeOn = a;
            return (Builder)this.self();
        }

        public Builder placeOn(String a) throws BlockQuery.BlockQueryParseException {
            this.placeOn = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder placeOn(Block a) {
            this.placeOn = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder placeOn(IBlockState a) {
            this.placeOn = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder replace(BlockQuery.IBlockPosQuery a) {
            this.replace = a;
            return (Builder)this.self();
        }

        public Builder replace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder replace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder replace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.mushroomType = BigMushroomType.BROWN;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
        }

        @Override
        public GeneratorBigMushroom create() {
            return new GeneratorBigMushroom(this.amountPerChunk, this.placeOn, this.replace, this.mushroomType);
        }
    }

    public static enum BigMushroomType {
        BROWN,
        RED;


        public IBlockState getDefaultState() {
            switch (this) {
                case BROWN: {
                    return Blocks.field_150420_aW.func_176223_P();
                }
            }
            return Blocks.field_150419_aX.func_176223_P();
        }

        public int getCapHeight(int height) {
            switch (this) {
                case BROWN: {
                    return 1;
                }
            }
            return 3;
        }

        public int getCapDiameter(int y, int height) {
            switch (this) {
                case BROWN: {
                    return 7;
                }
            }
            return y < height - 1 ? 5 : 3;
        }

        public boolean cutCorners(int y, int height) {
            switch (this) {
                case BROWN: {
                    return true;
                }
            }
            return y < height - 1;
        }
    }
}

