/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class GeneratorBlobs
extends GeneratorReplacing {
    protected float minRadius;
    protected float maxRadius;
    protected float radiusFalloff;
    protected int numBalls;

    public GeneratorBlobs(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, float minRadius, float maxRadius, float radiusFalloff, int numBalls) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.radiusFalloff = radiusFalloff;
        this.numBalls = numBalls;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        while (pos.func_177956_o() > 3 && !this.placeOn.matches(world, pos.func_177977_b())) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 3) {
            return false;
        }
        float minRadius = this.minRadius;
        float maxRadius = this.maxRadius;
        float x = (float)pos.func_177958_n() + rand.nextFloat() + 0.5f;
        float y = (float)pos.func_177956_o() + rand.nextFloat() + 0.5f;
        float z = (float)pos.func_177952_p() + rand.nextFloat() + 0.5f;
        for (int i = 0; minRadius >= 0.0f && i < this.numBalls; ++i) {
            this.fillBall(world, rand, x, y, z, minRadius, maxRadius - minRadius);
            x += rand.nextFloat() * (minRadius + 2.0f) - (minRadius + 1.0f);
            y -= rand.nextFloat() * 2.0f;
            z += rand.nextFloat() * (minRadius + 2.0f) - (minRadius + 1.0f);
            minRadius *= this.radiusFalloff;
            maxRadius *= this.radiusFalloff;
        }
        return true;
    }

    protected void fillBall(World world, Random rand, float centerX, float centerY, float centerZ, float minRadius, float radiusVariation) {
        float radiusRand = rand.nextFloat() * 0.5f * radiusVariation;
        float radiusX = minRadius + radiusRand + rand.nextFloat() * radiusVariation * 0.5f;
        float radiusY = minRadius + radiusRand + rand.nextFloat() * radiusVariation * 0.5f;
        float radiusZ = minRadius + radiusRand + rand.nextFloat() * radiusVariation * 0.5f;
        int x0 = MathHelper.func_76141_d((float)(centerX - radiusX + 0.5f));
        int y0 = MathHelper.func_76141_d((float)(centerY - radiusY + 0.5f));
        int z0 = MathHelper.func_76141_d((float)(centerZ - radiusZ + 0.5f));
        int x1 = MathHelper.func_76141_d((float)(centerX + radiusX + 0.5f));
        int y1 = MathHelper.func_76141_d((float)(centerY + radiusY + 0.5f));
        int z1 = MathHelper.func_76141_d((float)(centerZ + radiusZ + 0.5f));
        for (int x = x0; x <= x1; ++x) {
            double px = ((double)x + 0.5 - (double)centerX) / (double)radiusX;
            if (!(px * px < 1.0)) continue;
            for (int y = y0; y <= y1; ++y) {
                double py = ((double)y + 0.5 - (double)centerY) / (double)radiusY;
                if (!(px * px + py * py < 1.0)) continue;
                for (int z = z0; z <= z1; ++z) {
                    BlockPos pos;
                    double pz = ((double)z + 0.5 - (double)centerZ) / (double)radiusZ;
                    if (!(px * px + py * py + pz * pz < 1.0) || !this.replace.matches(world, pos = new BlockPos(x, y, z))) continue;
                    world.func_175656_a(pos, this.with);
                }
            }
        }
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.with = conf.getBlockState("with", this.with);
        this.minRadius = conf.getFloat("innerRadius", Float.valueOf(this.minRadius)).floatValue();
        this.radiusFalloff = conf.getFloat("radiusFalloff", Float.valueOf(this.radiusFalloff)).floatValue();
        this.numBalls = conf.getInt("numBalls", this.numBalls);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorBlobs>
    implements IGenerator.IGeneratorBuilder<GeneratorBlobs> {
        protected float minRadius;
        protected float maxRadius;
        protected float radiusFalloff;
        protected int numBalls;

        public Builder minRadius(float a) {
            this.minRadius = a;
            return (Builder)this.self();
        }

        public Builder maxRadius(float a) {
            this.maxRadius = a;
            return (Builder)this.self();
        }

        public Builder radiusFalloff(float a) {
            this.radiusFalloff = a;
            return (Builder)this.self();
        }

        public Builder numBalls(int a) {
            this.numBalls = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQuery.buildOr().blocks(Blocks.field_150348_b).materials(Material.field_151578_c, Material.field_151577_b).create();
            this.replace = BlockQueries.breakable;
            this.with = Blocks.field_150347_e.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.BELOW_SURFACE;
            this.minRadius = 2.0f;
            this.maxRadius = 5.0f;
            this.radiusFalloff = 0.5f;
            this.numBalls = 3;
        }

        @Override
        public GeneratorBlobs create() {
            return new GeneratorBlobs(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minRadius, this.maxRadius, this.radiusFalloff, this.numBalls);
        }
    }
}

