/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class GeneratorCrystals
extends GeneratorReplacing {
    protected int generationAttempts;
    protected int maxRadius;
    protected int maxDepth;

    public GeneratorCrystals(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int generationAttempts, int maxRadius, int maxDepth) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.generationAttempts = generationAttempts;
        this.maxRadius = maxRadius;
        this.maxDepth = maxDepth;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            return false;
        }
        if (this.placeOn.matches(world, pos.func_177984_a())) {
            return false;
        }
        world.func_180501_a(pos, this.with, 2);
        for (int i = 0; i < this.generationAttempts; ++i) {
            BlockPos randPos = pos.func_177982_a(rand.nextInt(this.maxRadius + 1) - rand.nextInt(this.maxRadius + 1), -rand.nextInt(this.maxDepth + 1), rand.nextInt(this.maxRadius + 1) - rand.nextInt(this.maxRadius + 1));
            if (!this.replace.matches(world, randPos)) continue;
            boolean adjacentCrystals = false;
            for (EnumFacing face : EnumFacing.values()) {
                if (world.func_180495_p(randPos.func_177972_a(face)) != this.with) continue;
                adjacentCrystals = true;
                break;
            }
            if (!adjacentCrystals) continue;
            world.func_180501_a(randPos, this.with, 2);
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.placeOn = conf.getBlockPosQuery("placeUnder", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
        this.maxRadius = conf.getInt("maxRadius", this.maxRadius);
        this.maxDepth = conf.getInt("maxDepth", this.maxDepth);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorCrystals>
    implements IGenerator.IGeneratorBuilder<GeneratorCrystals> {
        protected int generationAttempts;
        protected int maxRadius;
        protected int maxDepth;

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        public Builder maxRadius(int a) {
            this.maxRadius = a;
            return (Builder)this.self();
        }

        public Builder maxDepth(int a) {
            this.maxDepth = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.hellish;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = Blocks.field_150426_aN.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.BELOW_GROUND;
            this.generationAttempts = 1500;
            this.maxRadius = 7;
            this.maxDepth = 11;
        }

        @Override
        public GeneratorCrystals create() {
            return new GeneratorCrystals(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.generationAttempts, this.maxRadius, this.maxDepth);
        }
    }
}

