/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.BOPGeneratorBase;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPGem;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.config.BOPConfig;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GeneratorOreBase
extends BOPGeneratorBase {
    protected int minHeight;
    protected int maxHeight;

    protected GeneratorOreBase(float amountPerChunk, int minHeight, int maxHeight) {
        super(amountPerChunk);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return new BlockPos(x, GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight), z);
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        int minHeight = conf.getInt("minHeight", this.minHeight);
        int maxHeight = conf.getInt("maxHeight", this.maxHeight);
        Pair<Integer, Integer> heights = GeneratorUtils.validateMinMaxHeight(minHeight, maxHeight);
        this.minHeight = (Integer)heights.getLeft();
        this.maxHeight = (Integer)heights.getRight();
    }

    protected static abstract class InnerBuilder<T extends BOPGeneratorBase.InnerBuilder<T, G>, G extends GeneratorOreBase>
    extends BOPGeneratorBase.InnerBuilder<T, G> {
        protected IBlockState with;
        protected int minHeight;
        protected int maxHeight;

        protected InnerBuilder() {
        }

        public T with(IBlockState a) {
            this.with = a;
            return this.self();
        }

        public T with(BOPGems a) {
            this.with = BOPBlocks.gem_ore.func_176223_P().func_177226_a((IProperty)BlockBOPGem.VARIANT, (Comparable)((Object)a));
            return this.self();
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return this.self();
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return this.self();
        }
    }
}

