/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorOreBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class GeneratorOreCluster
extends GeneratorOreBase {
    private WorldGenMinable generator;
    private IBlockState with;
    private BlockQuery.IBlockPosQuery replace;

    public GeneratorOreCluster(float amountPerChunk, int minHeight, int maxHeight, IBlockState with, int clusterSize, BlockQuery.IBlockPosQuery replace) {
        super(amountPerChunk, minHeight, maxHeight);
        this.generator = new WorldGenMinable(with, clusterSize);
        this.with = with;
        this.replace = replace;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            return this.generator.func_180709_b(world, random, pos);
        }
        return false;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.generator.field_175920_a = conf.getBlockState("with", this.generator.field_175920_a);
        this.generator.field_76541_b = conf.getInt("clusterSize", this.generator.field_76541_b);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
    }

    public static class Builder
    extends GeneratorOreBase.InnerBuilder<Builder, GeneratorOreCluster>
    implements IGenerator.IGeneratorBuilder<GeneratorOreCluster> {
        protected int clusterSize;
        protected BlockQuery.IBlockPosQuery replace;

        public Builder clusterSize(int a) {
            this.clusterSize = a;
            return (Builder)this.self();
        }

        public Builder replace(BlockQuery.IBlockPosQuery a) {
            this.replace = a;
            return (Builder)this.self();
        }

        public Builder replace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder replace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder replace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.with = Blocks.field_150412_bA.func_176223_P();
            this.minHeight = 4;
            this.maxHeight = 32;
            this.clusterSize = 4;
            this.replace = new BlockQuery.BlockQueryBlock(Blocks.field_150348_b);
        }

        @Override
        public GeneratorOreCluster create() {
            return new GeneratorOreCluster(this.amountPerChunk, this.minHeight, this.maxHeight, this.with, this.clusterSize, this.replace);
        }
    }
}

