/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorOreBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class GeneratorOreSingle
extends GeneratorOreBase {
    private IBlockState with;
    private BlockQuery.IBlockPosQuery replace;

    public GeneratorOreSingle(float amountPerChunk, int minHeight, int maxHeight, IBlockState with, BlockQuery.IBlockPosQuery replace) {
        super(amountPerChunk, minHeight, maxHeight);
        this.with = with;
        this.replace = replace;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            return world.func_180501_a(pos, this.with, 2);
        }
        return false;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.with = conf.getBlockState("with", this.with);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
    }

    public static class Builder
    extends GeneratorOreBase.InnerBuilder<Builder, GeneratorOreSingle>
    implements IGenerator.IGeneratorBuilder<GeneratorOreSingle> {
        protected BlockQuery.IBlockPosQuery replace;

        public Builder replace(BlockQuery.IBlockPosQuery a) {
            this.replace = a;
            return (Builder)this.self();
        }

        public Builder replace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder replace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder replace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 4;
            this.maxHeight = 32;
            this.with = Blocks.field_150412_bA.func_176223_P();
            this.replace = new BlockQuery.BlockQueryBlock(Blocks.field_150348_b);
        }

        @Override
        public GeneratorOreSingle create() {
            return new GeneratorOreSingle(this.amountPerChunk, this.minHeight, this.maxHeight, this.with, this.replace);
        }
    }
}

