/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature.tree;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.tuple.Pair;

public class GeneratorBasicTree
extends GeneratorTreeBase {
    protected boolean updateNeighbours;
    protected int leafLayers;
    protected int leavesOffset;
    protected int maxLeavesRadius;
    protected int leavesLayerHeight;
    protected BlockQuery.IBlockPosQuery placeVinesOn;
    protected float hangingChance;

    public GeneratorBasicTree(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState altLeaves, int minHeight, int maxHeight, boolean updateNeighbours, int leafLayers, int leavesOffset, int maxLeavesRadius, int leavesLayerHeight, BlockQuery.IBlockPosQuery placeVinesOn, float hangingChance) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, altLeaves, minHeight, maxHeight);
        this.updateNeighbours = updateNeighbours;
        this.leavesOffset = leavesOffset;
        this.leafLayers = leafLayers;
        this.maxLeavesRadius = maxLeavesRadius;
        this.leavesLayerHeight = leavesLayerHeight;
        this.placeVinesOn = placeVinesOn;
        this.hangingChance = hangingChance;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        boolean hasSpace = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.func_177956_o()) {
                    radius = 0;
                }
                if (y >= pos.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius && hasSpace; ++x) {
                    for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.func_177977_b();
            Block soil = world.func_180495_p(soilPos).func_177230_c();
            boolean isSoil = soil.canSustainPlant((IBlockAccess)world, soilPos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (this.placeOn.matches(world, soilPos) && isSoil && pos.func_177956_o() < 256 - height - 1) {
                int x;
                int leavesRadius;
                int currentLayer;
                int y;
                soil.onPlantGrow(world, soilPos, pos);
                int leavesLayers = this.leafLayers - 1;
                for (y = pos.func_177956_o() + height - leavesLayers; y <= pos.func_177956_o() + height; ++y) {
                    currentLayer = y - (pos.func_177956_o() + height);
                    leavesRadius = this.maxLeavesRadius - currentLayer / this.leavesLayerHeight;
                    for (x = pos.func_177958_n() - leavesRadius; x <= pos.func_177958_n() + leavesRadius; ++x) {
                        int xDiff = x - pos.func_177958_n();
                        for (int z = pos.func_177952_p() - leavesRadius; z <= pos.func_177952_p() + leavesRadius; ++z) {
                            BlockPos leavesPos;
                            int zDiff = z - pos.func_177952_p();
                            if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.nextInt(2) == 0 || currentLayer == 0) || !this.replace.matches(world, leavesPos = new BlockPos(x, y, z))) continue;
                            if (this.altLeaves != null) {
                                if (random.nextInt(4) == 0) {
                                    this.func_175903_a(world, leavesPos, this.altLeaves);
                                    continue;
                                }
                                this.func_175903_a(world, leavesPos, this.leaves);
                                continue;
                            }
                            this.func_175903_a(world, leavesPos, this.leaves);
                        }
                    }
                }
                this.generateTrunk(world, pos, height);
                if (this.vine != null) {
                    for (y = pos.func_177956_o() - leavesLayers + height; y <= pos.func_177956_o() + height; ++y) {
                        currentLayer = y - (pos.func_177956_o() + height);
                        leavesRadius = this.maxLeavesRadius + this.leavesOffset - currentLayer / this.leavesLayerHeight;
                        for (x = pos.func_177958_n() - leavesRadius; x <= pos.func_177958_n() + leavesRadius; ++x) {
                            for (int z = pos.func_177952_p() - leavesRadius; z <= pos.func_177952_p() + leavesRadius; ++z) {
                                BlockPos blockpos3 = new BlockPos(x, y, z);
                                if (!world.func_180495_p(blockpos3).func_177230_c().isLeaves((IBlockAccess)world, blockpos3)) continue;
                                BlockPos westPos = blockpos3.func_177976_e();
                                BlockPos eastPos = blockpos3.func_177974_f();
                                BlockPos northPos = blockpos3.func_177978_c();
                                BlockPos southPos = blockpos3.func_177968_d();
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, westPos)) {
                                    this.extendVines(world, westPos, EnumFacing.EAST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, eastPos)) {
                                    this.extendVines(world, eastPos, EnumFacing.WEST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, northPos)) {
                                    this.extendVines(world, northPos, EnumFacing.SOUTH);
                                }
                                if (random.nextInt(4) != 0 || !this.placeVinesOn.matches(world, southPos)) continue;
                                this.extendVines(world, southPos, EnumFacing.NORTH);
                            }
                        }
                    }
                }
                if (this.hanging != null) {
                    this.generateHanging(world, pos, height);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(World world, BlockPos start, int height) {
        for (int layer = 0; layer < height; ++layer) {
            BlockPos blockpos2 = start.func_177981_b(layer);
            if (!this.replace.matches(world, blockpos2)) continue;
            this.func_175903_a(world, start.func_177981_b(layer), this.log);
        }
    }

    protected void generateHanging(World world, BlockPos start, int height) {
        int y = start.func_177956_o() + (height - this.leafLayers);
        for (int x = start.func_177958_n() - (this.maxLeavesRadius + 1); x <= start.func_177958_n() + (this.maxLeavesRadius + 1); ++x) {
            for (int z = start.func_177952_p() - (this.maxLeavesRadius + 1); z <= start.func_177952_p() + (this.maxLeavesRadius + 1); ++z) {
                BlockPos hangingPos = new BlockPos(x, y, z);
                if (world.func_175623_d(hangingPos.func_177984_a()) || !world.func_175623_d(hangingPos) || !(world.field_73012_v.nextFloat() <= this.hangingChance)) continue;
                this.setHanging(world, hangingPos);
            }
        }
    }

    private IBlockState getVineStateForSide(EnumFacing side) {
        return this.vine.func_177230_c() instanceof BlockVine ? this.vine.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)side), (Comparable)Boolean.valueOf(true)) : this.vine;
    }

    private void extendVines(World world, BlockPos pos, EnumFacing side) {
        IBlockState vineState = this.getVineStateForSide(side);
        this.func_175903_a(world, pos, vineState);
        pos = pos.func_177977_b();
        for (int length = 4; this.placeVinesOn.matches(world, pos) && length > 0; --length) {
            this.func_175903_a(world, pos, vineState);
            pos = pos.func_177977_b();
        }
    }

    public void func_175903_a(World world, BlockPos pos, IBlockState state) {
        if (this.updateNeighbours) {
            world.func_180501_a(pos, state, 3);
        } else {
            world.func_180501_a(pos, state, 2);
        }
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.updateNeighbours = conf.getBool("updateNeighbours", this.updateNeighbours);
        int minHeight = conf.getInt("minHeight", this.minHeight);
        int maxHeight = conf.getInt("maxHeight", this.maxHeight);
        Pair<Integer, Integer> heights = GeneratorUtils.validateMinMaxHeight(minHeight, maxHeight);
        this.minHeight = (Integer)heights.getLeft();
        this.maxHeight = (Integer)heights.getRight();
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.vine = conf.getBlockState("vineState", this.vine);
        this.hanging = conf.getBlockState("hangingState", this.hanging);
        this.altLeaves = conf.getBlockState("altLeavesState", this.altLeaves);
        this.hangingChance = conf.getFloat("hangingChance", Float.valueOf(this.hangingChance)).floatValue();
    }

    protected static abstract class InnerBuilder<T extends InnerBuilder<T, G>, G extends GeneratorBasicTree>
    extends GeneratorTreeBase.InnerBuilder<T, G> {
        protected int leafLayers;
        protected int leavesOffset;
        protected int maxLeavesRadius;
        protected int leavesLayerHeight;
        protected BlockQuery.IBlockPosQuery placeVinesOn;
        protected float hangingChance;

        protected InnerBuilder() {
        }

        public T leafLayers(int a) {
            this.leafLayers = a;
            return (T)((InnerBuilder)this.self());
        }

        public T leavesOffset(int a) {
            this.leavesOffset = a;
            return (T)((InnerBuilder)this.self());
        }

        public T leavesLayerHeight(int a) {
            this.leavesLayerHeight = a;
            return (T)((InnerBuilder)this.self());
        }

        public T maxLeavesRadius(int a) {
            this.maxLeavesRadius = a;
            return (T)((InnerBuilder)this.self());
        }

        public T placeVinesOn(BlockQuery.IBlockPosQuery a) {
            this.placeVinesOn = a;
            return (T)((InnerBuilder)this.self());
        }

        public T placeVinesOn(String a) throws BlockQuery.BlockQueryParseException {
            this.placeVinesOn = BlockQuery.parseQueryString(a);
            return (T)((InnerBuilder)this.self());
        }

        public T placeVinesOn(Block a) {
            this.placeVinesOn = new BlockQuery.BlockQueryBlock(a);
            return (T)((InnerBuilder)this.self());
        }

        public T placeVinesOn(IBlockState a) {
            this.placeVinesOn = new BlockQuery.BlockQueryState(a);
            return (T)((InnerBuilder)this.self());
        }

        public T placeVinesOn(Material ... a) {
            this.placeVinesOn = new BlockQuery.BlockQueryMaterial(a);
            return (T)((InnerBuilder)this.self());
        }

        public T hangingChance(float a) {
            this.hangingChance = a;
            return (T)((InnerBuilder)this.self());
        }
    }

    public static class Builder
    extends InnerBuilder<Builder, GeneratorBasicTree>
    implements IGenerator.IGeneratorBuilder<GeneratorBasicTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a, Material.field_151584_j);
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.altLeaves = null;
            this.minHeight = 4;
            this.maxHeight = 7;
            this.leafLayers = 4;
            this.leavesOffset = 1;
            this.maxLeavesRadius = 1;
            this.leavesLayerHeight = 2;
            this.placeVinesOn = BlockQueries.air;
            this.hangingChance = 0.0f;
        }

        @Override
        public GeneratorBasicTree create() {
            return new GeneratorBasicTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.altLeaves, this.minHeight, this.maxHeight, false, this.leafLayers, this.leavesOffset, this.maxLeavesRadius, this.leavesLayerHeight, this.placeVinesOn, this.hangingChance);
        }
    }
}

