/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature.tree;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorSpike;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorRedwoodTree
extends GeneratorTreeBase {
    protected GeneratorRedwoodTree(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState altLeaves, int minHeight, int maxHeight) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, altLeaves, minHeight, maxHeight);
    }

    public boolean canPlaceHere(World world, BlockPos pos, int height, int radius) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height > 255) {
            return false;
        }
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + height; ++y) {
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    if (y == pos.func_177956_o() && !this.placeOn.matches(world, new BlockPos(x, y - 1, z))) {
                        return false;
                    }
                    if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateTrunk(World world, Random random, BlockPos pos, int trunkHeight) {
        for (int i = 0; i < trunkHeight; ++i) {
            this.setLog(world, pos);
            this.setLog(world, pos.func_177978_c());
            this.setLog(world, pos.func_177974_f());
            this.setLog(world, pos.func_177968_d());
            this.setLog(world, pos.func_177976_e());
            pos = pos.func_177984_a();
        }
    }

    public void generateBranches(World world, Random rand, BlockPos pos, int length) {
        EnumFacing direction = EnumFacing.NORTH;
        while (direction.ordinal() < 5) {
            EnumFacing.Axis axis = direction.func_176740_k();
            EnumFacing sideways = direction.func_176746_e();
            for (int i = 1; i <= length; ++i) {
                BlockPos pos1 = pos.func_177967_a(direction, i);
                this.setLog(world, pos1, axis);
            }
            direction = EnumFacing.values()[direction.ordinal() + 1];
        }
    }

    public void generateLeafLayer(World world, Random rand, BlockPos pos, int leafLayerNum) {
        int index = leafLayerNum % 7;
        int leavesRadius = index < 2 ? 2 : 3;
        double increment = 0.05;
        for (int radius = leavesRadius; radius >= 0; --radius) {
            for (double angle = 0.0; angle <= Math.PI * 2; angle += increment) {
                BlockPos leavesPos = pos.func_177963_a((double)Math.round((double)radius * Math.cos(angle)), 0.0, (double)Math.round((double)radius * Math.sin(angle)));
                if (radius >= leavesRadius && index >= 2 && rand.nextInt(4) != 0) continue;
                this.setLeaves(world, leavesPos);
            }
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().isLeaves((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 20) {
            return false;
        }
        pos = pos.func_177984_a();
        GeneratorSpike spikeGenerator = ((GeneratorSpike.Builder)((GeneratorSpike.Builder)new GeneratorSpike.Builder().with(this.log)).replace(BlockQueries.anything)).minRadius(4).maxRadius(4).create();
        if (!this.canPlaceHere(world, pos, height, 1) || !spikeGenerator.canPlaceHere(world, pos, height, 4)) {
            return false;
        }
        spikeGenerator.func_180709_b(world, random, pos);
        BlockPos trunkTop = pos;
        while (!world.func_175623_d(trunkTop.func_177984_a())) {
            if (trunkTop.func_177956_o() >= 255) {
                return false;
            }
            trunkTop = trunkTop.func_177984_a();
        }
        int baseHeight = trunkTop.func_177956_o() - pos.func_177956_o();
        int trunkHeight = height - baseHeight;
        this.generateTrunk(world, random, pos, height - 1);
        int i = 0;
        while ((float)i < (float)trunkHeight * 0.75f) {
            this.generateLeafLayer(world, random, pos.func_177981_b(height - i), i);
            ++i;
        }
        GeneratorBush bushGenerator = ((GeneratorBush.Builder)((GeneratorBush.Builder)((GeneratorBush.Builder)((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().amountPerChunk(2.0f)).log(this.log)).leaves(this.leaves)).placeOn(this.log)).maxHeight(2)).create();
        for (int i2 = 0; i2 < 10; ++i2) {
            bushGenerator.func_180709_b(world, random, pos.func_177982_a(random.nextInt(10) - 5, baseHeight, random.nextInt(10) - 5));
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorRedwoodTree>
    implements IGenerator.IGeneratorBuilder<GeneratorRedwoodTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 40;
            this.maxHeight = 60;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.replaceable;
            this.log = BlockBOPLog.paging.getVariantState(BOPWoods.REDWOOD);
            this.leaves = BlockBOPLeaves.paging.getVariantState(BOPTrees.REDWOOD);
            this.vine = null;
            this.hanging = null;
            this.altLeaves = null;
        }

        @Override
        public GeneratorRedwoodTree create() {
            return new GeneratorRedwoodTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.altLeaves, this.minHeight, this.maxHeight);
        }
    }
}

