/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.world.layer.BOPGenLayer;
import com.google.common.base.Optional;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeEdgeBOP
extends BOPGenLayer {
    public GenLayerBiomeEdgeBOP(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] parentVals = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int y = 0; y < areaHeight; ++y) {
            for (int x = 0; x < areaWidth; ++x) {
                int southBiomeId;
                int westBiomeId;
                int eastBiomeId;
                int northBiomeId;
                this.func_75903_a(x + areaX, y + areaY);
                int biomeId = parentVals[x + 1 + (y + 1) * (areaWidth + 2)];
                if (this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BOPBiomes.mountain, BOPBiomes.mountain_foothills) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BOPBiomes.wasteland, (Optional<BiomeGenBase>)Optional.of((Object)BiomeGenBase.field_76769_d)) || this.replaceBiomeEdgeIfNecessary(parentVals, out, x, y, areaWidth, biomeId, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M)) continue;
                if (biomeId == BiomeGenBase.field_76769_d.field_76756_M) {
                    northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
                    eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
                    westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
                    southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
                    if (northBiomeId != BiomeGenBase.field_76774_n.field_76756_M && eastBiomeId != BiomeGenBase.field_76774_n.field_76756_M && westBiomeId != BiomeGenBase.field_76774_n.field_76756_M && southBiomeId != BiomeGenBase.field_76774_n.field_76756_M) {
                        out[x + y * areaWidth] = biomeId;
                        continue;
                    }
                    out[x + y * areaWidth] = BiomeGenBase.field_150580_W.field_76756_M;
                    continue;
                }
                if (biomeId == BiomeGenBase.field_76780_h.field_76756_M) {
                    northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
                    eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
                    westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
                    southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
                    if (northBiomeId != BiomeGenBase.field_76769_d.field_76756_M && eastBiomeId != BiomeGenBase.field_76769_d.field_76756_M && westBiomeId != BiomeGenBase.field_76769_d.field_76756_M && southBiomeId != BiomeGenBase.field_76769_d.field_76756_M && northBiomeId != BiomeGenBase.field_150584_S.field_76756_M && eastBiomeId != BiomeGenBase.field_150584_S.field_76756_M && westBiomeId != BiomeGenBase.field_150584_S.field_76756_M && southBiomeId != BiomeGenBase.field_150584_S.field_76756_M && northBiomeId != BiomeGenBase.field_76774_n.field_76756_M && eastBiomeId != BiomeGenBase.field_76774_n.field_76756_M && westBiomeId != BiomeGenBase.field_76774_n.field_76756_M && southBiomeId != BiomeGenBase.field_76774_n.field_76756_M) {
                        if (northBiomeId != BiomeGenBase.field_76782_w.field_76756_M && southBiomeId != BiomeGenBase.field_76782_w.field_76756_M && eastBiomeId != BiomeGenBase.field_76782_w.field_76756_M && westBiomeId != BiomeGenBase.field_76782_w.field_76756_M) {
                            out[x + y * areaWidth] = biomeId;
                            continue;
                        }
                        out[x + y * areaWidth] = BiomeGenBase.field_150574_L.field_76756_M;
                        continue;
                    }
                    out[x + y * areaWidth] = BiomeGenBase.field_76772_c.field_76756_M;
                    continue;
                }
                out[x + y * areaWidth] = biomeId;
            }
        }
        return out;
    }

    private boolean replaceBiomeEdgeIfNecessary(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, int fromBiomeId, int toBiomeId) {
        if (!GenLayerBiomeEdgeBOP.func_151616_a((int)biomeId, (int)fromBiomeId)) {
            return false;
        }
        int northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
        int eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
        int westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
        int southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
        out[x + y * areaWidth] = this.canBiomesBeNeighbors(northBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(eastBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(westBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(southBiomeId, fromBiomeId) ? biomeId : toBiomeId;
        return true;
    }

    private boolean replaceBiomeEdge(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, Optional<BiomeGenBase> fromBiome, Optional<BiomeGenBase> toBiome) {
        return fromBiome.isPresent() && toBiome.isPresent() && this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, ((BiomeGenBase)fromBiome.get()).field_76756_M, ((BiomeGenBase)toBiome.get()).field_76756_M);
    }

    private boolean replaceBiomeEdge(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, int fromBiomeId, int toBiomeId) {
        if (biomeId != fromBiomeId) {
            return false;
        }
        int northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
        int eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
        int westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
        int southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
        out[x + y * areaWidth] = GenLayerBiomeEdgeBOP.func_151616_a((int)northBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)eastBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)westBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)southBiomeId, (int)fromBiomeId) ? biomeId : toBiomeId;
        return true;
    }

    private boolean canBiomesBeNeighbors(int biomeA, int biomeB) {
        if (GenLayerBiomeEdgeBOP.func_151616_a((int)biomeA, (int)biomeB)) {
            return true;
        }
        BiomeGenBase biomegenbaseA = BiomeGenBase.func_150568_d((int)biomeA);
        BiomeGenBase biomegenbaseB = BiomeGenBase.func_150568_d((int)biomeB);
        if (biomegenbaseA != null && biomegenbaseB != null) {
            BiomeGenBase.TempCategory tempcategory1;
            BiomeGenBase.TempCategory tempcategory = biomegenbaseA.func_150561_m();
            return tempcategory == (tempcategory1 = biomegenbaseB.func_150561_m()) || tempcategory == BiomeGenBase.TempCategory.MEDIUM || tempcategory1 == BiomeGenBase.TempCategory.MEDIUM;
        }
        return false;
    }
}

