/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.common.world.layer.BOPGenLayer;
import com.google.common.base.Predicate;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerShoreBOP
extends BOPGenLayer {
    private static final Predicate<Integer> OCEAN_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return input == BiomeGenBase.field_76771_b.field_76756_M;
        }
    };
    private static final Predicate<Integer> OCEANIC_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return GenLayerShoreBOP.func_151618_b((int)input);
        }
    };
    private static final Predicate<Integer> JUNGLE_BORDER_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return BiomeGenBase.func_150568_d((int)input) != null && BiomeGenBase.func_150568_d((int)input).func_150562_l() == BiomeGenJungle.class ? true : input == BiomeGenBase.field_150574_L.field_76756_M || input == BiomeGenBase.field_76782_w.field_76756_M || input == BiomeGenBase.field_76792_x.field_76756_M || input == BiomeGenBase.field_76767_f.field_76756_M || input == BiomeGenBase.field_76768_g.field_76756_M || GenLayerShoreBOP.func_151618_b((int)input);
        }
    };
    private static final Predicate<Integer> MESA_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return !(BiomeGenBase.func_150568_d((int)input) instanceof BiomeGenMesa);
        }
    };

    public GenLayerShoreBOP(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] biomeIds = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int z = 0; z < areaHeight; ++z) {
            for (int x = 0; x < areaWidth; ++x) {
                int biomeSouth;
                int biomeWest;
                int biomeEast;
                int biomeNorth;
                this.func_75903_a(x + areaX, z + areaY);
                int biomeId = biomeIds[x + 1 + (z + 1) * (areaWidth + 2)];
                BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeId);
                if (biomeId == BiomeGenBase.field_76789_p.field_76756_M) {
                    this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_76788_q.field_76756_M, OCEAN_PREDICATE);
                    continue;
                }
                if (biome != null && biome.func_150562_l() == BiomeGenJungle.class) {
                    biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
                    biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
                    biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
                    biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
                    if (JUNGLE_BORDER_PREDICATE.apply((Object)biomeNorth) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeEast) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeWest) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeSouth)) {
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_76787_r.field_76756_M, OCEANIC_PREDICATE);
                        continue;
                    }
                    out[x + z * areaWidth] = BiomeGenBase.field_150574_L.field_76756_M;
                    continue;
                }
                if (biomeId != BiomeGenBase.field_76770_e.field_76756_M && biomeId != BiomeGenBase.field_150580_W.field_76756_M && biomeId != BiomeGenBase.field_76783_v.field_76756_M) {
                    if (biome != null && biome.func_150559_j()) {
                        if (GenLayerShoreBOP.func_151618_b((int)biomeId)) {
                            out[x + z * areaWidth] = biomeId;
                            continue;
                        }
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_150577_O.field_76756_M, OCEANIC_PREDICATE);
                        continue;
                    }
                    if (biomeId != BiomeGenBase.field_150589_Z.field_76756_M && biomeId != BiomeGenBase.field_150607_aa.field_76756_M) {
                        if (biomeId != BiomeGenBase.field_76771_b.field_76756_M && biomeId != BiomeGenBase.field_150575_M.field_76756_M && biomeId != BiomeGenBase.field_76781_i.field_76756_M && biomeId != BiomeGenBase.field_76780_h.field_76756_M) {
                            if (biome != null && BOPBiomes.REG_INSTANCE.getExtendedBiome(biome) != null) {
                                IExtendedBiome extBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
                                this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, extBiome.getBeachId() == -1 ? biomeId : extBiome.getBeachId(), OCEANIC_PREDICATE);
                                continue;
                            }
                            this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_76787_r.field_76756_M, OCEANIC_PREDICATE);
                            continue;
                        }
                        out[x + z * areaWidth] = biomeId;
                        continue;
                    }
                    biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
                    biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
                    biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
                    biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
                    if (!(GenLayerShoreBOP.func_151618_b((int)biomeNorth) || GenLayerShoreBOP.func_151618_b((int)biomeEast) || GenLayerShoreBOP.func_151618_b((int)biomeWest) || GenLayerShoreBOP.func_151618_b((int)biomeSouth))) {
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_76769_d.field_76756_M, MESA_PREDICATE);
                        continue;
                    }
                    out[x + z * areaWidth] = biomeId;
                    continue;
                }
                this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, BiomeGenBase.field_150576_N.field_76756_M, OCEANIC_PREDICATE);
            }
        }
        return out;
    }

    private void setBiomeWithAdjacent(int[] biomeIds, int[] out, int x, int z, int areaWidth, int biomeId, int beachId, Predicate<Integer> adjacentPredicate) {
        int biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
        int biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
        int biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
        int biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
        out[x + z * areaWidth] = adjacentPredicate.apply((Object)biomeNorth) || adjacentPredicate.apply((Object)biomeEast) || adjacentPredicate.apply((Object)biomeWest) || adjacentPredicate.apply((Object)biomeSouth) ? beachId : biomeId;
    }
}

