/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xaero.map.WorldMap;
import xaero.map.world.BlockAccessWrapper;

public class BlockStateColorTypeCache {
    private BlockAccessWrapper blockAccessWrapper;
    private Hashtable<IBlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<IBlockState, Integer> overlayColorTypes = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private IBlockState grassState = Blocks.field_150349_c.func_176223_P();
    private IBlockState oakLeavesState = Blocks.field_150362_t.func_176223_P();
    private IBlockState waterState = Blocks.field_150355_j.func_176223_P();

    public BlockStateColorTypeCache() {
        this.blockAccessWrapper = new BlockAccessWrapper();
    }

    public void getBlockBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = 0xFFFFFF;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            Material material;
            Block b = state.func_177230_c();
            boolean renderColorFailed = false;
            try {
                customColour = b.func_180644_h(state);
            }
            catch (Throwable t) {
                renderColorFailed = true;
            }
            if ((renderColorFailed || customColour != 0xFFFFFF && customColour != this.grassColor && customColour != this.foliageColor) && (material = b.func_149688_o()) != null && (material.func_151565_r() == MapColor.field_151661_c || material.func_151565_r() == MapColor.field_151669_i)) {
                customColour = b.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
                gotFullCC = true;
                if (material.func_151565_r() == MapColor.field_151661_c && customColour == Blocks.field_150349_c.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, this.grassState, pos), pos)) {
                    customColour = this.grassColor;
                } else if (material.func_151565_r() == MapColor.field_151669_i && customColour == Blocks.field_150362_t.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, this.oakLeavesState, pos), pos)) {
                    customColour = this.foliageColor;
                }
            }
            if (customColour == this.grassColor) {
                colorType = 1;
            } else if (customColour == this.foliageColor) {
                colorType = 2;
            } else {
                if (!gotFullCC) {
                    customColour = b.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == -1) {
            if (isRenderThread) {
                biomeId = world.func_180494_b((BlockPos)pos).field_76756_M;
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            dest[1] = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            dest[1] = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = state.func_177230_c().func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
            }
            dest[2] = customColour;
        }
    }

    public void getOverlayBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.overlayColorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            Block b = state.func_177230_c();
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
                colorType = 1;
            } else {
                customColour = b.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
                gotFullCC = true;
                colorType = 0;
                if (customColour != -1) {
                    Material material = b.func_149688_o();
                    if (material != null && material.func_151565_r() == MapColor.field_151662_n && customColour == Blocks.field_150355_j.func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, this.waterState, pos), pos)) {
                        colorType = 1;
                    } else if (customColour != 0xFFFFFF) {
                        colorType = 2;
                    }
                }
            }
            this.overlayColorTypes.put(state, colorType);
        } else if (colorType == 2 && !isRenderThread) {
            colorType = -1;
        }
        dest[0] = colorType;
        if (colorType == 1) {
            if (biomeId == -1) {
                if (!gotFullCC) {
                    customColour = state.func_177230_c().func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
                }
                if (customColour == 0xFFFFFF) {
                    dest[0] = 0;
                } else {
                    dest[1] = biomeId = world.func_180494_b((BlockPos)pos).field_76756_M;
                }
            }
            dest[1] = biomeId;
        } else if (colorType == 2) {
            if (!gotFullCC) {
                customColour = state.func_177230_c().func_176202_d(this.blockAccessWrapper.withValues((IBlockAccess)world, state, pos), pos);
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = Blocks.field_150349_c.func_180644_h(this.grassState);
        this.foliageColor = Blocks.field_150362_t.func_180644_h(this.oakLeavesState);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }
}

