/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core.transformer;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import xaero.map.core.transformer.ClassNodeTransformer;

public class PlayerListTransformer
extends ClassNodeTransformer {
    @Override
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        this.className = "net.minecraft.server.management.ServerConfigurationManager";
        return super.transform(name, transformedName, basicClass);
    }

    @Override
    protected void transformNode(ClassNode classNode, boolean isObfuscated) {
        String methodNameWorldInfo = isObfuscated ? "b" : "updateTimeAndWeatherForPlayer";
        String methodDescWorldInfo = isObfuscated ? "(Llf;Lle;)V" : "(Lnet/minecraft/entity/player/EntityPlayerMP;Lnet/minecraft/world/WorldServer;)V";
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(methodNameWorldInfo) || !methodNode.desc.equals(methodDescWorldInfo)) continue;
            this.insertWorldInfoCall(methodNode);
            break;
        }
    }

    private void insertWorldInfoCall(MethodNode methodNode) {
        InsnList patchList = new InsnList();
        patchList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        patchList.add((AbstractInsnNode)new MethodInsnNode(184, "xaero/map/server/core/XaeroWorldMapServerCore", "onServerWorldInfo", "(Lnet/minecraft/entity/player/EntityPlayer;)V", false));
        AbstractInsnNode firstInsn = methodNode.instructions.get(0);
        if (firstInsn instanceof LabelNode) {
            methodNode.instructions.insert(firstInsn, patchList);
        } else {
            methodNode.instructions.insertBefore(firstInsn, patchList);
        }
    }
}

