/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.patreon.GuiUpdateAll3;
import xaero.patreon.Patreon6;

public class Events {
    private boolean listenToTextureStitch;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        WorldMapSession worldmapSession;
        if (event.gui == null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.onGuiClosed();
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) throws IOException {
        boolean shouldListen = this.listenToTextureStitch;
        this.listenToTextureStitch = true;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.getMapWriter().getColorTypeCache().updateGrassColor();
            if (shouldListen) {
                mapProcessor.getMapWriter().requestCachedColoursClear();
            }
        }
        if (shouldListen) {
            if (SupportMods.minimap()) {
                WorldMap.waypointSymbolCreator.resetChars();
            }
            WorldMap.settings.updateRegionCacheHashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.phase == TickEvent.Phase.END) {
                ScaledResolution scaledresolution = new ScaledResolution(mc);
                mapProcessor.onRenderProcess(mc, scaledresolution);
                mc.field_71454_w = false;
                mapProcessor.resetRenderStartTime();
                Queue<FutureTask<?>> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(mapProcessor.getRenderStartTimeUpdater());
                Queue<FutureTask<?>> queue = minecraftScheduledTasks;
                synchronized (queue) {
                    FutureTask[] currentTasks = minecraftScheduledTasks.toArray(new FutureTask[0]);
                    minecraftScheduledTasks.clear();
                    minecraftScheduledTasks.add((FutureTask<?>)listenablefuturetask);
                    for (FutureTask t : currentTasks) {
                        minecraftScheduledTasks.add(t);
                    }
                }
            } else if (event.phase == TickEvent.Phase.START) {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.field_71462_r, true)) {
                    Misc.setShaderProgram(0);
                    ScaledResolution scaledresolution = new ScaledResolution(mc);
                    int i1 = scaledresolution.func_78326_a();
                    int j1 = scaledresolution.func_78328_b();
                    int k1 = Mouse.getX() * i1 / mc.field_71443_c;
                    int l1 = j1 - Mouse.getY() * j1 / mc.field_71440_d - 1;
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179083_b((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179096_D();
                    mc.field_71460_t.func_78478_c();
                    GlStateManager.func_179086_m((int)256);
                    ForgeHooksClient.drawScreen((GuiScreen)mc.field_71462_r, (int)k1, (int)l1, (float)0.0f);
                    mc.field_71454_w = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon6.needsNotification() && event.gui instanceof GuiMainMenu && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdateAll3());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        WorldMapSession worldmapSession;
        if (event.entityPlayer.field_70170_p instanceof WorldClient && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(event.newSpawn, (WorldClient)event.entityPlayer.field_70170_p);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.world == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.world instanceof WorldServer) {
            WorldServer sw = (WorldServer)event.world;
            WorldMapSession worldmapSession2 = WorldMapSession.getCurrentSession();
            if (worldmapSession2 != null) {
                MapProcessor mapProcessor = worldmapSession2.getMapProcessor();
                mapProcessor.getWorldDataHandler().onServerWorldUnload(sw);
            }
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            String crosshairMessage;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
            String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
            if (crosshairMessage != null) {
                int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
                GlStateManager.func_179084_k();
                Minecraft.func_71410_x().field_71466_p.func_175063_a(crosshairMessage, (float)(event.resolution.func_78326_a() / 2 - messageWidth / 2), (float)(event.resolution.func_78328_b() / 2 + 60), -1);
                GlStateManager.func_179147_l();
            }
        }
    }
}

