/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTSeparateShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import xaero.map.gui.IScreenBase;
import xaero.map.mods.SupportMods;

public class Misc {
    private static final long[] ZERO_LONG_586 = new long[586];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    private static int shadersType;
    private static boolean EXTgeometryShader;

    public static int myFloor(double d) {
        int asInt = (int)d;
        if ((double)asInt != d && d < 0.0) {
            --asInt;
        }
        return asInt;
    }

    public static double round(double a, int komaarvu) {
        double x = Math.pow(10.0, komaarvu);
        return (double)Math.round(a * x) / x;
    }

    public static IBlockState getStateById(int id) {
        try {
            return Block.func_176220_d((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static IBlockState getDefaultBlockStateForStateId(int id) {
        try {
            Block block = Block.func_176220_d((int)id).func_177230_c();
            return block.func_176223_P();
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(Minecraft mc) {
        return Mouse.getX();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71440_d - Mouse.getY() - 1;
    }

    public static void clearHeightsData586(long[] data) {
        System.arraycopy(ZERO_LONG_586, 0, data, 0, 586);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static void minecraftOrtho(ScaledResolution scaledresolution) {
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static void setShaderProgram(int program) {
        if (shadersType == -500) {
            shadersType = GLContext.getCapabilities().OpenGL20 ? 0 : (GLContext.getCapabilities().GL_ARB_shader_objects ? 1 : (GLContext.getCapabilities().GL_EXT_separate_shader_objects ? 2 : -1));
            EXTgeometryShader = GLContext.getCapabilities().GL_EXT_geometry_shader4 || GLContext.getCapabilities().GL_ARB_geometry_shader4;
        }
        switch (shadersType) {
            case 0: {
                GL20.glUseProgram((int)program);
                break;
            }
            case 1: {
                ARBShaderObjects.glUseProgramObjectARB((int)program);
                break;
            }
            case 2: {
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35633, (int)program);
                if (EXTgeometryShader) {
                    EXTSeparateShaderObjects.glUseShaderProgramEXT((int)36313, (int)program);
                }
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35632, (int)program);
                EXTSeparateShaderObjects.glActiveProgramEXT((int)program);
                break;
            }
        }
    }

    public static String getKeyName(KeyBinding kb) {
        if (kb.func_151463_i() == 0) {
            return "(unset)";
        }
        return GameSettings.func_74298_c((int)kb.func_151463_i()).toUpperCase();
    }

    public static boolean inputMatchesKeyBinding(boolean mouse, int code, KeyBinding kb) {
        if (code == 0) {
            return false;
        }
        if (mouse) {
            code -= 100;
        }
        return kb.func_151463_i() == code;
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static boolean screenShouldSkipWorldRender(GuiScreen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && SupportMods.minimap() && SupportMods.xaeroMinimap.screenShouldSkipWorldRender(screen);
    }

    static {
        shadersType = -500;
    }
}

