/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.RightClickOption;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class Waypoint
extends WaypointMenuElement
implements Comparable<Waypoint>,
IRightClickableElement {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;
    private boolean temporary;
    private boolean global;
    private String setName;
    private ArrayList<RightClickOption> rightClickOptions;

    public Waypoint(Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable, String setName) {
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
        this.setName = setName;
        this.rightClickOptions = new ArrayList();
        this.rightClickOptions.add(new RightClickOption(name, this.rightClickOptions.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        });
        if (!SupportMods.xaeroMinimap.hidingWaypointCoordinates()) {
            this.rightClickOptions.add(new RightClickOption(String.format("X: %d, Y: %d, Z: %d", x, y, z), this.rightClickOptions.size(), this){

                @Override
                public void onAction(GuiScreen screen) {
                    SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
                }
            });
        }
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_edit", this.rightClickOptions.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        }.setNameFormatArgs("E"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_teleport", this.rightClickOptions.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
                SupportMods.xaeroMinimap.teleportToWaypoint(screen, Waypoint.this);
            }

            @Override
            public boolean isActive() {
                return SupportMods.xaeroMinimap.canTeleport();
            }
        }.setNameFormatArgs("T"));
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_restore" : (Waypoint.this.disabled ? "gui.xaero_right_click_waypoint_enable" : "gui.xaero_right_click_waypoint_disable");
            }

            @Override
            public void onAction(GuiScreen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.disableWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("H"));
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_delete_confirm" : "gui.xaero_right_click_waypoint_delete";
            }

            @Override
            public void onAction(GuiScreen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.deleteWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("DEL"));
    }

    public String getName() {
        return I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
    }

    public void renderWaypoint(GuiScreen gui, double wpScale, float x, float y, boolean viewing, TextureManager textureManager, FontRenderer fontRenderer, WaypointSymbolCreator symbolCreator, boolean renderBackground, ScaledResolution scaledRes) {
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        textureManager.func_110577_a(WorldMap.guiTextures);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)wpScale, (double)wpScale, (double)1.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int color = this.color;
        String symbol = this.symbol;
        int type = this.type;
        if (renderBackground) {
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)visibilityAlpha);
        }
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU = 70;
            flagW = 43;
        }
        GlStateManager.func_179109_b((float)((float)(-flagW) / 2.0f), (float)(-flagH + 1), (float)0.0f);
        if (renderBackground) {
            Gui.func_146110_a((int)0, (int)0, (float)flagU, (float)flagV, (int)flagW, (int)flagH, (float)256.0f, (float)256.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        float oldDestAlpha = this.destAlpha;
        this.destAlpha = viewing ? 255.0f : 0.0f;
        if (oldDestAlpha != this.destAlpha) {
            this.alphaAnim = new SlowingAnimation(this.alpha, this.destAlpha, 0.8, 1.0);
        }
        if (this.alphaAnim != null) {
            this.alpha = (float)this.alphaAnim.getCurrent();
        }
        float alpha = this.alpha;
        int symbolTexture = 0;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.func_78256_a(symbol);
        int symbolFrameWidth = stringWidth / 2 > 4 ? 64 : 32;
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)1);
        if (type == 0 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolTexture = symbolCreator.getSymbolTexture(symbol, scaledRes);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolTexture = symbolCreator.getDeathSymbolTexture(scaledRes);
        }
        if (symbolTexture != 0) {
            GlStateManager.func_179131_c((float)visibilityAlpha, (float)visibilityAlpha, (float)visibilityAlpha, (float)visibilityAlpha);
            GlStateManager.func_179144_i((int)symbolTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-1.0f - (float)symbolWidth / 2.0f), (float)(32 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)symbolFrameWidth, (int)32, (float)symbolFrameWidth, (float)32.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if ((int)alpha > 0) {
            int c = (int)alpha << 24 | color & 0xFFFFFF;
            int tbg = (int)(alpha / 255.0f * 200.0f) << 24;
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = this.getName();
            int len = fontRenderer.func_78256_a(name);
            GlStateManager.func_179109_b((float)0.0f, (float)(renderBackground ? -38 : -11), (float)0.0f);
            GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)1.0f);
            int bgLen = Math.max(len + 2, 10);
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)9, (int)c);
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)8, (int)tbg);
            GlStateManager.func_179147_l();
            if ((int)alpha > 3) {
                fontRenderer.func_175065_a(name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false);
            }
        }
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderInMenu(GuiScreen gui, int x, int y, int mouseX, int mouseY, double scale, boolean elementEnabled, boolean hovered, Minecraft mc, boolean pressed) {
        GlStateManager.func_179094_E();
        if (hovered) {
            GlStateManager.func_179109_b((float)(pressed ? 1.0f : 2.0f), (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        if (this.type == 1) {
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)this.color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(minimapTextures);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_73729_b(1, 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_73729_b(0, 0, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179090_x();
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)this.color);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.type == 0) {
            mc.field_71466_p.func_175065_a(this.symbol, (float)(5 - mc.field_71466_p.func_78256_a(this.symbol) / 2), 1.0f, -1, true);
        }
        String name = this.getName();
        if (this.global) {
            name = "* " + name;
        }
        int len = mc.field_71466_p.func_78256_a(name);
        int textX = -3 - len;
        int infoIconWidth = 10;
        Gui.func_73734_a((int)(textX - 2 - (this.disabled ? infoIconWidth : 0) - (this.temporary ? infoIconWidth : 0)), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.field_71466_p.func_175065_a(name, (float)textX, 0.0f, -1, true);
        GlStateManager.func_179147_l();
        int infoIconOffset = infoIconWidth;
        if (this.disabled) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_73729_b(textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        if (this.temporary) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_73729_b(textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderShadow(float brightness, GuiScreen gui, double wpScale, float x, float y, TextureManager textureManager) {
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        textureManager.func_110577_a(WorldMap.guiTextures);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)wpScale, (double)wpScale, (double)1.0);
        GlStateManager.func_179109_b((float)-14.0f, (float)-41.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)(brightness * visibilityAlpha));
        gui.func_73729_b(0, 19, 0, 117, 41, 22);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int getLeftSideLength(Minecraft mc) {
        return 9 + mc.field_71466_p.func_78256_a(this.getName());
    }

    public String getSetName() {
        return this.setName;
    }

    public String getComparisonName() {
        String comparisonName = this.getName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        return this.rightClickOptions;
    }

    @Override
    public boolean isRightClickValid() {
        return SupportMods.xaeroMinimap.waypointExists(this);
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return this.color;
    }
}

