/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.misc.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;

public class MapPixel {
    private static final float DEFAULT_AMBIENT_LIGHT = 0.7f;
    private static final float DEFAULT_AMBIENT_LIGHT_COLORED = 0.2f;
    private static final float DEFAULT_AMBIENT_LIGHT_WHITE = 0.5f;
    private static final float DEFAULT_MAX_DIRECT_LIGHT = 0.6666667f;
    private static final float GLOWING_MAX_DIRECT_LIGHT = 0.22222224f;
    protected int state = 0;
    protected byte colourType = (byte)-1;
    protected int customColour;
    protected byte light = 0;
    protected boolean glowing = false;

    public void getPixelColours(int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, MapBlock block, int height, ArrayList<Overlay> overlays, BlockPos.MutableBlockPos mutableGlobalPos, float shadowR, float shadowG, float shadowB) {
        int colour = 0;
        int topLightValue = this.light;
        int lightMin = 9;
        float brightnessR = 1.0f;
        float brightnessG = 1.0f;
        float brightnessB = 1.0f;
        mutableGlobalPos.func_181079_c(mapTile.getChunkX() * 16 + x, height, mapTile.getChunkZ() * 16 + z);
        if (this.state != 0) {
            if (WorldMap.settings.colours == 0) {
                colour = mapWriter.loadBlockColourFromTexture(this.state, true, (BlockPos)mutableGlobalPos);
            } else {
                try {
                    IBlockState blockState = Misc.getStateById(this.state);
                    colour = blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().func_149717_k() != 255 && blockState.func_177230_c().func_149717_k() != 0 ? 25825 : blockState.func_177230_c().func_180659_g((IBlockState)blockState).field_76291_p;
                }
                catch (Exception blockState) {
                    // empty catch block
                }
            }
        }
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        boolean isFinalBlock = this instanceof MapBlock;
        if (this.colourType == -1) {
            IBlockState blockState = Misc.getStateById(this.state);
            if (isFinalBlock) {
                mapWriter.getColorTypeCache().getBlockBiomeColour(world, blockState, (BlockPos)mutableGlobalPos, result_dest, block.getBiome());
                this.colourType = (byte)result_dest[0];
                if (result_dest[1] != -1) {
                    block.setBiome(result_dest[1]);
                }
                this.customColour = result_dest[2];
            } else {
                mapWriter.getColorTypeCache().getOverlayBiomeColour(world, blockState, (BlockPos)mutableGlobalPos, result_dest, 1);
                this.colourType = (byte)result_dest[0];
                this.customColour = result_dest[2];
            }
        }
        if (this.colourType != 0 && (WorldMap.settings.biomeColorsVanillaMode || WorldMap.settings.colours == 0)) {
            int c = this.customColour;
            if (isFinalBlock) {
                if (this.colourType == 1) {
                    c = mapWriter.getBiomeColor(0, mutableGlobalPos, mapTile, world);
                } else if (this.colourType == 2) {
                    c = mapWriter.getBiomeColor(1, mutableGlobalPos, mapTile, world);
                }
            } else if (this.colourType == 1) {
                c = mapWriter.getBiomeColor(2, mutableGlobalPos, mapTile, world);
            }
            float rMultiplier = (float)r / 255.0f;
            float gMultiplier = (float)g / 255.0f;
            float bMultiplier = (float)b / 255.0f;
            r = (int)((float)(c >> 16 & 0xFF) * rMultiplier);
            g = (int)((float)(c >> 8 & 0xFF) * gMultiplier);
            b = (int)((float)(c & 0xFF) * bMultiplier);
        }
        if (this.glowing) {
            int total = r + g + b;
            float minBrightness = 407.0f;
            float brightener = Math.max(1.0f, minBrightness / (float)total);
            r = (int)((float)r * brightener);
            g = (int)((float)g * brightener);
            b = (int)((float)b * brightener);
            topLightValue = 15;
        }
        int overlayRed = 0;
        int overlayGreen = 0;
        int overlayBlue = 0;
        float currentTransparencyMultiplier = 1.0f;
        if (overlays != null && !overlays.isEmpty()) {
            int sun = 15;
            for (int i = 0; i < overlays.size(); ++i) {
                Overlay o = overlays.get(i);
                o.getPixelColour(block, result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, mutableGlobalPos, shadowR, shadowG, shadowB);
                if (i == 0) {
                    topLightValue = o.light;
                }
                float transparency = o.getTransparency();
                float overlayIntensity = this.getBlockBrightness(lightMin, o.light, sun) * transparency * currentTransparencyMultiplier;
                overlayRed = (int)((float)overlayRed + (float)result_dest[0] * overlayIntensity);
                overlayGreen = (int)((float)overlayGreen + (float)result_dest[1] * overlayIntensity);
                overlayBlue = (int)((float)overlayBlue + (float)result_dest[2] * overlayIntensity);
                if ((sun -= o.getOpacity()) < 0) {
                    sun = 0;
                }
                currentTransparencyMultiplier *= 1.0f - transparency;
            }
            if (!this.glowing) {
                brightnessG = brightnessB = this.getBlockBrightness(lightMin, this.light, sun);
                brightnessR = brightnessB;
            }
        }
        if (isFinalBlock) {
            if (block.slopeUnknown) {
                if (block.getState() != 0) {
                    block.fixHeightType(x, z, mapTile, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, block.getHeight(), false);
                } else {
                    block.setVerticalSlope((byte)0);
                    block.setDiagonalSlope((byte)0);
                    block.slopeUnknown = false;
                }
            }
            float depthBrightness = 1.0f;
            int slopes = WorldMap.settings.terrainSlopes;
            if (!this.glowing) {
                int block_height = block.getHeight();
                boolean caving = block.isCaveBlock() && block_height != -1 && block_height < 127;
                float caveBrightness = (float)block_height / 127.0f;
                if (caving) {
                    brightnessG = brightnessB = caveBrightness;
                    brightnessR = brightnessB;
                }
                if (!caving && WorldMap.settings.terrainDepth && block_height != -1) {
                    float min;
                    depthBrightness = (float)height / 63.0f;
                    float max = slopes >= 2 ? 1.0f : 1.15f;
                    float f = min = slopes >= 2 ? 0.9f : 0.7f;
                    if (depthBrightness > max) {
                        depthBrightness = max;
                    } else if (depthBrightness < min) {
                        depthBrightness = min;
                    }
                }
            }
            if (slopes > 0 && !block.slopeUnknown) {
                byte verticalSlope = block.getVerticalSlope();
                if (slopes == 1) {
                    if (verticalSlope > 0) {
                        depthBrightness = (float)((double)depthBrightness * 1.15);
                    } else if (verticalSlope < 0) {
                        depthBrightness = (float)((double)depthBrightness * 0.85);
                    }
                } else {
                    byte diagonalSlope = block.getDiagonalSlope();
                    float ambientLightColored = 0.2f;
                    float ambientLightWhite = 0.5f;
                    float maxDirectLight = 0.6666667f;
                    if (this.glowing) {
                        ambientLightColored = 0.0f;
                        ambientLightWhite = 1.0f;
                        maxDirectLight = 0.22222224f;
                    }
                    float cos = 0.0f;
                    if (slopes == 2) {
                        float crossZ = -verticalSlope;
                        if (crossZ < 1.0f) {
                            if (verticalSlope == 1 && diagonalSlope == 1) {
                                cos = 1.0f;
                            } else {
                                float crossX = verticalSlope - diagonalSlope;
                                float cast = 1.0f - crossZ;
                                float crossMagnitude = (float)Math.sqrt(crossX * crossX + 1.0f + crossZ * crossZ);
                                cos = (float)((double)(cast / crossMagnitude) / Math.sqrt(2.0));
                            }
                        }
                    } else if (verticalSlope >= 0) {
                        if (verticalSlope == 1) {
                            cos = 1.0f;
                        } else {
                            float surfaceDirectionMagnitude = (float)Math.sqrt(verticalSlope * verticalSlope + 1);
                            float castToMostLit = verticalSlope + 1;
                            cos = (float)((double)(castToMostLit / surfaceDirectionMagnitude) / Math.sqrt(2.0));
                        }
                    }
                    float directLightClamped = 0.0f;
                    if (cos == 1.0f) {
                        directLightClamped = maxDirectLight;
                    } else if (cos > 0.0f) {
                        directLightClamped = (float)Math.ceil(cos * 10.0f) / 10.0f * maxDirectLight * 0.88388f;
                    }
                    float whiteLight = ambientLightWhite + directLightClamped;
                    brightnessR *= shadowR * ambientLightColored + whiteLight;
                    brightnessG *= shadowG * ambientLightColored + whiteLight;
                    brightnessB *= shadowB * ambientLightColored + whiteLight;
                }
            }
            brightnessR *= depthBrightness;
            brightnessG *= depthBrightness;
            brightnessB *= depthBrightness;
        }
        result_dest[0] = (int)((float)r * brightnessR * currentTransparencyMultiplier + (float)overlayRed);
        if (result_dest[0] > 255) {
            result_dest[0] = 255;
        }
        result_dest[1] = (int)((float)g * brightnessG * currentTransparencyMultiplier + (float)overlayGreen);
        if (result_dest[1] > 255) {
            result_dest[1] = 255;
        }
        result_dest[2] = (int)((float)b * brightnessB * currentTransparencyMultiplier + (float)overlayBlue);
        if (result_dest[2] > 255) {
            result_dest[2] = 255;
        }
        result_dest[3] = (int)(this.getPixelLight(lightMin, topLightValue) * 255.0f);
    }

    public float getBlockBrightness(float min, int l, int sun) {
        return (min + (float)Math.max(sun, l)) / (15.0f + min);
    }

    private float getPixelLight(float min, int topLightValue) {
        return topLightValue == 0 ? 0.0f : this.getBlockBrightness(min, topLightValue, 0);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setLight(byte light) {
        this.light = light;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public byte getColourType() {
        return this.colourType;
    }

    public void setColourType(byte colourType) {
        this.colourType = colourType;
    }

    public int getCustomColour() {
        return this.customColour;
    }

    public void setCustomColour(int customColour) {
        this.customColour = customColour;
    }
}

