/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapWriter;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class Overlay
extends MapPixel {
    private short opacity;
    private float transparency;

    public Overlay(int state, int[] biome, int transparency, byte light, boolean glowing) {
        this.write(state, biome, transparency, light, glowing);
    }

    public void write(int state, int[] biome, float transparency, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.colourType = (byte)biome[0];
        this.customColour = biome[2];
        this.transparency = transparency;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        int id = this.state & 0xFFF;
        return (this.state & 0xFFFF0000) == 0 && (id == 9 || id == 8);
    }

    public int getParametres() {
        int usedColourType = this.colourType < 0 ? 0 : this.colourType & 3;
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.opacity > 1 ? 8 : 0;
        parametres |= this.light << 4;
        return parametres |= usedColourType << 8;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, BlockPos.MutableBlockPos mutableGlobalPos, float shadowR, float shadowG, float shadowB) {
        super.getPixelColours(result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, block, -1, null, mutableGlobalPos, shadowR, shadowG, shadowB);
    }

    public String toString() {
        return "(S: " + this.state + ", CT: " + this.colourType + ", CC: " + this.customColour + ", A: " + this.transparency + ", O: " + this.opacity + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.transparency == p.transparency && this.light == p.light && this.state == p.state;
    }

    void fillManagerKeyHolder(Object[] keyHolder) {
        keyHolder[0] = this.state;
        keyHolder[1] = this.colourType;
        keyHolder[2] = this.customColour;
        keyHolder[3] = this.light;
        keyHolder[4] = this.opacity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (short)(this.opacity + toAdd);
    }

    public int getOpacity() {
        return this.opacity;
    }

    public float getTransparency() {
        return this.transparency;
    }
}

