/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.block.WorldGenRubTree;
import ic2.core.block.type.ResourceBlock;
import ic2.core.init.MainConfig;
import ic2.core.ref.BlockName;
import ic2.core.util.BiomeUtil;
import ic2.core.util.ConfigUtil;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Ic2WorldDecorator
implements IWorldGenerator {
    private static final String chunkDataTag = "ic2WorldGen";
    private static final String keyRubberTree = "rubberTree";
    private static final String keyCopperOre = "copperOre";
    private static final String keyLeadOre = "leadOre";
    private static final String keyTinOre = "tinOre";
    private static final String keyUraniumOre = "uraniumOre";

    public Ic2WorldDecorator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        assert (!event.world.field_72995_K);
        NBTTagCompound nbt = event.getData().func_74775_l(chunkDataTag);
        WorldData.get((World)event.world).worldGenData.put(event.getChunk(), nbt);
        Ic2WorldDecorator.checkRetroGen(event.getChunk(), nbt);
    }

    private static void checkRetroGen(Chunk chunk, NBTTagCompound nbt) {
        if (!chunk.func_177419_t()) {
            return;
        }
        if (Ic2WorldDecorator.getCheckLimit() <= 0 || Ic2WorldDecorator.getUpdateLimit() <= 0) {
            return;
        }
        float epsilon = 1.0E-5f;
        float treeScale = Ic2WorldDecorator.getTreeScale() - epsilon;
        float oreScale = Ic2WorldDecorator.getOreScale(chunk.func_177412_p()) - epsilon;
        if (treeScale <= 0.0f && oreScale <= 0.0f) {
            return;
        }
        if (Ic2WorldDecorator.rubberTreeGenEnabled() && nbt.func_74760_g(keyRubberTree) < treeScale || Ic2WorldDecorator.copperOreGenEnabled() && nbt.func_74760_g(keyCopperOre) < oreScale || Ic2WorldDecorator.leadOreGenEnabled() && nbt.func_74760_g(keyLeadOre) < oreScale || Ic2WorldDecorator.tinOreGenEnabled() && nbt.func_74760_g(keyTinOre) < oreScale || Ic2WorldDecorator.uraniumOreGenEnabled() && nbt.func_74760_g(keyUraniumOre) < oreScale) {
            WorldData.get((World)chunk.func_177412_p()).chunksToDecorate.add(chunk);
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        assert (!event.world.field_72995_K);
        NBTTagCompound nbt = WorldData.get((World)event.world).worldGenData.get(event.getChunk());
        if (nbt != null && !nbt.func_82582_d()) {
            event.getData().func_74782_a(chunkDataTag, (NBTBase)nbt);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        WorldData worldData = WorldData.get(event.world, false);
        if (worldData == null) {
            return;
        }
        worldData.worldGenData.remove(event.getChunk());
        worldData.chunksToDecorate.remove(event.getChunk());
    }

    public static void onTick(World world, WorldData worldData) {
        if (worldData.chunksToDecorate.isEmpty()) {
            return;
        }
        int chunksToCheck = Ic2WorldDecorator.getCheckLimit();
        int chunksToDecorate = Ic2WorldDecorator.getUpdateLimit();
        long worldSeed = world.func_72905_C();
        Random rnd = new Random(worldSeed);
        long xSeed = rnd.nextLong() >> 3;
        long zSeed = rnd.nextLong() >> 3;
        int baseHeight = world.func_181545_F() + 1;
        float treeScale = Ic2WorldDecorator.getTreeScale();
        float oreScale = Ic2WorldDecorator.getOreScale(world);
        int skip = worldData.chunksToDecorate.size() - chunksToCheck;
        if (skip > 0) {
            skip = IC2.random.nextInt(skip + 1);
        }
        Iterator<Chunk> it = worldData.chunksToDecorate.iterator();
        while (skip > 0) {
            --skip;
            it.next();
        }
        while (it.hasNext()) {
            Chunk chunk = it.next();
            if (Ic2WorldDecorator.hasNeighborChunks(chunk)) {
                float extra;
                NBTTagCompound nbt = worldData.worldGenData.get(chunk);
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                long chunkSeed = xSeed * (long)chunk.field_76635_g + zSeed * (long)chunk.field_76647_h ^ worldSeed;
                rnd.setSeed(chunkSeed);
                long rubberTreeSeed = rnd.nextLong();
                long copperOreSeed = rnd.nextLong();
                long tinOreSeed = rnd.nextLong();
                long uraniumOreSeed = rnd.nextLong();
                long leadOreSeed = rnd.nextLong();
                if (Ic2WorldDecorator.rubberTreeGenEnabled()) {
                    float f;
                    extra = treeScale - nbt.func_74760_g(keyRubberTree);
                    if (f > 0.0f) {
                        Ic2WorldDecorator.genRubberTree(rnd, rubberTreeSeed, chunk, extra);
                    }
                }
                if (Ic2WorldDecorator.copperOreGenEnabled()) {
                    float f;
                    extra = oreScale - nbt.func_74760_g(keyCopperOre);
                    if (f > 0.0f) {
                        Ic2WorldDecorator.genCopperOre(rnd, copperOreSeed, chunk, baseHeight, extra);
                    }
                }
                if (Ic2WorldDecorator.leadOreGenEnabled()) {
                    float f;
                    extra = oreScale - nbt.func_74760_g(keyLeadOre);
                    if (f > 0.0f) {
                        Ic2WorldDecorator.genLeadOre(rnd, leadOreSeed, chunk, baseHeight, extra);
                    }
                }
                if (Ic2WorldDecorator.tinOreGenEnabled()) {
                    float f;
                    extra = oreScale - nbt.func_74760_g(keyTinOre);
                    if (f > 0.0f) {
                        Ic2WorldDecorator.genTinOre(rnd, tinOreSeed, chunk, baseHeight, extra);
                    }
                }
                if (Ic2WorldDecorator.uraniumOreGenEnabled()) {
                    float f;
                    extra = oreScale - nbt.func_74760_g(keyUraniumOre);
                    if (f > 0.0f) {
                        Ic2WorldDecorator.genUraniumOre(rnd, uraniumOreSeed, chunk, baseHeight, extra);
                    }
                }
                it.remove();
                if (--chunksToDecorate == 0) break;
            }
            if (--chunksToCheck != 0) continue;
            break;
        }
    }

    private static boolean hasNeighborChunks(Chunk chunk) {
        int z;
        int x;
        IChunkProvider provider = chunk.func_177412_p().func_72863_F();
        return provider.func_73149_a((x = chunk.field_76635_g) - 1, (z = chunk.field_76647_h) - 1) && provider.func_73149_a(x + 1, z + 1) && provider.func_73149_a(x - 1, z + 1) && provider.func_73149_a(x + 1, z - 1) && provider.func_73149_a(x - 1, z) && provider.func_73149_a(x + 1, z) && provider.func_73149_a(x, z - 1) && provider.func_73149_a(x, z + 1);
    }

    public void generate(Random rnd, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = chunkProvider.func_73154_d(chunkX, chunkZ);
        long rubberTreeSeed = rnd.nextLong();
        long copperOreSeed = rnd.nextLong();
        long tinOreSeed = rnd.nextLong();
        long uraniumOreSeed = rnd.nextLong();
        long leadOreSeed = rnd.nextLong();
        int baseHeight = world.func_181545_F() + 1;
        float treeScale = Ic2WorldDecorator.getTreeScale();
        float oreScale = Ic2WorldDecorator.getOreScale(world);
        if (Ic2WorldDecorator.rubberTreeGenEnabled() && treeScale > 0.0f) {
            Ic2WorldDecorator.genRubberTree(rnd, rubberTreeSeed, chunk, treeScale);
        }
        if (oreScale > 0.0f) {
            if (Ic2WorldDecorator.copperOreGenEnabled()) {
                Ic2WorldDecorator.genCopperOre(rnd, copperOreSeed, chunk, baseHeight, oreScale);
            }
            if (Ic2WorldDecorator.leadOreGenEnabled()) {
                Ic2WorldDecorator.genLeadOre(rnd, leadOreSeed, chunk, baseHeight, oreScale);
            }
            if (Ic2WorldDecorator.tinOreGenEnabled()) {
                Ic2WorldDecorator.genTinOre(rnd, tinOreSeed, chunk, baseHeight, oreScale);
            }
            if (Ic2WorldDecorator.uraniumOreGenEnabled()) {
                Ic2WorldDecorator.genUraniumOre(rnd, uraniumOreSeed, chunk, baseHeight, oreScale);
            }
        }
    }

    private static float getTreeScale() {
        return ConfigUtil.getFloat(MainConfig.get(), "worldgen/treeDensityFactor");
    }

    private static float getOreScale(World world) {
        float quantityScale = ConfigUtil.getFloat(MainConfig.get(), "worldgen/oreDensityFactor");
        int baseHeight = world.func_181545_F() + 1;
        return (float)baseHeight * quantityScale;
    }

    private static void genRubberTree(Random rnd, long seed, Chunk chunk, float baseScale) {
        rnd.setSeed(seed);
        BiomeGenBase[] biomes = new BiomeGenBase[4];
        for (int i = 0; i < 4; ++i) {
            int x = chunk.field_76635_g * 16 + (i & 1) * 15;
            int z = chunk.field_76647_h * 16 + ((i & 2) >>> 1) * 15;
            BlockPos pos = new BlockPos(x, chunk.func_177412_p().func_181545_F(), z);
            biomes[i] = BiomeUtil.getOriginalBiome(chunk.func_177412_p(), pos);
        }
        int rubberTrees = 0;
        for (BiomeGenBase biome : biomes) {
            if (biome == null) continue;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubberTrees += rnd.nextInt(10) + 5;
            }
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
            rubberTrees += rnd.nextInt(5) + 1;
        }
        rubberTrees = Math.round((float)rubberTrees * baseScale);
        if ((rubberTrees /= 2) > 0 && rnd.nextInt(100) < rubberTrees) {
            WorldGenRubTree gen = new WorldGenRubTree(false);
            for (int i = 0; i < rubberTrees; ++i) {
                if (gen.func_180709_b(chunk.func_177412_p(), rnd, new BlockPos(chunk.field_76635_g * 16 + rnd.nextInt(16), chunk.func_177412_p().func_181545_F(), chunk.field_76647_h * 16 + rnd.nextInt(16)))) continue;
                rubberTrees -= 3;
            }
        }
        Ic2WorldDecorator.updateScale(chunk, keyRubberTree, baseScale);
    }

    private static void genCopperOre(Random rnd, long seed, Chunk chunk, int baseHeight, float baseScale) {
        rnd.setSeed(seed);
        float baseCount = 15.0f * baseScale / 64.0f;
        int count = (int)Math.round(rnd.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
        WorldGenMinable gen = new WorldGenMinable(BlockName.resource.getBlockState(ResourceBlock.copper_ore), 10);
        for (int n = 0; n < count; ++n) {
            int x = chunk.field_76635_g * 16 + rnd.nextInt(16);
            int y = Ic2WorldDecorator.zeroRnd(rnd, 40 * baseHeight / 64) + Ic2WorldDecorator.zeroRnd(rnd, 20 * baseHeight / 64) + 10 * baseHeight / 64;
            int z = chunk.field_76647_h * 16 + rnd.nextInt(16);
            gen.func_180709_b(chunk.func_177412_p(), rnd, new BlockPos(x, y, z));
        }
        Ic2WorldDecorator.updateScale(chunk, keyCopperOre, baseScale);
    }

    private static void genLeadOre(Random rnd, long seed, Chunk chunk, int baseHeight, float baseScale) {
        rnd.setSeed(seed);
        float baseCount = 8.0f * baseScale / 64.0f;
        int count = (int)Math.round(rnd.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
        WorldGenMinable gen = new WorldGenMinable(BlockName.resource.getBlockState(ResourceBlock.lead_ore), 4);
        for (int n = 0; n < count; ++n) {
            int x = chunk.field_76635_g * 16 + rnd.nextInt(16);
            int y = Ic2WorldDecorator.zeroRnd(rnd, 64 * baseHeight / 64);
            int z = chunk.field_76647_h * 16 + rnd.nextInt(16);
            gen.func_180709_b(chunk.func_177412_p(), rnd, new BlockPos(x, y, z));
        }
        Ic2WorldDecorator.updateScale(chunk, keyLeadOre, baseScale);
    }

    private static void genTinOre(Random rnd, long seed, Chunk chunk, int baseHeight, float baseScale) {
        rnd.setSeed(seed);
        float baseCount = 25.0f * baseScale / 64.0f;
        int count = (int)Math.round(rnd.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
        WorldGenMinable gen = new WorldGenMinable(BlockName.resource.getBlockState(ResourceBlock.tin_ore), 6);
        for (int n = 0; n < count; ++n) {
            int x = chunk.field_76635_g * 16 + rnd.nextInt(16);
            int y = Ic2WorldDecorator.zeroRnd(rnd, 40 * baseHeight / 64);
            int z = chunk.field_76647_h * 16 + rnd.nextInt(16);
            gen.func_180709_b(chunk.func_177412_p(), rnd, new BlockPos(x, y, z));
        }
        Ic2WorldDecorator.updateScale(chunk, keyTinOre, baseScale);
    }

    private static void genUraniumOre(Random rnd, long seed, Chunk chunk, int baseHeight, float baseScale) {
        rnd.setSeed(seed);
        float baseCount = 20.0f * baseScale / 64.0f;
        int count = (int)Math.round(rnd.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
        WorldGenMinable gen = new WorldGenMinable(BlockName.resource.getBlockState(ResourceBlock.uranium_ore), 3);
        for (int n = 0; n < count; ++n) {
            int x = chunk.field_76635_g * 16 + Ic2WorldDecorator.zeroRnd(rnd, 16);
            int y = Ic2WorldDecorator.zeroRnd(rnd, 64 * baseHeight / 64);
            int z = chunk.field_76647_h * 16 + Ic2WorldDecorator.zeroRnd(rnd, 16);
            gen.func_180709_b(chunk.func_177412_p(), rnd, new BlockPos(x, y, z));
        }
        Ic2WorldDecorator.updateScale(chunk, keyUraniumOre, baseScale);
    }

    private static boolean rubberTreeGenEnabled() {
        return ConfigUtil.getBool(MainConfig.get(), "worldgen/rubberTree");
    }

    private static boolean copperOreGenEnabled() {
        return ConfigUtil.getBool(MainConfig.get(), "worldgen/copperOre");
    }

    private static boolean leadOreGenEnabled() {
        return ConfigUtil.getBool(MainConfig.get(), "worldgen/leadOre");
    }

    private static boolean tinOreGenEnabled() {
        return ConfigUtil.getBool(MainConfig.get(), "worldgen/tinOre");
    }

    private static boolean uraniumOreGenEnabled() {
        return ConfigUtil.getBool(MainConfig.get(), "worldgen/uraniumOre");
    }

    private static int getCheckLimit() {
        return ConfigUtil.getInt(MainConfig.get(), "worldgen/retrogenCheckLimit");
    }

    private static int getUpdateLimit() {
        return ConfigUtil.getInt(MainConfig.get(), "worldgen/retrogenUpdateLimit");
    }

    private static void updateScale(Chunk chunk, String key, float scale) {
        WorldData worldData = WorldData.get(chunk.func_177412_p());
        NBTTagCompound nbt = worldData.worldGenData.get(chunk);
        if (nbt == null) {
            nbt = new NBTTagCompound();
            worldData.worldGenData.put(chunk, nbt);
        }
        nbt.func_74776_a(key, nbt.func_74760_g(key) + scale);
        chunk.func_177427_f(true);
    }

    private static int zeroRnd(Random rnd, int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("The limit must not be negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        return rnd.nextInt(limit);
    }
}

