/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.item.ItemWrapper;
import ic2.core.IC2;
import ic2.core.block.BlockMultiID;
import ic2.core.block.machine.tileentity.TileEntityMagnetizer;
import ic2.core.block.state.IIdProvider;
import ic2.core.ref.BlockName;
import ic2.core.util.Ic2BlockPos;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIC2Fence
extends BlockMultiID<IC2FenceType> {
    public static final IProperty<Boolean> connectEastProperty = PropertyBool.func_177716_a((String)"east");
    public static final IProperty<Boolean> connectNorthProperty = PropertyBool.func_177716_a((String)"north");
    public static final IProperty<Boolean> connectSouthProperty = PropertyBool.func_177716_a((String)"south");
    public static final IProperty<Boolean> connectWestProperty = PropertyBool.func_177716_a((String)"west");
    private static final float halfThickness = 0.125f;

    public static BlockIC2Fence create() {
        return BlockMultiID.create(BlockIC2Fence.class, IC2FenceType.class, new Object[0]);
    }

    private BlockIC2Fence() {
        super(BlockName.fence, Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.typeProperty, this.typeProperty.getDefault()).func_177226_a(connectEastProperty, (Comparable)Boolean.valueOf(false)).func_177226_a(connectNorthProperty, (Comparable)Boolean.valueOf(false)).func_177226_a(connectSouthProperty, (Comparable)Boolean.valueOf(false)).func_177226_a(connectWestProperty, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(BlockName name) {
        Item item = Item.func_150898_a((Block)this);
        if (item == null) {
            return;
        }
        ResourceLocation loc = Util.getName(item);
        if (loc == null) {
            return;
        }
        for (IBlockState state : this.getTypeStates()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(loc.toString() + "/" + ((IC2FenceType)((Object)state.func_177229_b((IProperty)this.typeProperty))).getName(), null));
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{this.getTypeProperty(), connectEastProperty, connectNorthProperty, connectSouthProperty, connectWestProperty});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean isPole = true;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockIC2Fence.isFence(world.func_180495_p(pos.func_177972_a(facing)))) continue;
            isPole = false;
            break;
        }
        if (BlockIC2Fence.canConnectTo(world, pos.func_177972_a(EnumFacing.EAST), EnumFacing.EAST, isPole)) {
            state = state.func_177226_a(connectEastProperty, (Comparable)Boolean.valueOf(true));
        }
        if (BlockIC2Fence.canConnectTo(world, pos.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH, isPole)) {
            state = state.func_177226_a(connectNorthProperty, (Comparable)Boolean.valueOf(true));
        }
        if (BlockIC2Fence.canConnectTo(world, pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH, isPole)) {
            state = state.func_177226_a(connectSouthProperty, (Comparable)Boolean.valueOf(true));
        }
        if (BlockIC2Fence.canConnectTo(world, pos.func_177972_a(EnumFacing.WEST), EnumFacing.WEST, isPole)) {
            state = state.func_177226_a(connectWestProperty, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity rawEntity) {
        boolean slow;
        if (!(rawEntity instanceof EntityPlayer)) {
            return;
        }
        boolean powered = this.isPowered(world, pos, (IC2FenceType)((Object)state.func_177229_b((IProperty)this.typeProperty)));
        EntityPlayer player = (EntityPlayer)rawEntity;
        boolean metalShoes = BlockIC2Fence.hasMetalShoes(player);
        boolean descending = player.func_70093_af();
        boolean bl = slow = player.field_70181_x >= -0.25 || player.field_70181_x < 1.6;
        if (slow) {
            player.field_70143_R = 0.0f;
        }
        if (!powered) {
            if (descending && !slow && metalShoes) {
                player.field_70181_x *= 0.9;
            }
        } else if (descending) {
            if (!slow) {
                player.field_70181_x *= 0.8;
            }
        } else {
            player.field_70181_x += 0.075;
            if (player.field_70181_x > 0.0) {
                player.field_70181_x *= 1.03;
            }
            double maxSpeed = IC2.keyboard.isAltKeyDown(player) ? 0.1 : (metalShoes ? 1.5 : 0.5);
            player.field_70181_x = Math.min(player.field_70181_x, maxSpeed);
        }
        if (!world.field_72995_K) {
            List<TileEntityMagnetizer> magnetizers = this.getMagnetizers((IBlockAccess)world, pos, false);
            for (TileEntityMagnetizer magnetizer : magnetizers) {
                IC2.network.get(true).updateTileEntityField(magnetizer, "energy");
            }
        }
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        boolean pole = true;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockIC2Fence.isFence(world.func_180495_p(pos.func_177972_a(facing)))) continue;
            pole = false;
            break;
        }
        boolean zneg = BlockIC2Fence.canConnectTo((IBlockAccess)world, pos.func_177978_c(), EnumFacing.NORTH, pole);
        boolean zpos = BlockIC2Fence.canConnectTo((IBlockAccess)world, pos.func_177968_d(), EnumFacing.SOUTH, pole);
        boolean xneg = BlockIC2Fence.canConnectTo((IBlockAccess)world, pos.func_177976_e(), EnumFacing.WEST, pole);
        boolean xpos = BlockIC2Fence.canConnectTo((IBlockAccess)world, pos.func_177974_f(), EnumFacing.EAST, pole);
        float boundxneg = 0.375f;
        float boundxpos = 0.625f;
        float boundzneg = 0.375f;
        float boundzpos = 0.625f;
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        if (zneg || zpos) {
            this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.5f, boundzpos);
            super.func_180638_a(world, pos, state, mask, list, collidingEntity);
        }
        boundzneg = 0.375f;
        boundzpos = 0.625f;
        if (xneg) {
            boundxneg = 0.0f;
        }
        if (xpos) {
            boundxpos = 1.0f;
        }
        if (xneg || xpos || !zneg && !zpos) {
            this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.5f, boundzpos);
            super.func_180638_a(world, pos, state, mask, list, collidingEntity);
        }
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.0f, boundzpos);
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        boolean pole = true;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockIC2Fence.isFence(world.func_180495_p(pos.func_177972_a(facing)))) continue;
            pole = false;
            break;
        }
        boolean zneg = BlockIC2Fence.canConnectTo(world, pos.func_177978_c(), EnumFacing.NORTH, pole);
        boolean zpos = BlockIC2Fence.canConnectTo(world, pos.func_177968_d(), EnumFacing.SOUTH, pole);
        boolean xneg = BlockIC2Fence.canConnectTo(world, pos.func_177976_e(), EnumFacing.WEST, pole);
        boolean xpos = BlockIC2Fence.canConnectTo(world, pos.func_177974_f(), EnumFacing.EAST, pole);
        float boundxneg = 0.375f;
        float boundxpos = 0.625f;
        float boundzneg = 0.375f;
        float boundzpos = 0.625f;
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        if (xneg) {
            boundxneg = 0.0f;
        }
        if (xpos) {
            boundxpos = 1.0f;
        }
        this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.0f, boundzpos);
    }

    private static boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing side, boolean isPole) {
        IBlockState state = world.func_180495_p(pos);
        return BlockIC2Fence.isFence(state) || isPole && BlockIC2Fence.getMagnetizer(world, pos, side, state, false) != null;
    }

    private static boolean isFence(IBlockState state) {
        return state.func_177230_c() instanceof BlockIC2Fence || state.func_177230_c() instanceof BlockFence;
    }

    private static TileEntityMagnetizer getMagnetizer(IBlockAccess world, BlockPos pos, EnumFacing side, IBlockState state, boolean checkPower) {
        if (state.func_177230_c() != BlockName.te.getInstance()) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMagnetizer) {
            TileEntityMagnetizer ret = (TileEntityMagnetizer)te;
            if (side != null && !side.func_176734_d().equals((Object)ret.getFacing())) {
                return null;
            }
            if (!checkPower || ret.canBoost()) {
                return ret;
            }
        }
        return null;
    }

    public static boolean hasMetalShoes(EntityPlayer player) {
        Item item;
        ItemStack shoes = player.field_71071_by.field_70460_b[0];
        return shoes != null && ((item = shoes.func_77973_b()) == Items.field_151167_ab || item == Items.field_151151_aj || item == Items.field_151029_X || ItemWrapper.isMetalArmor(shoes, player));
    }

    private boolean isPowered(World world, BlockPos start, IC2FenceType type) {
        if (!type.canBoost) {
            return false;
        }
        List<TileEntityMagnetizer> magnetizers = this.getMagnetizers((IBlockAccess)world, start, true);
        if (magnetizers.isEmpty()) {
            return false;
        }
        double multiplier = 1.0 / (double)magnetizers.size();
        for (TileEntityMagnetizer magnetizer : magnetizers) {
            magnetizer.boost(multiplier);
        }
        return true;
    }

    private List<TileEntityMagnetizer> getMagnetizers(IBlockAccess world, BlockPos start, boolean checkPower) {
        int maxRange = 20;
        ArrayList<TileEntityMagnetizer> ret = new ArrayList<TileEntityMagnetizer>();
        Ic2BlockPos center = new Ic2BlockPos((Vec3i)start);
        Ic2BlockPos tmp = new Ic2BlockPos();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            Ic2BlockPos nPos = tmp.set((Vec3i)center).move(facing);
            IBlockState state = nPos.getBlockState(world);
            if (BlockIC2Fence.isFence(state)) {
                return Collections.emptyList();
            }
            TileEntityMagnetizer te = BlockIC2Fence.getMagnetizer(world, nPos, facing, state, checkPower);
            if (te == null) continue;
            ret.add(te);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        int minDir = 0;
        int maxDir = 2;
        for (int dy = 1; dy <= 20; ++dy) {
            boolean abort = false;
            block2: for (int dir = minDir; dir < maxDir; ++dir) {
                int offset = dir * 2 - 1;
                center.setY(start.func_177956_o() + offset * dy);
                IBlockState centerState = center.getBlockState(world);
                if (!(centerState.func_177230_c() instanceof BlockIC2Fence) || !((IC2FenceType)((Object)centerState.func_177229_b((IProperty)this.typeProperty))).canBoost) {
                    if (dir == 0) {
                        minDir = 1;
                    } else {
                        maxDir = 1;
                    }
                    if (minDir != maxDir) break;
                    abort = true;
                    break;
                }
                int oldSize = ret.size();
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    Ic2BlockPos nPos = tmp.set((Vec3i)center).move(facing);
                    IBlockState state = nPos.getBlockState(world);
                    if (BlockIC2Fence.isFence(state)) {
                        if (dir == 0) {
                            minDir = 1;
                        } else {
                            maxDir = 1;
                        }
                        if (minDir == maxDir) {
                            abort = true;
                        }
                        while (ret.size() > oldSize) {
                            ret.remove(ret.size() - 1);
                        }
                        continue block2;
                    }
                    TileEntityMagnetizer te = BlockIC2Fence.getMagnetizer(world, nPos, facing, state, checkPower);
                    if (te == null) continue;
                    abort = true;
                    ret.add(te);
                }
            }
            if (abort) break;
        }
        return ret;
    }

    public static enum IC2FenceType implements IIdProvider
    {
        iron(true);

        public final boolean canBoost;

        private IC2FenceType(boolean canBoost) {
            this.canBoost = canBoost;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public int getId() {
            return this.ordinal();
        }
    }
}

