/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.crop.TileEntityCrop;
import ic2.core.model.AbstractSmartBlockModel;
import ic2.core.model.ModelUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CropModel
extends AbstractSmartBlockModel {
    private final Map<ResourceLocation, IBakedModel> models = CropModel.generateModelLocations();

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return this.models.keySet();
    }

    private static Map<ResourceLocation, IBakedModel> generateModelLocations() {
        HashMap<ResourceLocation, IBakedModel> ret = new HashMap<ResourceLocation, IBakedModel>();
        StringBuilder name = new StringBuilder();
        name.append("blocks/crop/");
        int reset0 = name.length();
        for (CropCard cropCard : Crops.instance.getCrops()) {
            name.append(cropCard.getName());
            name.append("_");
            int reset1 = name.length();
            for (int size = 1; size <= cropCard.getMaxSize(); ++size) {
                name.append(size);
                ret.put(new ResourceLocation(cropCard.getOwner().toLowerCase(Locale.ENGLISH), name.toString()), null);
                name.setLength(reset1);
            }
            name.setLength(reset0);
        }
        return ret;
    }

    private static ResourceLocation getModelLocation(String resourceDomain, String cropName, int cropSize) {
        return new ResourceLocation(resourceDomain, "blocks/crop/" + cropName + "_" + cropSize);
    }

    @Override
    protected IBakedModel handleBlockState(Ic2BlockState.Ic2BlockStateInstance state) {
        if (!state.hasValue(TileEntityCrop.modelProperty)) {
            return ModelUtil.getMissingModel();
        }
        return ModelUtil.getModel(state.getValue(TileEntityCrop.modelProperty));
    }
}

