/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class InvSlotConsumableLiquid
extends InvSlotConsumable {
    private OpType opType;

    public InvSlotConsumableLiquid(TileEntityInventory base1, String name1, int count) {
        this(base1, name1, InvSlot.Access.I, count, InvSlot.InvSide.TOP, OpType.Drain);
    }

    public InvSlotConsumableLiquid(TileEntityInventory base1, String name1, InvSlot.Access access1, int count, InvSlot.InvSide preferredSide1, OpType opType1) {
        super(base1, name1, access1, count, preferredSide1);
        this.opType = opType1;
    }

    @Override
    public boolean accepts(ItemStack stack) {
        block10: {
            IFluidContainerItem containerItem;
            FluidStack prevFluid;
            Item item;
            block11: {
                item = stack.func_77973_b();
                if (item == null) {
                    return false;
                }
                if (this.opType == OpType.Drain || this.opType == OpType.Both) {
                    Object containerFluid = null;
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                        containerFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                    } else if (item instanceof IFluidContainerItem) {
                        containerFluid = ((IFluidContainerItem)item).getFluid(stack);
                    }
                    if (containerFluid != null && ((FluidStack)containerFluid).amount > 0 && this.acceptsLiquid(containerFluid.getFluid())) {
                        return true;
                    }
                }
                if (this.opType != OpType.Fill && this.opType != OpType.Both) break block10;
                if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) break block11;
                if (this.getPossibleFluids() == null) {
                    return true;
                }
                for (Fluid fluid : this.getPossibleFluids()) {
                    if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)stack) == null) continue;
                    return true;
                }
                break block10;
            }
            if (!(item instanceof IFluidContainerItem) || (prevFluid = (containerItem = (IFluidContainerItem)item).getFluid(stack)) != null && containerItem.getCapacity(stack) <= prevFluid.amount) break block10;
            if (this.getPossibleFluids() == null) {
                return true;
            }
            ItemStack singleStack = StackUtil.copyWithSize(stack, 1);
            for (Fluid fluid : this.getPossibleFluids()) {
                if (containerItem.fill(singleStack, new FluidStack(fluid, Integer.MAX_VALUE), false) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack drain(Fluid fluid, int maxAmount, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (fluid != null && !this.acceptsLiquid(fluid)) {
            return null;
        }
        if (this.opType != OpType.Drain && this.opType != OpType.Both) {
            return null;
        }
        ItemStack stack = this.get();
        if (stack == null) {
            return null;
        }
        FluidStack ret = LiquidUtil.drain(stack, fluid, maxAmount, output, LiquidUtil.FluidContainerOutputMode.EmptyFullToOutput, fluid == null || simulate);
        if (ret == null) {
            return null;
        }
        if (fluid == null) {
            if (!this.acceptsLiquid(ret.getFluid())) {
                output.setValue(null);
                return null;
            }
            if (!simulate) {
                ret = LiquidUtil.drain(stack, fluid, maxAmount, output, LiquidUtil.FluidContainerOutputMode.EmptyFullToOutput, false);
            }
        }
        if (stack.field_77994_a <= 0) {
            this.put(null);
        }
        return ret;
    }

    public int fill(FluidStack fs, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (fs == null || fs.amount <= 0) {
            return 0;
        }
        if (this.opType != OpType.Fill && this.opType != OpType.Both) {
            return 0;
        }
        ItemStack stack = this.get();
        if (stack == null) {
            return 0;
        }
        int ret = LiquidUtil.fill(stack, fs, output, LiquidUtil.FluidContainerOutputMode.EmptyFullToOutput, simulate);
        if (stack.field_77994_a <= 0) {
            this.put(null);
        }
        return ret;
    }

    public boolean transferToTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        FluidStack fluid;
        int space = tank.getCapacity();
        Fluid fluidRequired = null;
        FluidStack tankFluid = tank.getFluid();
        if (tankFluid != null) {
            space -= tankFluid.amount;
            fluidRequired = tankFluid.getFluid();
        }
        if ((fluid = this.drain(fluidRequired, space, output, true)) == null) {
            return false;
        }
        int amount = tank.fill(fluid, !simulate);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            this.drain(fluidRequired, amount, output, false);
        }
        return true;
    }

    public boolean transferFromTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        FluidStack tankFluid = tank.drain(tank.getFluidAmount(), false);
        if (tankFluid == null || tankFluid.amount <= 0) {
            return false;
        }
        int amount = this.fill(tankFluid, output, simulate);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            tank.drain(amount, true);
        }
        return true;
    }

    public void setOpType(OpType opType1) {
        this.opType = opType1;
    }

    protected boolean acceptsLiquid(Fluid fluid) {
        return true;
    }

    protected Iterable<Fluid> getPossibleFluids() {
        return null;
    }

    public static enum OpType {
        Drain,
        Fill,
        Both,
        None;

    }
}

