/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.leg;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.core.energy.leg.EnergyNetLocalLeg;
import java.util.Collections;
import java.util.List;

abstract class BasicEnergyTileTask {
    final IEnergyTile tile;
    final List<IEnergyTile> subTiles;
    final int depth;

    BasicEnergyTileTask(IEnergyTile tile) {
        this.tile = tile;
        this.subTiles = tile instanceof IMetaDelegate ? ((IMetaDelegate)tile).getSubTiles() : Collections.singletonList(tile);
        this.depth = tile instanceof IEnergySource ? (int)EnergyNet.instance.getPowerFromTier(((IEnergySource)tile).getSourceTier()) : Integer.MAX_VALUE;
    }

    abstract void run(EnergyNetLocalLeg var1);

    static class EndThreadTask
    extends BasicEnergyTileTask {
        EndThreadTask() {
            super(null);
        }

        @Override
        void run(EnergyNetLocalLeg enet) {
        }
    }

    static class EnergyTileUnloadTask
    extends BasicEnergyTileTask {
        EnergyTileUnloadTask(IEnergyTile tile) {
            super(tile);
        }

        @Override
        void run(EnergyNetLocalLeg enet) {
            enet.removeTileEntity(this);
        }
    }

    static class EnergyTileLoadTask
    extends BasicEnergyTileTask {
        EnergyTileLoadTask(IEnergyTile tile) {
            super(tile);
        }

        @Override
        void run(EnergyNetLocalLeg enet) {
            enet.addTileEntity(this);
        }
    }
}

