/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.leg;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IExplosionPowerOverride;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.energy.tile.IOverloadHandler;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IWorldTickCallback;
import ic2.core.WorldData;
import ic2.core.energy.leg.BasicEnergyTileTask;
import ic2.core.energy.leg.EnergyPath;
import ic2.core.energy.leg.ThreadEnergyNet;
import ic2.core.energy.leg.Tile;
import ic2.core.util.LogCategory;
import ic2.core.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class EnergyNetLocalLeg {
    private final Map<BlockPos, Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>>> pathCache = new HashMap<BlockPos, Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>>>();
    private final Map<Tile, List<EnergyPath>> energySourceToEnergyPathMap = new HashMap<Tile, List<EnergyPath>>();
    private final Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new HashMap<EntityLivingBase, Integer>();
    private final Set<BlockPos> blocksToUpdate = new HashSet<BlockPos>();
    final ThreadEnergyNet thread;
    final Map<BlockPos, Tile> registeredTiles = new HashMap<BlockPos, Tile>();
    final World world;
    private final List<Tile> sources = new ArrayList<Tile>();
    private static int apiDemandsErrorCooldown = 0;
    private static int apiEmitErrorCooldown = 0;
    private static final double minConductionLoss = 1.0E-4;

    public EnergyNetLocalLeg(World world) {
        this.world = world;
        this.thread = new ThreadEnergyNet(this);
    }

    public static EnergyNetLocalLeg getForWorld(World world) {
        WorldData worldData = WorldData.get(world);
        return worldData.energyNetLeg;
    }

    synchronized void tickEnd() {
        IC2.platform.profilerStartSection("EnergyNet");
        for (Tile tile : this.sources) {
            int unused;
            int offer;
            IMultiEnergySource source1;
            IEnergySource source = (IEnergySource)tile.entity;
            List<EnergyPath> paths = this.energySourceToEnergyPathMap.get(tile);
            if (paths != null) {
                for (EnergyPath path : this.energySourceToEnergyPathMap.get(tile)) {
                    path.energyConducted = 0L;
                    path.maxPacketConducted = 0;
                }
            }
            int amount = 1;
            if (source instanceof IMultiEnergySource && (source1 = (IMultiEnergySource)source).sendMultipleEnergyPackets()) {
                amount = source1.getMultipleEnergyPacketAmount();
            }
            for (int j = 0; j < amount && (offer = (int)source.getOfferedEnergy()) > 0 && (unused = this.emitEnergyFrom(tile, offer)) < offer; ++j) {
                source.drawEnergy(offer - unused);
            }
        }
        if (this.world.field_73011_w.func_177502_q() == 0) {
            if (apiDemandsErrorCooldown > 0) {
                --apiDemandsErrorCooldown;
            }
            if (apiEmitErrorCooldown > 0) {
                --apiEmitErrorCooldown;
            }
        }
        IC2.platform.profilerEndSection();
    }

    synchronized void tickStart() {
        IC2.platform.profilerEndStartSection("EnergyNet");
        for (Map.Entry<EntityLivingBase, Integer> entry : this.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S() || damage <= 0) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        this.entityLivingToShockEnergyMap.clear();
        for (BlockPos pos : this.blocksToUpdate) {
            this.world.func_180496_d(pos, this.world.func_180495_p(pos).func_177230_c());
        }
        this.blocksToUpdate.clear();
        IC2.platform.profilerEndSection();
    }

    public synchronized void addTileEntity(BasicEnergyTileTask.EnergyTileLoadTask task) {
        IEnergyTile te = task.tile;
        assert (EnergyNet.instance.getWorld(te) == this.world);
        BlockPos pos = EnergyNet.instance.getPos(task.tile);
        if (!this.world.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4)) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " is in an invalid chunk, aborting");
            return;
        }
        BlockPos coords = EnergyNet.instance.getPos(te);
        if (this.registeredTiles.containsKey(coords)) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " is already added, aborting");
            return;
        }
        if (this.world.func_180495_p(coords).func_177230_c().isAir((IBlockAccess)this.world, coords)) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " was added too early, postponing");
            IC2.tickHandler.requestSingleWorldTick(this.world, new PostPonedAddCallback(task));
            return;
        }
        this.pathCache.clear();
        for (IEnergyTile subTile : task.subTiles) {
            Tile tile = new Tile(this, te, subTile);
            this.registeredTiles.put(EnergyNet.instance.getPos(subTile), tile);
            if (te instanceof IEnergyAcceptor) {
                List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, task.depth);
                for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                    Tile srcTile = reverseEnergyPath.target;
                    if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)EnergyNetLocalLeg.getMaxOutput((IEnergySource)srcTile.entity) <= reverseEnergyPath.loss) continue;
                    this.energySourceToEnergyPathMap.remove(srcTile);
                }
            }
            if (te instanceof IEnergySource && ((IEnergySource)te).getSourceTier() > 0) {
                this.sources.add(tile);
            }
            this.markBlockForUpdateWithNeighbors(EnergyNet.instance.getPos(tile.subTile).getImmutable());
        }
    }

    public synchronized void removeTileEntity(BasicEnergyTileTask.EnergyTileUnloadTask task) {
        IEnergyTile te = task.tile;
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.removeTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        this.pathCache.clear();
        for (IEnergyTile subTile : task.subTiles) {
            Tile tile = this.registeredTiles.get(EnergyNet.instance.getPos(subTile));
            if (tile == null) {
                IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.removeTileEntity: " + te + " is already removed, aborting");
                return;
            }
            if (tile.entity instanceof IEnergyAcceptor) {
                List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, task.depth);
                block1: for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                    Tile srcTile = reverseEnergyPath.target;
                    if (!this.energySourceToEnergyPathMap.containsKey(srcTile)) continue;
                    if (tile.entity instanceof IEnergyConductor) {
                        this.energySourceToEnergyPathMap.remove(srcTile);
                        continue;
                    }
                    Iterator<EnergyPath> it = this.energySourceToEnergyPathMap.get(srcTile).iterator();
                    while (it.hasNext()) {
                        if (it.next().target != tile) continue;
                        it.remove();
                        continue block1;
                    }
                }
            }
            if (te instanceof IEnergySource) {
                this.energySourceToEnergyPathMap.remove(tile);
                this.sources.remove(tile);
            }
            tile.destroy();
            this.registeredTiles.remove(EnergyNet.instance.getPos(tile.subTile));
            this.markBlockForUpdateWithNeighbors(EnergyNet.instance.getPos(te));
        }
    }

    public synchronized int emitEnergyFrom(Tile tile, int amount) {
        IEnergyTile srcTe = tile.entity;
        if (EnergyNet.instance.getWorld(srcTe) != this.world) {
            IC2.log.warn(LogCategory.EnergyNet, "Improperly loaded IEnergyTile: " + srcTe + " on ENet for " + this.world);
            return amount;
        }
        if (srcTe instanceof TileEntity && ((TileEntity)srcTe).func_145837_r()) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.emitEnergyFrom: " + srcTe + " is invalid (TileEntity.isInvalid()), aborting");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(tile)) {
            this.pathCache.clear();
            this.energySourceToEnergyPathMap.put(tile, this.discover(tile, false, EnergyNetLocalLeg.getMaxOutput((IEnergySource)tile.entity)));
        }
        ArrayList<EnergyPath> activeEnergyPaths = new ArrayList<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tile)) {
            IEnergySink sink = (IEnergySink)energyPath.target.entity;
            if (!(sink.getDemandedEnergy() > 0.0) || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        LinkedList<IEnergyTile> blocksToExplode = new LinkedList<IEnergyTile>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            ArrayList<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new ArrayList();
            activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                Tile dstTile = energyPath.target;
                IEnergySink sink = (IEnergySink)dstTile.entity;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int injected = energyProvided - energyLoss;
                    int energyReturned = (int)sink.injectEnergy(energyPath.targetDirection, injected, EnergyNet.instance.getTierFromPower(injected));
                    if (energyReturned == 0 && sink.getDemandedEnergy() > 0.0) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                        blocksToExplode.add(0, dstTile.entity);
                    } else if (energyReturned >= injected) {
                        energyReturned = injected;
                        if (apiDemandsErrorCooldown == 0) {
                            apiDemandsErrorCooldown = 600;
                            IEnergyTile te = dstTile.entity;
                            String c = (EnergyNet.instance.getWorld(te) == null ? "unknown" : Integer.valueOf(EnergyNet.instance.getWorld((IEnergyTile)te).field_73011_w.func_177502_q())) + ":" + EnergyNet.instance.getPos(te);
                            IC2.log.warn(LogCategory.EnergyNet, "API ERROR: " + dstTile + " (" + c + ") didn't implement demandsEnergy() properly, no energy from injectEnergy accepted (" + energyReturned + ") although demandsEnergy() requested " + (energyProvided - energyLoss) + ".");
                        }
                    }
                    energyConsumed += energyProvided - energyReturned;
                    int energyInjected = energyProvided - energyLoss - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.energyConducted += (long)energyInjected;
            energyPath.maxPacketConducted = Math.max(energyPath.maxPacketConducted, energyInjected);
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = this.world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_178781_a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (EntityLivingBase entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (Tile condTile : energyPath.conductors) {
                        IEnergyTile te = condTile.entity;
                        IEnergyConductor conductor = (IEnergyConductor)te;
                        BlockPos tilePos = EnergyNet.instance.getPos(te);
                        if (!entityLiving.func_174813_aQ().func_72326_a(AxisAlignedBB.func_178781_a((double)(tilePos.func_177958_n() - 1), (double)(tilePos.func_177956_o() - 1), (double)(tilePos.func_177952_p() - 1), (double)(tilePos.func_177958_n() + 2), (double)(tilePos.func_177956_o() + 2), (double)(tilePos.func_177952_p() + 2)))) continue;
                        int shockEnergy = (int)((double)energyInjected - conductor.getInsulationEnergyAbsorption());
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (conductor.getInsulationEnergyAbsorption() != (double)energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (Tile condTile : energyPath.conductors) {
                        IEnergyConductor conductor = (IEnergyConductor)condTile.entity;
                        if (!((double)energyInjected >= conductor.getInsulationBreakdownEnergy())) continue;
                        conductor.removeInsulation();
                        if (!(conductor.getInsulationEnergyAbsorption() < (double)energyPath.minInsulationEnergyAbsorption)) continue;
                        energyPath.minInsulationEnergyAbsorption = (int)conductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected >= energyPath.minConductorBreakdownEnergy) {
                for (Tile tile2 : energyPath.conductors) {
                    IEnergyConductor conductor = (IEnergyConductor)tile2.entity;
                    if (!((double)energyInjected >= conductor.getConductorBreakdownEnergy())) continue;
                    conductor.removeConductor();
                }
            }
            if (!((double)energyInjected > EnergyNet.instance.getPowerFromTier(((IEnergySink)energyPath.target.entity).getSinkTier()))) continue;
            EnergyNetLocalLeg.explodeTile(energyPath.target.entity, EnergyNet.instance.getTierFromPower(energyInjected));
        }
        return amount;
    }

    public synchronized Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>> getEnergyPathsContaining(Tile tile) {
        BlockPos coords = EnergyNet.instance.getPos(tile.subTile);
        if (!this.pathCache.containsKey(coords)) {
            LinkedList<EnergyPath> in = new LinkedList<EnergyPath>();
            LinkedList<EnergyPath> out = new LinkedList<EnergyPath>();
            if (this.energySourceToEnergyPathMap.containsKey(tile)) {
                out.addAll((Collection)this.energySourceToEnergyPathMap.get(tile));
            }
            if (tile.entity instanceof IEnergyConductor || tile.entity instanceof IEnergySink) {
                List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
                for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                    Tile srcTile = reverseEnergyPath.target;
                    if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)EnergyNetLocalLeg.getMaxOutput((IEnergySource)srcTile.entity) <= reverseEnergyPath.loss) continue;
                    for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(srcTile)) {
                        if (tile.entity instanceof IEnergySink && energyPath.target == tile) {
                            in.add(energyPath);
                            continue;
                        }
                        if (!(tile.entity instanceof IEnergyConductor) || !energyPath.conductors.contains(tile)) continue;
                        out.add(energyPath);
                        in.add(energyPath);
                    }
                }
            }
            this.pathCache.put(coords, new Tuple.T2(in, out));
        }
        return this.pathCache.get(coords);
    }

    private Tile getNeighbor(Tile te, EnumFacing dir) {
        return te.neighbors[dir.ordinal()];
    }

    private List<EnergyPath> discover(Tile emitter, boolean reverse, int lossLimit) {
        HashMap<Tile, EnergyBlockLink> reachedTileEntities = new HashMap<Tile, EnergyBlockLink>();
        LinkedList<Tile> tileEntitiesToCheck = new LinkedList<Tile>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            Tile tile = (Tile)tileEntitiesToCheck.remove();
            BlockPos pos = EnergyNet.instance.getPos(tile.subTile);
            if (!this.world.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
            double currentLoss = 0.0;
            if (tile != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)tile)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(tile, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tile == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tile.entity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tile.entity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tile) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tile)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tile, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tile.entity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tile);
                tileEntitiesToCheck.add(validReceiver.tile);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            Tile tile = (Tile)entry.getKey();
            if ((reverse || !(tile.entity instanceof IEnergySink)) && (!reverse || !(tile.entity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tile;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter.entity instanceof IEnergySource) {
                while ((tile = this.getNeighbor(tile, energyBlockLink.direction)) != emitter) {
                    if (tile.entity instanceof IEnergyConductor) {
                        IEnergyTile te = tile.entity;
                        IEnergyConductor energyConductor = (IEnergyConductor)te;
                        BlockPos pos = EnergyNet.instance.getPos(te);
                        if (pos.func_177958_n() < energyPath.minX) {
                            energyPath.minX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() < energyPath.minY) {
                            energyPath.minY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() < energyPath.minZ) {
                            energyPath.minZ = pos.func_177952_p();
                        }
                        if (pos.func_177958_n() > energyPath.maxX) {
                            energyPath.maxX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() > energyPath.maxY) {
                            energyPath.maxY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() > energyPath.maxZ) {
                            energyPath.maxZ = pos.func_177952_p();
                        }
                        energyPath.conductors.add(tile);
                        if (energyConductor.getInsulationEnergyAbsorption() < (double)energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = (int)energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < (double)energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = (int)energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < (double)energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = (int)energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tile)) != null) continue;
                        IEnergyTile srcTe = emitter.entity;
                        IEnergyTile dstTe = energyPath.target.entity;
                        IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + srcTe + " (" + EnergyNet.instance.getPos(srcTe) + ")\n" + "C: " + te + " (" + EnergyNet.instance.getPos(te) + ")\n" + "R: " + dstTe + " (" + EnergyNet.instance.getPos(dstTe) + ")", new Object[0]);
                        continue;
                    }
                    IC2.log.warn(LogCategory.EnergyNet, "EnergyNet: EnergyBlockLink corrupted (" + energyPath.target.entity + " [" + EnergyNet.instance.getPos(energyPath.target.entity) + "] -> " + tile.entity + " [" + EnergyNet.instance.getPos(tile.entity) + "] -> " + emitter.entity + " [" + EnergyNet.instance.getPos(emitter.entity) + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private List<EnergyTarget> getValidReceivers(Tile emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            Tile target = this.getNeighbor(emitter, direction);
            if (target == null) continue;
            EnumFacing inverseDirection = direction.func_176734_d();
            IEnergyEmitter emitterSource = EnergyNetLocalLeg.asEmitter(emitter);
            IEnergyAcceptor emitterSink = EnergyNetLocalLeg.asAcceptor(emitter);
            IEnergyEmitter targetSource = EnergyNetLocalLeg.asEmitter(target);
            IEnergyAcceptor targetSink = EnergyNetLocalLeg.asAcceptor(target);
            if ((reverse || emitterSource == null || targetSink == null || !emitterSource.emitsEnergyTo(targetSink, direction)) && (!reverse || emitterSink == null || targetSource == null || !emitterSink.acceptsEnergyFrom(targetSource, direction)) || (reverse || targetSink == null || emitterSource == null || !targetSink.acceptsEnergyFrom(emitterSource, inverseDirection)) && (!reverse || targetSource == null || emitterSink == null || !targetSource.emitsEnergyTo(emitterSink, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    private void markBlockForUpdate(BlockPos pos) {
        this.blocksToUpdate.add(pos.getImmutable());
    }

    private void markBlockForUpdateWithNeighbors(BlockPos pos) {
        this.markBlockForUpdate(pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.markBlockForUpdate(pos.func_177972_a(facing));
        }
    }

    private static int getMaxOutput(IEnergySource source) {
        return (int)EnergyNet.instance.getPowerFromTier(source.getSourceTier());
    }

    private static void explodeTile(IEnergyTile te, int tier) {
        World world = EnergyNet.instance.getWorld(te);
        List<IEnergyTile> toExplode = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Collections.singletonList(te);
        for (IEnergyTile current : toExplode) {
            IExplosionPowerOverride override;
            BlockPos pos = EnergyNet.instance.getPos(current);
            TileEntity realTe = world.func_175625_s(pos);
            if (te instanceof IOverloadHandler && ((IOverloadHandler)((Object)te)).onOverload(tier) || realTe instanceof IOverloadHandler && ((IOverloadHandler)realTe).onOverload(tier)) continue;
            float power = 2.5f;
            if (te instanceof IExplosionPowerOverride) {
                override = (IExplosionPowerOverride)((Object)te);
                if (!override.shouldExplode()) continue;
                power = override.getExplosionPower(tier, power);
            } else if (realTe instanceof IExplosionPowerOverride) {
                override = (IExplosionPowerOverride)realTe;
                if (!override.shouldExplode()) continue;
                power = override.getExplosionPower(tier, power);
            }
            world.func_175698_g(pos);
            ExplosionIC2 explosion = new ExplosionIC2(world, null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, power, 0.75f);
            explosion.doExplosion();
        }
    }

    private static IEnergyAcceptor asAcceptor(Tile tile) {
        if (tile.subTile instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile.subTile;
        }
        if (tile.entity instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile.entity;
        }
        return null;
    }

    private static IEnergyEmitter asEmitter(Tile tile) {
        if (tile.subTile instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile.subTile;
        }
        if (tile.entity instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile.entity;
        }
        return null;
    }

    private static class EnergyTarget {
        Tile tile;
        EnumFacing direction;

        EnergyTarget(Tile tile, EnumFacing direction) {
            this.tile = tile;
            this.direction = direction;
        }
    }

    private static class EnergyBlockLink {
        EnumFacing direction;
        double loss;

        EnergyBlockLink(EnumFacing direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    private class PostPonedAddCallback
    implements IWorldTickCallback {
        private final BasicEnergyTileTask task;

        public PostPonedAddCallback(BasicEnergyTileTask task) {
            this.task = task;
        }

        @Override
        public void onTick(World world) {
            if (!world.func_180495_p(EnergyNet.instance.getPos(this.task.tile)).func_177230_c().isAir((IBlockAccess)world, EnergyNet.instance.getPos(this.task.tile))) {
                EnergyNetLocalLeg.this.thread.queue.add(this.task);
            } else {
                IC2.log.info(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + this.task.tile + " unloaded, aborting");
            }
        }
    }
}

