/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import ic2.core.GuiIC2;
import ic2.core.gui.GuiElement;
import ic2.core.init.Localization;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class Text
extends GuiElement<Text> {
    private final Supplier<String> textProvider;
    private final Supplier<Integer> color;
    private final boolean shadow;
    private final boolean fixedHoverWidth;
    private final boolean fixedHoverHeight;
    private final int baseX;
    private final int baseY;
    private final boolean centerX;
    private final boolean centerY;

    public static Text create(int x, int y, String text, int color, boolean shadow) {
        return Text.create(x, y, (Supplier<String>)Suppliers.ofInstance((Object)text), color, shadow);
    }

    public static Text create(int x, int y, Supplier<String> textProvider, int color, boolean shadow) {
        return Text.create(x, y, textProvider, color, shadow, false, false);
    }

    public static Text create(int x, int y, String text, int color, boolean shadow, boolean centerX, boolean centerY) {
        return Text.create(x, y, (Supplier<String>)Suppliers.ofInstance((Object)text), color, shadow, centerX, centerY);
    }

    public static Text create(int x, int y, Supplier<String> textProvider, int color, boolean shadow, boolean centerX, boolean centerY) {
        return Text.create(x, y, -1, -1, textProvider, color, shadow, centerX, centerY);
    }

    public static Text create(int x, int y, int width, int height, Supplier<String> textProvider, int color, boolean shadow, boolean centerX, boolean centerY) {
        return Text.create(x, y, width, height, textProvider, color, shadow, 0, 0, centerX, centerY);
    }

    public static Text create(int x, int y, int width, int height, Supplier<String> textProvider, int color, boolean shadow, int xOffset, int yOffset, boolean centerX, boolean centerY) {
        return Text.create(x, y, width, height, textProvider, (Supplier<Integer>)Suppliers.ofInstance((Object)color), shadow, xOffset, yOffset, centerX, centerY);
    }

    public static Text create(int x, int y, int width, int height, Supplier<String> textProvider, Supplier<Integer> color, boolean shadow, int xOffset, int yOffset, boolean centerX, boolean centerY) {
        boolean fixedHoverHeight;
        boolean fixedHoverWidth;
        if (width < 0) {
            fixedHoverWidth = false;
            width = Text.getWidth(textProvider);
        } else {
            fixedHoverWidth = true;
        }
        if (height < 0) {
            fixedHoverHeight = false;
            height = 8;
        } else {
            fixedHoverHeight = true;
        }
        int baseX = x + xOffset;
        int baseY = y + yOffset;
        if (centerX) {
            if (fixedHoverWidth) {
                baseX += width / 2;
            } else {
                x -= width / 2;
            }
        }
        if (centerY) {
            if (fixedHoverHeight) {
                baseY += (height + 1) / 2;
            } else {
                y -= height / 2;
            }
        }
        return new Text(x, y, width, height, textProvider, color, shadow, fixedHoverWidth, fixedHoverHeight, baseX, baseY, centerX, centerY);
    }

    private Text(int x, int y, int width, int height, Supplier<String> textProvider, Supplier<Integer> color, boolean shadow, boolean fixedHoverWidth, boolean fixedHoverHeight, int baseX, int baseY, boolean centerX, boolean centerY) {
        super(x, y, width, height);
        this.textProvider = textProvider;
        this.color = color;
        this.shadow = shadow;
        this.fixedHoverWidth = fixedHoverWidth;
        this.fixedHoverHeight = fixedHoverHeight;
        this.baseX = baseX;
        this.baseY = baseY;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    private static int getWidth(Supplier<String> textProvider) {
        String text = (String)textProvider.get();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    @Override
    public void drawBackground(GuiIC2<?> gui, int mouseX, int mouseY) {
        String text = (String)this.textProvider.get();
        text = text != null && !text.isEmpty() ? Localization.translate(text) : null;
        int textWidth = text == null ? 0 : gui.getStringWidth(text);
        int textHeight = text == null ? 0 : 8;
        int textX = this.baseX;
        if (this.centerX) {
            textX -= textWidth / 2;
        }
        int textY = this.baseY;
        if (this.centerY) {
            textY -= textHeight / 2;
        }
        if (!this.fixedHoverWidth) {
            this.x = textX;
            this.width = textWidth;
        }
        if (!this.fixedHoverHeight) {
            this.y = textY;
            this.height = textHeight;
        }
        super.drawBackground(gui, mouseX, mouseY);
        if (text != null) {
            gui.drawString(textX, textY, text, (Integer)this.color.get(), this.shadow);
        }
    }

    public static enum TextAlignment {
        Start,
        Center,
        End;

        private static final Map<String, TextAlignment> map;
        public final String name = this.name().toLowerCase(Locale.ENGLISH);

        public static TextAlignment get(String name) {
            return map.get(name);
        }

        private static Map<String, TextAlignment> getMap() {
            TextAlignment[] values = TextAlignment.values();
            HashMap<String, TextAlignment> ret = new HashMap<String, TextAlignment>(values.length);
            for (TextAlignment style : values) {
                ret.put(style.name, style);
            }
            return ret;
        }

        static {
            map = TextAlignment.getMap();
        }
    }
}

