/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui.dynamic;

import com.google.common.base.Supplier;
import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.invslot.InvSlot;
import ic2.core.gui.EnergyGauge;
import ic2.core.gui.FluidSlot;
import ic2.core.gui.GuiElement;
import ic2.core.gui.Image;
import ic2.core.gui.LinkedGauge;
import ic2.core.gui.SlotGrid;
import ic2.core.gui.TankGauge;
import ic2.core.gui.Text;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IFluidTankProvider;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.upgrade.IUpgradableBlock;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class DynamicGui<T extends ContainerBase<? extends IInventory>>
extends GuiIC2<T> {
    public static <T extends IInventory> DynamicGui<ContainerBase<T>> create(T base, EntityPlayer player, GuiParser.GuiNode guiNode) {
        DynamicContainer<T> container = DynamicContainer.create(base, player, guiNode);
        return new DynamicGui<ContainerBase<T>>(player, container, guiNode);
    }

    protected DynamicGui(EntityPlayer player, T container, GuiParser.GuiNode guiNode) {
        super(container, guiNode.width, guiNode.height);
        this.initializeWidgets(player, guiNode);
    }

    private void initializeWidgets(final EntityPlayer player, GuiParser.ParentNode parentNode) {
        for (GuiParser.Node rawNode : parentNode.getNodes()) {
            switch (rawNode.getType()) {
                case energygauge: {
                    if (!(this.container.base instanceof TileEntityBlock) || !((TileEntityBlock)this.container.base).hasComponent(Energy.class)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for energygauge elements");
                    }
                    GuiParser.Node node = (GuiParser.EnergyGaugeNode)rawNode;
                    this.addElement(new EnergyGauge(((GuiParser.EnergyGaugeNode)node).x, ((GuiParser.EnergyGaugeNode)node).y, (TileEntityBlock)this.container.base, ((GuiParser.EnergyGaugeNode)node).style));
                    break;
                }
                case gauge: {
                    if (!(this.container.base instanceof IGuiValueProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for gauge elements");
                    }
                    GuiParser.Node node = (GuiParser.GaugeNode)rawNode;
                    this.addElement(new LinkedGauge(((GuiParser.GaugeNode)node).x, ((GuiParser.GaugeNode)node).y, (IGuiValueProvider)this.container.base, ((GuiParser.GaugeNode)node).name, ((GuiParser.GaugeNode)node).style));
                    break;
                }
                case image: {
                    GuiParser.Node node = (GuiParser.ImageNode)rawNode;
                    this.addElement(Image.create(((GuiParser.ImageNode)node).x, ((GuiParser.ImageNode)node).y, ((GuiParser.ImageNode)node).width, ((GuiParser.ImageNode)node).height, ((GuiParser.ImageNode)node).src, ((GuiParser.ImageNode)node).u, ((GuiParser.ImageNode)node).v));
                    break;
                }
                case playerinventory: {
                    GuiParser.Node node = (GuiParser.PlayerInventoryNode)rawNode;
                    int hotbarOffset = 58;
                    this.addElement(new SlotGrid(((GuiParser.PlayerInventoryNode)node).x, ((GuiParser.PlayerInventoryNode)node).y, 9, 3, SlotGrid.SlotStyle.Normal));
                    this.addElement(new SlotGrid(((GuiParser.PlayerInventoryNode)node).x, ((GuiParser.PlayerInventoryNode)node).y + 58, 9, 1, SlotGrid.SlotStyle.Normal));
                    this.addElement(Text.create(((GuiParser.PlayerInventoryNode)node).x + 1, ((GuiParser.PlayerInventoryNode)node).y - 10, new Supplier<String>(){

                        public String get() {
                            return player.field_71071_by.func_145748_c_().func_150260_c();
                        }
                    }, 0x404040, false));
                    break;
                }
                case slot: {
                    GuiParser.Node node = (GuiParser.SlotNode)rawNode;
                    this.addElement(new SlotGrid(((GuiParser.SlotNode)node).x, ((GuiParser.SlotNode)node).y, 1, 1, ((GuiParser.SlotNode)node).style));
                    break;
                }
                case slotgrid: {
                    if (!(this.container.base instanceof TileEntityInventory)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for slot elements");
                    }
                    GuiParser.Node node = (GuiParser.SlotGridNode)rawNode;
                    InvSlot slot = ((TileEntityInventory)this.container.base).getInvSlot(((GuiParser.SlotGridNode)node).name);
                    if (slot == null) {
                        throw new RuntimeException("invalid invslot name " + ((GuiParser.SlotGridNode)node).name + " for base " + this.container.base);
                    }
                    int size = slot.size();
                    if (size <= ((GuiParser.SlotGridNode)node).offset) break;
                    GuiParser.SlotGridNode.SlotGridDimension dim = ((GuiParser.SlotGridNode)node).getDimension(size);
                    this.addElement(new SlotGrid(((GuiParser.SlotGridNode)node).x, ((GuiParser.SlotGridNode)node).y, dim.cols, dim.rows, ((GuiParser.SlotGridNode)node).style));
                    break;
                }
                case text: {
                    int x;
                    GuiParser.Node node = (GuiParser.TextNode)rawNode;
                    switch (((GuiParser.TextNode)node).align) {
                        case Start: {
                            x = ((GuiParser.TextNode)node).x;
                            break;
                        }
                        case Center: {
                            x = ((GuiParser.TextNode)node).x + this.field_146999_f / 2;
                            break;
                        }
                        case End: {
                            x = ((GuiParser.TextNode)node).x + this.field_146999_f;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid alignment: " + (Object)((Object)((GuiParser.TextNode)node).align));
                        }
                    }
                    this.addElement(Text.create(x, ((GuiParser.TextNode)node).y, ((GuiParser.TextNode)node).width, ((GuiParser.TextNode)node).height, this.createSupplier(((GuiParser.TextNode)node).text), ((GuiParser.TextNode)node).color, ((GuiParser.TextNode)node).shadow, ((GuiParser.TextNode)node).xOffset, ((GuiParser.TextNode)node).yOffset, ((GuiParser.TextNode)node).centerX, ((GuiParser.TextNode)node).centerY));
                    break;
                }
                case gui: {
                    break;
                }
                case fluidtank: {
                    if (!(this.container.base instanceof IFluidTankProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for tank elements");
                    }
                    GuiParser.Node node = (GuiParser.FluidTankNode)rawNode;
                    this.addElement(TankGauge.createNormal(((GuiParser.FluidTankNode)node).x, ((GuiParser.FluidTankNode)node).y, ((IFluidTankProvider)this.container.base).getFluidTank(((GuiParser.FluidTankNode)node).name)));
                    break;
                }
                case fluidslot: {
                    if (!(this.container.base instanceof IFluidTankProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for tank elements");
                    }
                    GuiParser.Node node = (GuiParser.FluidSlotNode)rawNode;
                    this.addElement(FluidSlot.createFluidSlot(((GuiParser.FluidSlotNode)node).x, ((GuiParser.FluidSlotNode)node).y, ((IFluidTankProvider)this.container.base).getFluidTank(((GuiParser.FluidSlotNode)node).name)));
                    break;
                }
            }
            if (!(rawNode instanceof GuiParser.ParentNode)) continue;
            this.initializeWidgets(player, (GuiParser.ParentNode)rawNode);
        }
    }

    private Supplier<String> createSupplier(String text) {
        int pos = text.indexOf(37);
        if (pos == -1) {
            return DynamicGui.createFixedSupplier(text);
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int lastPos = 0;
        while ((pos = text.indexOf(37, pos)) != -1) {
            int endPos;
            for (endPos = pos + 1; endPos < text.length(); ++endPos) {
                char c = text.charAt(endPos);
                if (c == '.' || c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                if (c == '%') break;
                endPos = text.length();
                break;
            }
            if (endPos == text.length()) break;
            if (lastPos < pos) {
                tokens.add(new Token(text.substring(lastPos, pos), true));
            }
            lastPos = endPos + 1;
            tokens.add(new Token(text.substring(pos, lastPos), false));
            pos = lastPos;
        }
        if (lastPos < text.length()) {
            tokens.add(new Token(text.substring(lastPos), true));
        }
        ListIterator it = tokens.listIterator();
        while (it.hasNext()) {
            Token token = (Token)it.next();
            if (token.isConst) continue;
            String value = token.value;
            if (value.equals("%%")) {
                value = "%";
            } else {
                if (!value.equals("%name%")) continue;
                value = this.container.base.func_70005_c_();
            }
            if (value.isEmpty()) {
                it.remove();
                continue;
            }
            token.isConst = true;
            token.value = value;
            it.previous();
            if (it.hasPrevious()) {
                Token prev = (Token)it.previous();
                if (prev.isConst) {
                    prev.value = prev.value + value;
                    it.next();
                    it.next();
                    it.remove();
                    continue;
                }
                it.next();
                it.next();
                continue;
            }
            it.next();
        }
        if (tokens.isEmpty()) {
            return null;
        }
        if (tokens.size() == 1) {
            Token token = (Token)tokens.get(0);
            if (token.isConst) {
                return DynamicGui.createFixedSupplier(token.value);
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    private static Supplier<String> createFixedSupplier(final String text) {
        return new Supplier<String>(){

            public String get() {
                return text;
            }
        };
    }

    @Override
    public void addElement(GuiElement<?> element) {
        super.addElement(element);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        mouseX -= this.field_147003_i;
        mouseY -= this.field_147009_r;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiElement.bindCommonTexture();
        this.drawBackground();
        if (this.container.base instanceof IUpgradableBlock) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(IC2.textureDomain, "textures/gui/infobutton.png"));
            this.drawTexturedRect(3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
        }
        for (GuiElement element : this.elements) {
            if (!element.isEnabled()) continue;
            element.drawBackground(this, mouseX, mouseY);
        }
    }

    private void drawBackground() {
        int side;
        this.drawTexturedRect(-16.0, -16.0, 32.0, 32.0, 0.0, 0.0);
        this.drawTexturedRect(this.field_146999_f - 16, -16.0, 32.0, 32.0, 64.0, 0.0);
        this.drawTexturedRect(-16.0, this.field_147000_g - 16, 32.0, 32.0, 0.0, 64.0);
        this.drawTexturedRect(this.field_146999_f - 16, this.field_147000_g - 16, 32.0, 32.0, 64.0, 64.0);
        for (side = 0; side < 2; ++side) {
            int y = this.field_147000_g * side - 16;
            int v = 64 * side;
            for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                int width = Math.min(32, this.field_146999_f - 16 - x);
                this.drawTexturedRect(x, y, width, 32.0, 32.0, v);
            }
        }
        for (side = 0; side < 2; ++side) {
            int x = this.field_146999_f * side - 16;
            int u = 64 * side;
            for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                int height = Math.min(32, this.field_147000_g - 16 - y);
                this.drawTexturedRect(x, y, 32.0, height, u, 32.0);
            }
        }
        for (int y = 16; y < this.field_147000_g - 16; y += 32) {
            int height = Math.min(32, this.field_147000_g - 16 - y);
            for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                int width = Math.min(32, this.field_146999_f - 16 - x);
                this.drawTexturedRect(x, y, width, height, 32.0, 32.0);
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    private static class Token {
        String value;
        boolean isConst;

        Token(String value, boolean isConst) {
            this.value = value;
            this.isConst = isConst;
        }
    }
}

