/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.core.block.TileEntityBarrel;
import ic2.core.block.state.IIdProvider;
import ic2.core.item.ItemMulti;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemMug
extends ItemMulti<MugType> {
    public ItemMug() {
        super(ItemName.mug, MugType.class);
        this.func_77625_d(1);
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        MugType type = (MugType)this.getType(stack);
        if (type == MugType.empty) {
            if (world.field_72995_K) {
                return false;
            }
            if (world.func_180495_p(pos) != BlockName.te.getBlockState(TeBlock.barrel)) {
                return false;
            }
            TileEntityBarrel barrel = (TileEntityBarrel)world.func_175625_s(pos);
            if (!barrel.getActive() || barrel.getFacing() != side) {
                return false;
            }
            int value = barrel.calculateMetaValue();
            if (barrel.drainLiquid(1)) {
                if (--stack.field_77994_a > 0) {
                    ItemStack is = new ItemStack(ItemName.booze_mug.getInstance(), 1, value);
                    if (!player.field_71071_by.func_70441_a(is)) {
                        player.func_71019_a(is, false);
                    }
                } else {
                    stack.field_77994_a = 1;
                    stack.func_77964_b(value);
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        int extraDuration;
        int maxAmplifier;
        MugType type = (MugType)this.getType(stack);
        if (type == null || type == MugType.empty) {
            return stack;
        }
        switch (type) {
            case cold_coffee: {
                maxAmplifier = 1;
                extraDuration = 600;
                break;
            }
            case dark_coffee: {
                maxAmplifier = 5;
                extraDuration = 1200;
                break;
            }
            case coffee: {
                maxAmplifier = 6;
                extraDuration = 1200;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected type: " + type);
            }
        }
        int highest = 0;
        int x = this.amplifyEffect(player, Potion.field_76424_c, maxAmplifier, extraDuration);
        if (x > highest) {
            highest = x;
        }
        if ((x = this.amplifyEffect(player, Potion.field_76422_e, maxAmplifier, extraDuration)) > highest) {
            highest = x;
        }
        if (type == MugType.coffee) {
            highest -= 2;
        }
        if (highest >= 3) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, (highest - 2) * 200, 0));
            if (highest >= 4) {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 1, highest - 3));
            }
        }
        return this.getItemStack(MugType.empty);
    }

    private int amplifyEffect(EntityPlayer player, Potion potion, int maxAmplifier, int extraDuration) {
        PotionEffect eff = player.func_70660_b(potion);
        if (eff != null) {
            int newAmp = eff.func_76458_c();
            int newDur = eff.func_76459_b();
            if (newAmp < maxAmplifier) {
                ++newAmp;
            }
            eff.func_76452_a(new PotionEffect(eff.func_76456_a(), newDur += extraDuration, newAmp));
            return newAmp;
        }
        player.func_70690_d(new PotionEffect(potion.field_76415_H, 300, 0));
        return 1;
    }

    public int func_77626_a(ItemStack stack) {
        MugType type = (MugType)this.getType(stack);
        if (type == null || type == MugType.empty) {
            return 0;
        }
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        MugType type = (MugType)this.getType(stack);
        if (type == null || type == MugType.empty) {
            return EnumAction.NONE;
        }
        return EnumAction.DRINK;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MugType type = (MugType)this.getType(stack);
        if (type != null && type != MugType.empty) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return super.func_77659_a(stack, world, player);
    }

    public static enum MugType implements IIdProvider
    {
        empty,
        cold_coffee,
        dark_coffee,
        coffee;


        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public int getId() {
            return this.ordinal();
        }
    }
}

