/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemDrill
extends ItemElectricTool
implements IHitSoundOverride {
    protected ItemDrill(ItemName name, int operationEnergyCost, ItemElectricTool.HarvestLevel harvestLevel) {
        super(name, operationEnergyCost, harvestLevel, EnumSet.of(ItemElectricTool.ToolClass.Pickaxe, ItemElectricTool.ToolClass.Shovel));
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase(Locale.ENGLISH).contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77952_i();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_179546_a(player, world, pos, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_180614_a(stack, player, world, pos, side, xOffset, yOffset, zOffset);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHitSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        float hardness = world.func_180495_p(pos).func_177230_c().func_176195_g(world, pos);
        if (hardness > 1.0f || hardness < 0.0f) {
            return "Tools/Drill/DrillHard.ogg";
        }
        return "Tools/Drill/DrillSoft.ogg";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getBreakSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return null;
        }
        float hardness = world.func_180495_p(pos).func_177230_c().func_176195_g(world, pos);
        if ((double)hardness > 0.5 || !ElectricItem.manager.canUse(stack, 80.0)) {
            return null;
        }
        return "Tools/Drill/DrillSoft.ogg";
    }

    @Override
    public float getDigSpeed(ItemStack stack, IBlockState state) {
        float speed = super.getDigSpeed(stack, state);
        EntityPlayer player = ItemDrill.getPlayerHoldingItem(stack);
        if (player != null) {
            if (player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)player)) {
                speed *= 5.0f;
            }
            if (!player.field_70122_E) {
                speed *= 5.0f;
            }
        }
        return speed;
    }

    private static EntityPlayer getPlayerHoldingItem(ItemStack stack) {
        if (IC2.platform.isRendering()) {
            return ItemDrill.getClientPlayerHoldingItem(stack);
        }
        for (EntityPlayer player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (player.field_71071_by.func_70448_g() != stack) continue;
            return player;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getClientPlayerHoldingItem(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71071_by.func_70448_g() == stack) {
            return player;
        }
        return null;
    }
}

