/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IBoxable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.BlockRubWood;
import ic2.core.item.ItemIC2;
import ic2.core.item.type.MiscResourceType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemTreetap
extends ItemIC2
implements IBoxable {
    public ItemTreetap() {
        super(ItemName.treetap);
        this.func_77625_d(1);
        this.func_77656_e(16);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == BlockName.rubber_wood.getInstance()) {
            ItemTreetap.attemptExtract(player, world, pos, side, state, null);
            if (!world.field_72995_K) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public static boolean attemptExtract(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        assert (state.func_177230_c() == BlockName.rubber_wood.getInstance());
        BlockRubWood.RubberWoodState rwState = (BlockRubWood.RubberWoodState)((Object)state.func_177229_b(BlockRubWood.stateProperty));
        if (rwState.isPlain() || rwState.facing != side) {
            return false;
        }
        if (rwState.wet) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, state.func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)rwState.getDry())));
                if (stacks != null) {
                    stacks.add(StackUtil.copyWithSize(ItemName.misc_resource.getItemStack(MiscResourceType.resin), world.field_73012_v.nextInt(3) + 1));
                } else {
                    ItemTreetap.ejectResin(world, pos, side, world.field_73012_v.nextInt(3) + 1);
                }
                if (player != null) {
                    IC2.achievements.issueAchievement(player, "acquireResin");
                }
            }
            if (world.field_72995_K && player != null) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
            world.func_175656_a(pos, state.func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
        }
        if (world.field_73012_v.nextInt(5) == 0) {
            if (!world.field_72995_K) {
                ItemTreetap.ejectResin(world, pos, side, 1);
                if (stacks != null) {
                    stacks.add(ItemName.misc_resource.getItemStack(MiscResourceType.resin));
                } else {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                }
            }
            if (world.field_72995_K && player != null) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        return false;
    }

    private static void ejectResin(World world, BlockPos pos, EnumFacing side, int quantity) {
        double ejectBias = 0.3;
        double ejectX = (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.3;
        double ejectY = (double)pos.func_177956_o() + 0.5 + (double)side.func_96559_d() * 0.3;
        double ejectZ = (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.3;
        for (int i = 0; i < quantity; ++i) {
            EntityItem entityitem = new EntityItem(world, ejectX, ejectY, ejectZ, ItemName.misc_resource.getItemStack(MiscResourceType.resin));
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

