/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.recipe.IFluidRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutputFluid;
import ic2.core.IC2;
import ic2.core.init.MainConfig;
import ic2.core.util.LiquidUtil;
import ic2.core.util.LogCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class BasicFluidRecipeManager
implements IFluidRecipeManager {
    private final Map<IRecipeInput, RecipeOutputFluid> recipes = new HashMap<IRecipeInput, RecipeOutputFluid>();
    private final Map<Item, Map<Integer, IFluidRecipeManager.RecipeIoContainerFluid>> recipeCache = new IdentityHashMap<Item, Map<Integer, IFluidRecipeManager.RecipeIoContainerFluid>>();
    private final List<IFluidRecipeManager.RecipeIoContainerFluid> uncacheableRecipes = new ArrayList<IFluidRecipeManager.RecipeIoContainerFluid>();
    private boolean oreRegisterEventSubscribed;

    @Override
    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, FluidStack ... outputs) {
        return this.addRecipe(input, new RecipeOutputFluid(metadata, outputs), replace);
    }

    @Override
    public RecipeOutputFluid getOutputFor(ItemStack input, boolean adjustInput) {
        if (input == null) {
            return null;
        }
        IFluidRecipeManager.RecipeIoContainerFluid data = this.getRecipe(input);
        if (data == null) {
            return null;
        }
        if (!(input.field_77994_a < data.input.getAmount() || input.func_77973_b().hasContainerItem(input) && input.field_77994_a != data.input.getAmount())) {
            if (adjustInput) {
                if (input.func_77973_b().hasContainerItem(input)) {
                    ItemStack container = input.func_77973_b().getContainerItem(input);
                    input.func_150996_a(container.func_77973_b());
                    input.field_77994_a = container.field_77994_a;
                    input.func_77964_b(container.func_77952_i());
                    input.func_77982_d(container.func_77978_p());
                } else {
                    input.field_77994_a -= data.input.getAmount();
                }
            }
            return data.output;
        }
        return null;
    }

    @Override
    public Iterable<IFluidRecipeManager.RecipeIoContainerFluid> getRecipes() {
        return new Iterable<IFluidRecipeManager.RecipeIoContainerFluid>(){

            @Override
            public Iterator<IFluidRecipeManager.RecipeIoContainerFluid> iterator() {
                return new Iterator<IFluidRecipeManager.RecipeIoContainerFluid>(){
                    private final Iterator<Map.Entry<IRecipeInput, RecipeOutputFluid>> recipeIt;
                    private IRecipeInput lastInput;
                    {
                        this.recipeIt = BasicFluidRecipeManager.this.recipes.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.recipeIt.hasNext();
                    }

                    @Override
                    public IFluidRecipeManager.RecipeIoContainerFluid next() {
                        Map.Entry<IRecipeInput, RecipeOutputFluid> nextRaw = this.recipeIt.next();
                        this.lastInput = nextRaw.getKey();
                        return new IFluidRecipeManager.RecipeIoContainerFluid(nextRaw.getKey(), nextRaw.getValue());
                    }

                    @Override
                    public void remove() {
                        this.recipeIt.remove();
                        BasicFluidRecipeManager.this.removeCachedRecipes(this.lastInput);
                    }
                };
            }
        };
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        ArrayList<IFluidRecipeManager.RecipeIoContainerFluid> datas = new ArrayList<IFluidRecipeManager.RecipeIoContainerFluid>();
        for (Map.Entry<IRecipeInput, RecipeOutputFluid> entry : this.recipes.entrySet()) {
            if (entry.getKey().getClass() != RecipeInputOreDict.class) continue;
            RecipeInputOreDict recipe = (RecipeInputOreDict)entry.getKey();
            if (!recipe.input.equals(event.Name)) continue;
            datas.add(new IFluidRecipeManager.RecipeIoContainerFluid(entry.getKey(), entry.getValue()));
        }
        for (IFluidRecipeManager.RecipeIoContainerFluid recipeIoContainerFluid : datas) {
            this.addToCache(event.Ore, recipeIoContainerFluid);
        }
    }

    private IFluidRecipeManager.RecipeIoContainerFluid getRecipe(ItemStack input) {
        Map<Integer, IFluidRecipeManager.RecipeIoContainerFluid> metaMap = this.recipeCache.get(input.func_77973_b());
        if (metaMap != null) {
            IFluidRecipeManager.RecipeIoContainerFluid data = metaMap.get(Short.MAX_VALUE);
            if (data != null) {
                return data;
            }
            int meta = input.func_77952_i();
            data = metaMap.get(meta);
            if (data != null) {
                return data;
            }
        }
        for (IFluidRecipeManager.RecipeIoContainerFluid data : this.uncacheableRecipes) {
            if (!data.input.matches(input)) continue;
            return data;
        }
        return null;
    }

    private boolean addRecipe(IRecipeInput input, RecipeOutputFluid output, boolean replace) {
        if (input == null) {
            this.displayError("The recipe input is null");
            return false;
        }
        ListIterator<FluidStack> it = output.outputs.listIterator();
        while (it.hasNext()) {
            FluidStack fluidStack = it.next();
            if (fluidStack == null) {
                this.displayError("An output FluidStack is null.");
                return false;
            }
            if (!LiquidUtil.check(fluidStack)) {
                this.displayError("The output FluidStack " + LiquidUtil.toStringSafe(fluidStack) + " is invalid.");
                return false;
            }
            it.set(fluidStack.copy());
        }
        for (ItemStack is : input.getInputs()) {
            IFluidRecipeManager.RecipeIoContainerFluid data = this.getRecipe(is);
            if (data == null) continue;
            if (replace) {
                do {
                    this.recipes.remove(data.input);
                    this.removeCachedRecipes(data.input);
                } while ((data = this.getRecipe(is)) != null);
                continue;
            }
            return false;
        }
        this.recipes.put(input, output);
        this.addToCache(input, output);
        return true;
    }

    private void addToCache(IRecipeInput input, RecipeOutputFluid output) {
        IFluidRecipeManager.RecipeIoContainerFluid data = new IFluidRecipeManager.RecipeIoContainerFluid(input, output);
        List<ItemStack> stacks = this.getStacksFromRecipe(input);
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                this.addToCache(stack, data);
            }
            if (input.getClass() == RecipeInputOreDict.class && !this.oreRegisterEventSubscribed) {
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.oreRegisterEventSubscribed = true;
            }
        } else {
            this.uncacheableRecipes.add(data);
        }
    }

    private void addToCache(ItemStack stack, IFluidRecipeManager.RecipeIoContainerFluid data) {
        Item item = stack.func_77973_b();
        Map<Integer, IFluidRecipeManager.RecipeIoContainerFluid> metaMap = this.recipeCache.get(item);
        if (metaMap == null) {
            metaMap = new HashMap<Integer, IFluidRecipeManager.RecipeIoContainerFluid>();
            this.recipeCache.put(item, metaMap);
        }
        int meta = stack.func_77952_i();
        metaMap.put(meta, data);
    }

    private void removeCachedRecipes(IRecipeInput input) {
        List<ItemStack> stacks = this.getStacksFromRecipe(input);
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                Item item = stack.func_77973_b();
                int meta = stack.func_77952_i();
                Map<Integer, IFluidRecipeManager.RecipeIoContainerFluid> map = this.recipeCache.get(item);
                if (map == null) {
                    IC2.log.warn(LogCategory.Recipe, "Inconsistent recipe cache, the entry for the item " + item + " is missing.");
                    continue;
                }
                map.remove(meta);
                if (!map.isEmpty()) continue;
                this.recipeCache.remove(item);
            }
        } else {
            Iterator<IFluidRecipeManager.RecipeIoContainerFluid> it = this.uncacheableRecipes.iterator();
            while (it.hasNext()) {
                IFluidRecipeManager.RecipeIoContainerFluid data = it.next();
                if (data.input != input) continue;
                it.remove();
            }
        }
    }

    private List<ItemStack> getStacksFromRecipe(IRecipeInput recipe) {
        if (recipe.getClass() == RecipeInputItemStack.class) {
            return recipe.getInputs();
        }
        if (recipe.getClass() == RecipeInputOreDict.class) {
            Integer meta = ((RecipeInputOreDict)recipe).meta;
            if (meta == null) {
                return recipe.getInputs();
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(recipe.getInputs());
            ListIterator<ItemStack> it = ret.listIterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (stack.func_77952_i() == meta.intValue()) continue;
                stack = stack.func_77946_l();
                stack.func_77964_b(meta.intValue());
                it.set(stack);
            }
            return ret;
        }
        return null;
    }

    private void displayError(String msg) {
        if (!MainConfig.ignoreInvalidRecipes) {
            throw new RuntimeException(msg);
        }
        IC2.log.warn(LogCategory.Recipe, msg);
    }
}

