/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.blueprints.RecursiveBlueprintReader;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileArchitect
extends TileBuildCraft
implements IInventory,
IBoxProvider,
ICommandReceiver,
ILEDProvider {
    public String currentAuthorName = "";
    public Mode mode = Mode.NONE;
    public Box box = new Box();
    public String name = "";
    public BlueprintReadConfiguration readConfiguration = new BlueprintReadConfiguration();
    public ArrayList<LaserData> subLasers = new ArrayList();
    public ArrayList<BlockIndex> subBlueprints = new ArrayList();
    private SimpleInventory inv = new SimpleInventory(2, "Architect", 1);
    private RecursiveBlueprintReader reader;
    private boolean clientIsWorking;
    private boolean initialized;

    public TileArchitect() {
        this.box.kind = Box.Kind.BLUE_STRIPES;
    }

    public void storeBlueprintStack(ItemStack blueprintStack) {
        this.func_70299_a(1, blueprintStack);
        this.func_70298_a(0, 1);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.mode == Mode.COPY && this.reader != null) {
            this.reader.iterate();
            if (this.reader.isDone()) {
                this.reader = null;
                this.sendNetworkUpdate();
            }
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.field_145850_b.field_72995_K && !this.initialized) {
            if (!this.box.isInitialized()) {
                IAreaProvider a = Utils.getNearbyAreaProvider((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
                if (a != null) {
                    this.mode = Mode.COPY;
                    this.box.initialize(a);
                    a.removeFromWorld();
                    this.sendNetworkUpdate();
                    return;
                }
                this.mode = Mode.NONE;
            } else {
                this.mode = Mode.COPY;
            }
            this.initialized = true;
            this.sendNetworkUpdate();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0) {
            this.initializeBlueprint();
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.initializeBlueprint();
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Template";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.mode != Mode.NONE && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("box")) {
            this.box.initialize(nbt.func_74775_l("box"));
        }
        this.inv.readFromNBT(nbt);
        this.mode = Mode.values()[nbt.func_74771_c("mode")];
        this.name = nbt.func_74779_i("name");
        this.currentAuthorName = nbt.func_74779_i("lastAuthor");
        if (nbt.func_74764_b("readConfiguration")) {
            this.readConfiguration.readFromNBT(nbt.func_74775_l("readConfiguration"));
        }
        NBTTagList subBptList = nbt.func_150295_c("subBlueprints", 10);
        for (int i = 0; i < subBptList.func_74745_c(); ++i) {
            BlockIndex index = new BlockIndex(subBptList.func_150305_b(i));
            this.addSubBlueprint(index);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbt.func_74782_a("box", (NBTBase)boxStore);
        }
        this.inv.writeToNBT(nbt);
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("lastAuthor", this.currentAuthorName);
        NBTTagCompound readConf = new NBTTagCompound();
        this.readConfiguration.writeToNBT(readConf);
        nbt.func_74782_a("readConfiguration", (NBTBase)readConf);
        NBTTagList subBptList = new NBTTagList();
        for (BlockIndex b : this.subBlueprints) {
            NBTTagCompound subBpt = new NBTTagCompound();
            b.writeTo(subBpt);
            subBptList.func_74742_a((NBTBase)subBpt);
        }
        nbt.func_74782_a("subBlueprints", (NBTBase)subBptList);
    }

    private boolean getIsWorking() {
        return this.mode == Mode.COPY ? this.reader != null : false;
    }

    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        NetworkUtils.writeUTF((ByteBuf)stream, (String)this.name);
        stream.writeBoolean(this.getIsWorking());
        stream.writeByte(this.mode.ordinal());
        if (this.mode == Mode.COPY) {
            this.readConfiguration.writeData(stream);
            stream.writeShort(this.subLasers.size());
            for (LaserData ld : this.subLasers) {
                ld.writeData(stream);
            }
        }
    }

    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        this.name = NetworkUtils.readUTF((ByteBuf)stream);
        this.clientIsWorking = stream.readBoolean();
        this.mode = Mode.values()[stream.readByte()];
        if (this.mode == Mode.COPY) {
            this.readConfiguration.readData(stream);
            int size = stream.readUnsignedShort();
            this.subLasers.clear();
            for (int i = 0; i < size; ++i) {
                LaserData ld = new LaserData();
                ld.readData(stream);
                this.subLasers.add(ld);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    private void initializeBlueprint() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.mode == Mode.COPY) {
            this.reader = new RecursiveBlueprintReader(this);
        }
        this.sendNetworkUpdate();
    }

    public int getComputingProgressScaled(int scale) {
        if (this.reader != null) {
            return (int)(this.reader.getComputingProgressScaled() * (float)scale);
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box completeBox = new Box((TileEntity)this).extendToEncompass(this.box);
        for (LaserData d : this.subLasers) {
            completeBox.extendToEncompass(d.tail);
        }
        return completeBox.getBoundingBox();
    }

    public Packet getPacketSetName() {
        return new PacketCommand((Object)this, "setName", new CommandWriter(){

            public void write(ByteBuf data) {
                NetworkUtils.writeUTF((ByteBuf)data, (String)TileArchitect.this.name);
            }
        });
    }

    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if ("setName".equals(command)) {
            this.name = NetworkUtils.readUTF((ByteBuf)stream);
            if (side.isServer()) {
                BuildCraftCore.instance.sendToPlayersNear(this.getPacketSetName(), (TileEntity)this);
            }
        } else if (side.isServer() && "setReadConfiguration".equals(command)) {
            this.readConfiguration.readData(stream);
            this.sendNetworkUpdate();
        }
    }

    public void rpcSetConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "setReadConfiguration", new CommandWriter(){

            public void write(ByteBuf data) {
                TileArchitect.this.readConfiguration.writeData(data);
            }
        }));
    }

    public void addSubBlueprint(TileEntity sub) {
        if (this.mode == Mode.COPY) {
            this.addSubBlueprint(new BlockIndex(sub));
            this.sendNetworkUpdate();
        }
    }

    private void addSubBlueprint(BlockIndex index) {
        this.subBlueprints.add(index);
        LaserData laser = new LaserData(new Position(index), new Position((TileEntity)this));
        laser.head.x += 0.5;
        laser.head.y += 0.5;
        laser.head.z += 0.5;
        laser.tail.x += 0.5;
        laser.tail.y += 0.5;
        laser.tail.z += 0.5;
        this.subLasers.add(laser);
    }

    public int getLEDLevel(int led) {
        boolean condition = false;
        switch (led) {
            case 0: {
                condition = this.clientIsWorking;
                break;
            }
            case 1: {
                condition = this.mode == Mode.COPY && this.box != null && this.box.isInitialized();
                break;
            }
            case 2: {
                condition = this.mode == Mode.EDIT;
            }
        }
        return condition ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    public static enum Mode {
        NONE,
        EDIT,
        COPY;

    }
}

