/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.api.library.LibraryAPI;
import buildcraft.api.library.LibraryTypeHandler;
import buildcraft.api.library.LibraryTypeHandlerByteArray;
import buildcraft.api.library.LibraryTypeHandlerNBT;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class TileBlueprintLibrary
extends TileBuildCraft
implements IInventory,
ICommandReceiver {
    private static final int PROGRESS_TIME = 100;
    private static final int CHUNK_SIZE = 16384;
    public SimpleInventory inv = new SimpleInventory(4, "Electronic Library", 1);
    public int progressIn = 0;
    public int progressOut = 0;
    public List<LibraryId> entries;
    public int selected = -1;
    public EntityPlayer uploadingPlayer = null;
    public EntityPlayer downloadingPlayer = null;
    private LibraryId blueprintDownloadId;
    private byte[] blueprintDownload;

    public void refresh() {
        if (this.field_145850_b.field_72995_K) {
            BuildCraftBuilders.clientDB.refresh();
            this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
            this.selected = -1;
        }
    }

    public void initialize() {
        super.initialize();
        this.refresh();
    }

    public void deleteSelectedBpt() {
        if (this.selected != -1) {
            BuildCraftBuilders.clientDB.deleteBlueprint(this.entries.get(this.selected));
            this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
            if (this.selected >= this.entries.size()) {
                --this.selected;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0 && this.func_70301_a(0) == null) {
            this.progressIn = 0;
        }
        if (i == 2 && this.func_70301_a(2) == null) {
            this.progressOut = 0;
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.progressIn = this.func_70301_a(0) != null && this.findHandler(0, LibraryTypeHandler.HandlerType.STORE) != null ? 1 : 0;
        }
        if (i == 2) {
            this.progressOut = this.func_70301_a(2) != null && this.findHandler(2, LibraryTypeHandler.HandlerType.LOAD) != null ? 1 : 0;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private LibraryTypeHandler findHandler(int slot, LibraryTypeHandler.HandlerType type) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = this.func_70301_a(slot);
            for (LibraryTypeHandler h : LibraryAPI.getHandlerSet()) {
                if (!h.isHandler(stack, type)) continue;
                return h;
            }
        }
        return null;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.progressIn > 0 && this.progressIn < 100) {
            ++this.progressIn;
        }
        if (this.progressOut > 0 && this.progressOut < 100) {
            this.progressOut = this.selected != -1 ? ++this.progressOut : 1;
        }
        if (this.progressIn == 100 && this.func_70301_a(1) == null) {
            LibraryTypeHandler handler = this.findHandler(0, LibraryTypeHandler.HandlerType.STORE);
            if (handler == null) {
                this.uploadingPlayer = null;
                return;
            }
            byte[] data = null;
            if (handler instanceof LibraryTypeHandlerNBT) {
                NBTTagCompound nbt = new NBTTagCompound();
                if (((LibraryTypeHandlerNBT)handler).store(this.func_70301_a(0), nbt)) {
                    data = NBTUtils.save((NBTTagCompound)nbt);
                }
            } else if (handler instanceof LibraryTypeHandlerByteArray) {
                data = ((LibraryTypeHandlerByteArray)handler).store(this.func_70301_a(0));
            }
            if (data == null) {
                this.uploadingPlayer = null;
                return;
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
            final byte[] dataOut = data;
            final LibraryId id = new LibraryId();
            id.name = handler.getName(this.func_70301_a(1));
            id.extension = handler.getOutputExtension();
            if (this.uploadingPlayer != null) {
                BuildCraftCore.instance.sendToPlayer(this.uploadingPlayer, (Packet)new PacketCommand((Object)this, "downloadBlueprintToClient", new CommandWriter(){

                    public void write(ByteBuf data) {
                        id.generateUniqueId(dataOut);
                        id.writeData(data);
                        NetworkUtils.writeByteArray((ByteBuf)data, (byte[])dataOut);
                    }
                }));
                this.uploadingPlayer = null;
            }
        }
        if (this.progressOut == 100 && this.func_70301_a(3) == null) {
            BuildCraftCore.instance.sendToPlayer(this.downloadingPlayer, (Packet)new PacketCommand((Object)this, "requestSelectedBlueprint", null));
            this.progressOut = 0;
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("requestSelectedBlueprint".equals(command)) {
                if (this.isOutputConsistent()) {
                    if (this.selected > -1 && this.selected < this.entries.size()) {
                        NBTTagCompound compound = BuildCraftBuilders.clientDB.load(this.entries.get(this.selected));
                        compound.func_74778_a("__filename", this.entries.get((int)this.selected).name);
                        final byte[] bptData = NBTUtils.save((NBTTagCompound)compound);
                        final int chunks = (bptData.length + 16384 - 1) / 16384;
                        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "uploadServerBegin", new CommandWriter(){

                            public void write(ByteBuf data) {
                                TileBlueprintLibrary.this.entries.get(TileBlueprintLibrary.this.selected).writeData(data);
                                data.writeShort(chunks);
                            }
                        }));
                        int i = 0;
                        while (i < chunks) {
                            final int chunk = i++;
                            final int start = 16384 * chunk;
                            final int length = Math.min(16384, bptData.length - start);
                            BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "uploadServerChunk", new CommandWriter(){

                                public void write(ByteBuf data) {
                                    data.writeShort(chunk);
                                    data.writeShort(length);
                                    data.writeBytes(bptData, start, length);
                                }
                            }));
                        }
                        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "uploadServerEnd", null));
                    } else {
                        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "uploadNothingToServer", null));
                    }
                }
            } else if ("downloadBlueprintToClient".equals(command)) {
                LibraryId id = new LibraryId();
                id.readData(stream);
                byte[] data = NetworkUtils.readByteArray((ByteBuf)stream);
                try {
                    LibraryTypeHandler handler = LibraryAPI.getHandlerFor((String)id.extension);
                    if (handler == null) {
                        return;
                    }
                    NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    BuildCraftBuilders.clientDB.add(id, nbt);
                    this.entries = BuildCraftBuilders.clientDB.getBlueprintIds();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (side.isServer()) {
            if ("uploadNothingToServer".equals(command)) {
                this.func_70299_a(3, this.func_70301_a(2));
                this.func_70299_a(2, null);
                this.downloadingPlayer = null;
            } else if ("uploadServerBegin".equals(command)) {
                this.blueprintDownloadId = new LibraryId();
                this.blueprintDownloadId.readData(stream);
                this.blueprintDownload = new byte[16384 * stream.readUnsignedShort()];
            } else if ("uploadServerChunk".equals(command)) {
                int start = stream.readUnsignedShort() * 16384;
                int length = stream.readUnsignedShort();
                if (this.blueprintDownload != null) {
                    stream.readBytes(this.blueprintDownload, start, length);
                } else {
                    stream.skipBytes(length);
                }
            } else if ("uploadServerEnd".equals(command)) {
                try {
                    LibraryTypeHandler handler = LibraryAPI.getHandlerFor((String)this.blueprintDownloadId.extension);
                    if (handler != null) {
                        ItemStack output = null;
                        if (handler instanceof LibraryTypeHandlerNBT) {
                            NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])this.blueprintDownload, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                            output = ((LibraryTypeHandlerNBT)handler).load(this.func_70301_a(2), nbt);
                        } else if (handler instanceof LibraryTypeHandlerByteArray) {
                            output = ((LibraryTypeHandlerByteArray)handler).load(this.func_70301_a(2), this.blueprintDownload);
                        }
                        if (output != null) {
                            this.func_70299_a(3, output);
                            this.func_70299_a(2, null);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.blueprintDownloadId = null;
                this.blueprintDownload = null;
                this.downloadingPlayer = null;
            } else if ("selectBlueprint".equals(command)) {
                this.selected = stream.readInt();
            }
        }
    }

    public void selectBlueprint(int index) {
        this.selected = index;
        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "selectBlueprint", new CommandWriter(){

            public void write(ByteBuf data) {
                data.writeInt(TileBlueprintLibrary.this.selected);
            }
        }));
    }

    private boolean isOutputConsistent() {
        if (this.selected <= -1 || this.selected >= this.entries.size() || this.func_70301_a(2) == null) {
            return false;
        }
        return LibraryAPI.getHandlerFor((String)this.entries.get((int)this.selected).extension).isHandler(this.func_70301_a(2), LibraryTypeHandler.HandlerType.LOAD);
    }
}

