/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.TileFiller;
import buildcraft.builders.gui.ContainerFiller;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.GuiTools;
import buildcraft.core.lib.gui.StatementParameterSlot;
import buildcraft.core.lib.gui.StatementSlot;
import buildcraft.core.lib.gui.buttons.ButtonTextureSet;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.IButtonTextureSet;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GuiFiller
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/filler.png");
    private static final IButtonTextureSet EXCAVATE_OFF = new ButtonTextureSet(240, -16, 16, 16, TEXTURE);
    private static final IButtonTextureSet EXCAVATE_ON = new ButtonTextureSet(224, -16, 16, 16, TEXTURE);
    private final TileFiller filler;
    private final GuiFiller instance;
    private final StatementSlot fakeStatementSlot;

    public GuiFiller(IInventory playerInventory, TileFiller filler) {
        super((BuildCraftContainer)new ContainerFiller(playerInventory, filler), (IInventory)filler, TEXTURE);
        this.filler = filler;
        this.instance = this;
        this.fakeStatementSlot = new StatementSlot(this.instance, -1, -1, 0){

            public IStatement getStatement() {
                return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.currentPattern;
            }
        };
        this.field_146999_f = 175;
        this.field_147000_g = 240;
    }

    private IButtonTextureSet getExcavateTexture() {
        return this.filler.isExcavate() ? EXCAVATE_ON : EXCAVATE_OFF;
    }

    private GuiBetterButton getExcavateButton() {
        return new GuiBetterButton(2, this.field_147003_i + 150, this.field_147009_r + 30, 16, this.getExcavateTexture(), "").setToolTip(new ToolTip(500, new ToolTipLine[]{new ToolTipLine(StatCollector.func_74838_a((String)("tip.filler.excavate." + (this.filler.isExcavate() ? "on" : "off"))))}));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiBetterButton(0, this.field_147003_i + 38 - 18, this.field_147009_r + 30, 10, (IButtonTextureSet)StandardButtonTextureSets.LEFT_BUTTON, ""));
        this.field_146292_n.add(new GuiBetterButton(1, this.field_147003_i + 38 + 16 + 8, this.field_147009_r + 30, 10, (IButtonTextureSet)StandardButtonTextureSets.RIGHT_BUTTON, ""));
        this.field_146292_n.add(this.getExcavateButton());
        this.slots.clear();
        for (int i = 0; i < 4; ++i) {
            this.slots.add(new FillerParameterSlot(77 + i * 18, 30, i));
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getPreviousPattern((IFillerPattern)this.filler.currentPattern);
        } else if (button.field_146127_k == 1) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getNextPattern((IFillerPattern)this.filler.currentPattern);
        } else if (button.field_146127_k == 2) {
            this.filler.setExcavate(!this.filler.isExcavate());
            this.field_146292_n.set(2, this.getExcavateButton());
            BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this.filler, "setFlags", new CommandWriter(){

                public void write(ByteBuf data) {
                    data.writeBoolean(GuiFiller.this.filler.isExcavate());
                }
            }));
        }
        this.filler.rpcSetPatternFromString(this.filler.currentPattern.getUniqueTag());
    }

    protected void func_73864_a(int x, int y, int k) {
        int i;
        super.func_73864_a(x, y, k);
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        if (slot != null && (i = ((FillerParameterSlot)slot).slot) < this.filler.patternParameters.length) {
            if (this.filler.patternParameters[i] != null) {
                this.filler.patternParameters[i].onClick((IStatementContainer)this.filler, (IStatement)this.filler.currentPattern, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), new StatementMouseClick(k, GuiFiller.func_146272_n()));
            } else {
                this.filler.patternParameters[i] = this.filler.currentPattern.createParameter(i);
            }
            this.filler.rpcSetParameter(i, this.filler.patternParameters[i]);
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        super.func_146976_a(f, mx, my);
        this.drawBackgroundSlots(mx, my);
    }

    protected void func_146979_b(int mx, int my) {
        super.func_146979_b(mx, my);
        String title = StringUtils.localize((String)"tile.fillerBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.filling.resources"), 8, 74, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.inventory"), 8, 142, 0x404040);
        GuiTools.drawCenteredString((FontRenderer)this.field_146289_q, (String)this.filler.currentPattern.getDescription(), (int)56);
        this.drawTooltipForSlotAt(mx, my);
    }

    class FillerParameterSlot
    extends StatementParameterSlot {
        public FillerParameterSlot(int x, int y, int slot) {
            super((GuiAdvancedInterface)GuiFiller.this.instance, x, y, slot, GuiFiller.this.fakeStatementSlot);
        }

        public IStatementParameter getParameter() {
            if (((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters == null || this.slot >= ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters.length) {
                return null;
            }
            return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters[this.slot];
        }

        public void setParameter(IStatementParameter param, boolean notifyServer) {
        }
    }
}

