/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.arithmetics;

import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import org.apache.commons.lang3.math.Fraction;

public class FullFractionArithmetic
implements IValueArithmetic<Fraction> {
    @Override
    public boolean isZero(Fraction value) {
        return value.getNumerator() == 0;
    }

    @Override
    public Fraction getZero() {
        return Fraction.ZERO;
    }

    @Override
    public Fraction add(Fraction a, Fraction b) {
        if (this.isFree(a)) {
            return b;
        }
        if (this.isFree(b)) {
            return a;
        }
        return a.add(b);
    }

    @Override
    public Fraction mul(int a, Fraction b) {
        if (this.isFree(b)) {
            return this.getFree();
        }
        return b.multiplyBy(Fraction.getFraction((int)a, (int)1));
    }

    @Override
    public Fraction div(Fraction a, int b) {
        try {
            if (this.isFree(a)) {
                return this.getFree();
            }
            Fraction result = a.divideBy(Fraction.getFraction((int)b, (int)1));
            return result;
        }
        catch (ArithmeticException e) {
            return Fraction.ZERO;
        }
    }

    @Override
    public Fraction getFree() {
        return Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
    }

    @Override
    public boolean isFree(Fraction value) {
        return value.getNumerator() == Integer.MIN_VALUE;
    }
}

