/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.handlers.PlayerTimers;
import moze_intel.projecte.utils.ChatHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.EnumArmorType;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.items.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IGoggles", modid="Thaumcraft")})
public class GemHelmet
extends GemArmorBase
implements IGoggles,
IRevealer {
    public GemHelmet() {
        super(EnumArmorType.HEAD);
    }

    public static boolean isNightVisionEnabled(ItemStack helm) {
        return helm.func_77942_o() && helm.func_77978_p().func_74764_b("NightVision") && helm.func_77978_p().func_74767_n("NightVision");
    }

    public static void toggleNightVision(ItemStack helm, EntityPlayer player) {
        boolean value;
        if (!helm.func_77942_o()) {
            helm.func_77982_d(new NBTTagCompound());
        }
        if (helm.func_77978_p().func_74764_b("NightVision")) {
            helm.func_77978_p().func_74757_a("NightVision", !helm.func_77978_p().func_74767_n("NightVision"));
            value = helm.func_77978_p().func_74767_n("NightVision");
        } else {
            helm.func_77978_p().func_74757_a("NightVision", false);
            value = false;
        }
        EnumChatFormatting e = value ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String s = value ? "pe.gem.enabled" : "pe.gem.disabled";
        player.func_145747_a(new ChatComponentTranslation("pe.gem.nightvision_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(ChatHelper.modifyColor((IChatComponent)new ChatComponentTranslation(s, new Object[0]), e)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltips, boolean unused) {
        tooltips.add(StatCollector.func_74838_a((String)"pe.gem.helm.lorename"));
        tooltips.add(String.format(StatCollector.func_74838_a((String)"pe.gem.nightvision.prompt"), ClientKeyHelper.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74311_E), ClientKeyHelper.getKeyName(PEKeybind.ARMOR_TOGGLE)));
        EnumChatFormatting e = GemHelmet.isNightVisionEnabled(stack) ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String s = GemHelmet.isNightVisionEnabled(stack) ? "pe.gem.enabled" : "pe.gem.disabled";
        tooltips.add(StatCollector.func_74838_a((String)"pe.gem.nightvision_tooltip") + " " + e + StatCollector.func_74838_a((String)s));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (world.field_72995_K) {
            int z;
            int y;
            int x = (int)Math.floor(player.field_70165_t);
            BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
            Block b = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if ((b == Blocks.field_150355_j || b == Blocks.field_150358_i) && world.func_175623_d(pos) && !player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
        } else {
            PlayerTimers.activateHeal(player);
            if (player.func_110143_aJ() < player.func_110138_aP() && PlayerTimers.canHeal(player)) {
                player.func_70691_i(2.0f);
            }
            if (GemHelmet.isNightVisionEnabled(stack)) {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 220, 0));
            } else {
                player.func_82170_o(Potion.field_76439_r.field_76415_H);
            }
            if (player.func_70090_H()) {
                player.func_70050_g(300);
            }
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void doZap(EntityPlayer player) {
        BlockPos strikePos;
        if (ProjectEConfig.offensiveAbilities && (strikePos = PlayerHelper.getBlockLookingAt(player, 120.0)) != null) {
            player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, (double)strikePos.func_177958_n(), (double)strikePos.func_177956_o(), (double)strikePos.func_177952_p()));
        }
    }
}

