/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import io.netty.buffer.ByteBuf;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CollectorSyncPKT
implements IMessage {
    private int displayEmc;
    private double displayKleinCharge;
    private BlockPos pos;

    public CollectorSyncPKT() {
    }

    public CollectorSyncPKT(int displayEmc, double displayKleinCharge, CollectorMK1Tile tile) {
        this.displayEmc = displayEmc;
        this.displayKleinCharge = displayKleinCharge;
        this.pos = tile.func_174877_v();
    }

    public void fromBytes(ByteBuf buf) {
        this.displayEmc = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.displayKleinCharge = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.displayEmc);
        buf.writeLong(this.pos.func_177986_g());
        buf.writeDouble(this.displayKleinCharge);
    }

    public static class Handler
    implements IMessageHandler<CollectorSyncPKT, IMessage> {
        public IMessage onMessage(final CollectorSyncPKT pkt, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pkt.pos);
                    if (tile == null) {
                        PELogger.logFatal("NULL tile entity reference in Collector sync packet! Please report to dev!");
                    } else {
                        CollectorMK1Tile collector = (CollectorMK1Tile)tile;
                        collector.displayEmc = pkt.displayEmc;
                        collector.displayItemCharge = pkt.displayKleinCharge;
                    }
                }
            });
            return null;
        }
    }
}

