/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.utils.ReflectionHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class NovaExplosion
extends Explosion {
    private World worldObj;

    public NovaExplosion(World world, Entity entity, double x, double y, double z, float radius, boolean isFlaming, boolean isSmoking) {
        super(world, entity, x, y, z, radius, isFlaming, isSmoking);
        this.worldObj = world;
    }

    public void func_77278_a() {
        float initialSize = ReflectionHelper.getExplosionSize(this);
        HashSet hashset = Sets.newHashSet();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.getPosition().field_72450_a;
                    double d6 = this.getPosition().field_72448_b;
                    double d8 = this.getPosition().field_72449_c;
                    float f1 = 0.3f;
                    for (float f = initialSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
                        if (iblockstate.func_177230_c().func_149688_o() != Material.field_151579_a) {
                            float f2 = this.func_94613_c() != null ? this.func_94613_c().func_180428_a((Explosion)this, this.worldObj, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.worldObj, blockpos, null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.func_94613_c() == null || this.func_94613_c().func_174816_a((Explosion)this, this.worldObj, blockpos, iblockstate, f))) {
                            hashset.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(hashset);
        ReflectionHelper.setExplosionSize(this, initialSize);
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, Collections.emptyList(), (double)ReflectionHelper.getExplosionSize(this));
    }

    public void func_77279_a(boolean spawnParticles) {
        float cachedExplosionSize = ReflectionHelper.getExplosionSize(this);
        double x = this.getPosition().field_72450_a;
        double y = this.getPosition().field_72448_b;
        double z = this.getPosition().field_72449_c;
        this.worldObj.func_72908_a(x, y, z, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (cachedExplosionSize >= 2.0f) {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        }
        ArrayList allDrops = Lists.newArrayList();
        for (BlockPos blockpos : this.func_180343_e()) {
            Block block = this.worldObj.func_180495_p(blockpos).func_177230_c();
            if (spawnParticles) {
                double d0 = (float)blockpos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
                double d1 = (float)blockpos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
                double d2 = (float)blockpos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
                double d3 = d0 - x;
                double d4 = d1 - y;
                double d5 = d2 - z;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)cachedExplosionSize + 0.1);
                this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + x * 1.0) / 2.0, (d1 + y * 1.0) / 2.0, (d2 + z * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
            if (block.func_149688_o() == Material.field_151579_a) continue;
            List drops = block.getDrops((IBlockAccess)this.worldObj, blockpos, this.worldObj.func_180495_p(blockpos), 0);
            if (drops.size() > 0) {
                allDrops.addAll(drops);
            }
            block.onBlockExploded(this.worldObj, blockpos, (Explosion)this);
        }
        if (this.func_94613_c() != null) {
            WorldHelper.createLootDrop(allDrops, this.worldObj, new BlockPos((Entity)this.func_94613_c()));
        } else {
            WorldHelper.createLootDrop(allDrops, this.worldObj, x, y, z);
        }
    }
}

