/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import buildcraft.core.lib.utils.BlockUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTank
extends TileBuildCraft
implements IFluidHandler {
    public final Tank tank = new Tank("tank", 16000, (TileEntity)this);
    public final TankManager<Tank> tankManager = new TankManager(new Tank[]{this.tank});
    public boolean hasUpdate = false;
    public boolean hasNetworkUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker((long)(2 * BuildCraftCore.updateFactor));
    private int prevLightValue = 0;
    private int cachedComparatorOverride = 0;

    public void initialize() {
        super.initialize();
        this.updateComparators();
    }

    protected void updateComparators() {
        int co = this.calculateComparatorInputOverride();
        TileTank uTank = this.getBottomTank();
        while (uTank != null) {
            uTank.cachedComparatorOverride = co;
            uTank.hasUpdate = true;
            uTank = TileTank.getTankAbove(uTank);
        }
    }

    protected void onBlockBreak() {
        if (!this.tank.isEmpty()) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.tank.getFluid(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            int lightValue = this.getFluidLightLevel();
            if (this.prevLightValue != lightValue) {
                this.prevLightValue = lightValue;
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return;
        }
        if (this.tank.getFluid() != null) {
            this.moveFluidBelow();
        }
        if (this.hasUpdate) {
            BlockUtils.onComparatorUpdate((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)this.func_145838_q());
            this.hasUpdate = false;
        }
        if (this.hasNetworkUpdate && this.tracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
            this.hasNetworkUpdate = false;
        }
    }

    public void writeData(ByteBuf data) {
        this.tankManager.writeData(data);
    }

    public void readData(ByteBuf stream) {
        this.tankManager.readData(stream);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
    }

    public TileTank getBottomTank() {
        TileTank below;
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileTank getTopTank() {
        TileTank above;
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileTank tile) {
        TileEntity below = tile.getTile(ForgeDirection.DOWN);
        if (below instanceof TileTank) {
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileTank tile) {
        TileEntity above = tile.getTile(ForgeDirection.UP);
        if (above instanceof TileTank) {
            return (TileTank)above;
        }
        return null;
    }

    public void moveFluidBelow() {
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int oldComparator = this.getComparatorInputOverride();
        int used = below.tank.fill(this.tank.getFluid(), true);
        if (used > 0) {
            this.hasNetworkUpdate = true;
            below.hasNetworkUpdate = true;
            if (oldComparator != this.calculateComparatorInputOverride()) {
                this.updateComparators();
            }
            this.tank.drain(used, true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack resourceCopy = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        FluidStack liquid = tankToFill.tank.getFluid();
        if (liquid != null && liquid.amount > 0 && !liquid.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int oldComparator = this.getComparatorInputOverride();
        while (tankToFill != null && resourceCopy.amount > 0) {
            int used = tankToFill.tank.fill(resourceCopy, doFill);
            resourceCopy.amount -= used;
            if (used > 0) {
                tankToFill.hasNetworkUpdate = true;
            }
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        if (oldComparator != this.calculateComparatorInputOverride()) {
            this.updateComparators();
        }
        return totalUsed;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        TileTank bottom = this.getBottomTank();
        bottom.hasNetworkUpdate = true;
        int oldComparator = this.getComparatorInputOverride();
        FluidStack output = bottom.tank.drain(maxEmpty, doDrain);
        if (oldComparator != this.calculateComparatorInputOverride()) {
            this.updateComparators();
        }
        return output;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        TileTank bottom = this.getBottomTank();
        if (!resource.isFluidEqual(bottom.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTank compositeTank = new FluidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        if (tile == null || tile.tank.getFluid() == null) {
            return new FluidTankInfo[]{compositeTank.getInfo()};
        }
        compositeTank.setFluid(tile.tank.getFluid().copy());
        int capacity = tile.tank.getCapacity();
        tile = TileTank.getTankAbove(tile);
        while (tile != null) {
            FluidStack liquid = tile.tank.getFluid();
            if (liquid != null && liquid.amount != 0) {
                if (!compositeTank.getFluid().isFluidEqual(liquid)) break;
                compositeTank.getFluid().amount += liquid.amount;
            }
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        Fluid tankFluid = this.getBottomTank().tank.getFluidType();
        return tankFluid == null || tankFluid == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        Fluid tankFluid = this.getBottomTank().tank.getFluidType();
        return tankFluid != null && tankFluid == fluid;
    }

    public int getFluidLightLevel() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null || tankFluid.amount == 0 ? 0 : tankFluid.getFluid().getLuminosity(tankFluid);
    }

    public int calculateComparatorInputOverride() {
        FluidTankInfo[] info = this.getTankInfo(ForgeDirection.UNKNOWN);
        if (info.length > 0 && info[0] != null && info[0].fluid != null) {
            return info[0].fluid.amount * 15 / info[0].capacity;
        }
        return 0;
    }

    public int getComparatorInputOverride() {
        return this.cachedComparatorOverride;
    }
}

