/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.fuels;

import buildcraft.api.core.StackKey;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.ICoolantManager;
import buildcraft.api.fuels.ISolidCoolant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class CoolantManager
implements ICoolantManager {
    public static final CoolantManager INSTANCE = new CoolantManager();
    private final List<ICoolant> coolants = new LinkedList<ICoolant>();
    private final List<ISolidCoolant> solidCoolants = new LinkedList<ISolidCoolant>();

    private CoolantManager() {
    }

    public ICoolant addCoolant(ICoolant coolant) {
        this.coolants.add(coolant);
        return coolant;
    }

    public ICoolant addCoolant(Fluid fluid, float degreesCoolingPerMB) {
        return this.addCoolant(new BCCoolant(fluid, degreesCoolingPerMB));
    }

    public ISolidCoolant addSolidCoolant(ISolidCoolant solidCoolant) {
        this.solidCoolants.add(solidCoolant);
        return solidCoolant;
    }

    public ISolidCoolant addSolidCoolant(StackKey solid, StackKey liquid, float multiplier) {
        assert (solid.stack != null && solid.fluidStack == null);
        assert (liquid.stack == null && liquid.fluidStack != null);
        return this.addSolidCoolant(new BCSolidCoolant(solid, liquid, multiplier));
    }

    public Collection<ICoolant> getCoolants() {
        return this.coolants;
    }

    public Collection<ISolidCoolant> getSolidCoolants() {
        return this.solidCoolants;
    }

    public ICoolant getCoolant(Fluid fluid) {
        for (ICoolant coolant : this.coolants) {
            if (coolant.getFluid() != fluid) continue;
            return coolant;
        }
        return null;
    }

    public ISolidCoolant getSolidCoolant(StackKey solid) {
        assert (solid.stack != null && solid.fluidStack == null);
        for (ISolidCoolant solidCoolant : this.solidCoolants) {
            if (solidCoolant.getFluidFromSolidCoolant(solid.stack) == null) continue;
            return solidCoolant;
        }
        return null;
    }

    private static final class BCSolidCoolant
    implements ISolidCoolant {
        private final StackKey solid;
        private final StackKey liquid;
        private final float multiplier;

        public BCSolidCoolant(StackKey solid, StackKey liquid, float multiplier) {
            this.solid = solid;
            this.liquid = liquid;
            this.multiplier = multiplier;
        }

        public FluidStack getFluidFromSolidCoolant(ItemStack stack) {
            if (stack == null || !stack.func_77969_a(this.solid.stack)) {
                return null;
            }
            int liquidAmount = (int)((float)(stack.field_77994_a * this.liquid.fluidStack.amount) * this.multiplier / (float)this.solid.stack.field_77994_a);
            return new FluidStack(this.liquid.fluidStack.getFluid(), liquidAmount);
        }
    }

    private static final class BCCoolant
    implements ICoolant {
        private final Fluid fluid;
        private final float degreesCoolingPerMB;

        public BCCoolant(Fluid fluid, float degreesCoolingPerMB) {
            this.fluid = fluid;
            this.degreesCoolingPerMB = degreesCoolingPerMB;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public float getDegreesCoolingPerMB(float heat) {
            return this.degreesCoolingPerMB;
        }
    }
}

