/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.energy.TileEngineIron;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerCoolantBelowThreshold
extends BCStatement
implements ITriggerExternal {
    private float threshold;

    public TriggerCoolantBelowThreshold(float threshold) {
        super(new String[]{"buildcraft:trigger.coolantLevelBelow." + (int)(threshold * 100.0f)});
        this.setBuildCraftLocation("energy", "triggers/trigger_coolant_below_threshold");
        this.threshold = threshold;
    }

    public String getDescription() {
        return String.format(BCStringUtils.localize((String)"gate.trigger.coolantLevelBelow"), (int)(this.threshold * 100.0f));
    }

    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(target instanceof TileEngineIron)) {
            return false;
        }
        return ((TileEngineIron)target).hasCoolantBelowThreshold(this.threshold);
    }
}

