/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.BlockStateLoader;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;

public class ForgeBlockStateV1
extends BlockStateLoader.Marker {
    Variant defaults;
    Multimap<String, Variant> variants = HashMultimap.create();

    public static class TRSRDeserializer
    implements JsonDeserializer<TRSRTransformation> {
        public static TRSRDeserializer INSTANCE = new TRSRDeserializer();

        public TRSRTransformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return TRSRTransformation.identity();
                }
                throw new JsonParseException("TRSR: unknown default string: " + transform);
            }
            if (json.isJsonArray()) {
                return new TRSRTransformation(TRSRDeserializer.parseMatrix(json));
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("TRSR: expected array or object, got: " + json);
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("matrix")) {
                TRSRTransformation ret = new TRSRTransformation(TRSRDeserializer.parseMatrix(obj.get("matrix")));
                obj.remove("matrix");
                if (obj.entrySet().size() != 0) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            Vector3f translation = null;
            Quat4f leftRot = null;
            Vector3f scale = null;
            Quat4f rightRot = null;
            if (obj.has("translation")) {
                translation = new Vector3f(TRSRDeserializer.parseFloatArray(obj.get("translation"), 3, "Translation"));
                obj.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = TRSRDeserializer.parseRotation(obj.get("rotation"));
                obj.remove("rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new Vector3f(s, s, s);
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + obj.get("scale"));
                    }
                } else {
                    scale = new Vector3f(TRSRDeserializer.parseFloatArray(obj.get("scale"), 3, "Scale"));
                }
                obj.remove("scale");
            }
            if (obj.has("post-rotation")) {
                rightRot = TRSRDeserializer.parseRotation(obj.get("post-rotation"));
                obj.remove("post-rotation");
            }
            if (!obj.entrySet().isEmpty()) {
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation', 'scale', 'post-rotation'");
            }
            return new TRSRTransformation(translation, leftRot, scale, rightRot);
        }

        public static Matrix4f parseMatrix(JsonElement e) {
            if (!e.isJsonArray()) {
                throw new JsonParseException("Matrix: expected an array, got: " + e);
            }
            JsonArray m2 = e.getAsJsonArray();
            if (m2.size() != 3) {
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m2.size());
            }
            Matrix4f ret = new Matrix4f();
            for (int i = 0; i < 3; ++i) {
                if (!m2.get(i).isJsonArray()) {
                    throw new JsonParseException("Matrix row: expected an array, got: " + m2.get(i));
                }
                JsonArray r = m2.get(i).getAsJsonArray();
                if (r.size() != 4) {
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                }
                for (int j2 = 0; j2 < 4; ++j2) {
                    try {
                        ret.setElement(i, j2, r.get(j2).getAsNumber().floatValue());
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + r.get(j2));
                    }
                }
            }
            return ret;
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray()) {
                throw new JsonParseException(prefix + ": expected an array, got: " + e);
            }
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length) {
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            }
            float[] ret = new float[length];
            for (int i = 0; i < length; ++i) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + t.get(i));
                }
            }
            return ret;
        }

        public static Quat4f parseAxisRotation(JsonElement e) {
            Quat4f ret;
            block7: {
                if (!e.isJsonObject()) {
                    throw new JsonParseException("Axis rotation: object expected, got: " + e);
                }
                JsonObject obj = e.getAsJsonObject();
                if (obj.entrySet().size() != 1) {
                    throw new JsonParseException("Axis rotation: expected single axis object, got: " + e);
                }
                Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
                ret = new Quat4f();
                try {
                    if (((String)entry.getKey()).equals("x")) {
                        ret.set(new AxisAngle4d(1.0, 0.0, 0.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("y")) {
                        ret.set(new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("z")) {
                        ret.set(new AxisAngle4d(0.0, 0.0, 1.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    throw new JsonParseException("Axis rotation: expected single axis key, got: " + (String)entry.getKey());
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException("Axis rotation value: expected number, got: " + entry.getValue());
                }
            }
            return ret;
        }

        public static Quat4f parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
                    for (JsonElement a2 : e.getAsJsonArray()) {
                        ret.mul(TRSRDeserializer.parseAxisRotation(a2));
                    }
                    return ret;
                }
                return new Quat4f(TRSRDeserializer.parseFloatArray(e, 4, "Rotation"));
            }
            if (e.isJsonObject()) {
                return TRSRDeserializer.parseAxisRotation(e);
            }
            throw new JsonParseException("Rotation: expected array or object, got: " + e);
        }
    }

    public static class Variant {
        public static final Object SET_VALUE = new Object();
        private jy model = null;
        private boolean modelSet = false;
        private Optional<IModelState> state = Optional.absent();
        private Optional<Boolean> uvLock = Optional.absent();
        private Optional<Boolean> smooth = Optional.absent();
        private Optional<Boolean> gui3d = Optional.absent();
        private Optional<Integer> weight = Optional.absent();
        private Map<String, String> textures = Maps.newHashMap();
        private Map<String, List<Variant>> submodels = Maps.newHashMap();
        private Map<String, Object> simpleSubmodels = Maps.newHashMap();
        private Map<String, String> customData = Maps.newHashMap();

        private Variant() {
        }

        private Variant(Variant other) {
            this.model = other.model;
            this.modelSet = other.modelSet;
            this.state = other.state;
            this.uvLock = other.uvLock;
            this.smooth = other.smooth;
            this.gui3d = other.gui3d;
            this.weight = other.weight;
            this.textures.putAll(other.textures);
            this.mergeModelPartVariants(this.submodels, other.submodels);
            this.simpleSubmodels.putAll(other.simpleSubmodels);
            this.customData.putAll(other.customData);
        }

        Variant sync(Variant parent) {
            if (!this.modelSet) {
                this.model = parent.model;
                this.modelSet = parent.modelSet;
            }
            if (!this.state.isPresent()) {
                this.state = parent.state;
            }
            if (!this.uvLock.isPresent()) {
                this.uvLock = parent.uvLock;
            }
            if (!this.smooth.isPresent()) {
                this.smooth = parent.smooth;
            }
            if (!this.gui3d.isPresent()) {
                this.gui3d = parent.gui3d;
            }
            if (!this.weight.isPresent()) {
                this.weight = parent.weight;
            }
            for (Map.Entry<String, String> entry : parent.textures.entrySet()) {
                if (this.textures.containsKey(entry.getKey())) continue;
                this.textures.put(entry.getKey(), entry.getValue());
            }
            this.mergeModelPartVariants(this.submodels, parent.submodels);
            for (Map.Entry<String, Object> entry : parent.simpleSubmodels.entrySet()) {
                if (this.simpleSubmodels.containsKey(entry.getKey())) continue;
                this.simpleSubmodels.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : parent.customData.entrySet()) {
                if (this.customData.containsKey(entry.getKey())) continue;
                this.customData.put(entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        Map<String, List<Variant>> mergeModelPartVariants(Map<String, List<Variant>> output, Map<String, List<Variant>> input) {
            for (Map.Entry<String, List<Variant>> e : input.entrySet()) {
                String key = e.getKey();
                if (output.containsKey(key)) continue;
                List<Variant> variants = e.getValue();
                if (variants != null) {
                    ArrayList newVariants = Lists.newArrayListWithCapacity((int)variants.size());
                    for (Variant v : variants) {
                        newVariants.add(new Variant(v));
                    }
                    output.put(key, newVariants);
                    continue;
                }
                output.put(key, variants);
            }
            return output;
        }

        protected BlockStateLoader.SubModel asGenericSubModel() {
            return new BlockStateLoader.SubModel((IModelState)this.state.or((Object)TRSRTransformation.identity()), (Boolean)this.uvLock.or((Object)false), this.getTextures(), this.model, this.getCustomData());
        }

        public ImmutableMap<String, BlockStateLoader.SubModel> getOnlyPartsVariant() {
            if (this.submodels.size() > 0) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, List<Variant>> entry : this.submodels.entrySet()) {
                    List<Variant> part = entry.getValue();
                    if (part == null) continue;
                    if (part.size() == 1) {
                        builder.put((Object)entry.getKey(), (Object)part.get(0).asGenericSubModel());
                        continue;
                    }
                    throw new RuntimeException("Something attempted to get the list of submodels for a variant with model \"" + this.model + "\", when this variant " + "contains multiple variants for submodel " + entry.getKey());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public Optional<Boolean> getSmooth() {
            return this.smooth;
        }

        public Optional<Boolean> getGui3d() {
            return this.gui3d;
        }

        public jy getModel() {
            return this.model;
        }

        public boolean isModelSet() {
            return this.modelSet;
        }

        public Optional<IModelState> getState() {
            return this.state;
        }

        public Optional<Boolean> getUvLock() {
            return this.uvLock;
        }

        public Optional<Integer> getWeight() {
            return this.weight;
        }

        public ImmutableMap<String, String> getTextures() {
            return ImmutableMap.copyOf(this.textures);
        }

        public ImmutableMap<String, List<Variant>> getSubmodels() {
            return ImmutableMap.copyOf(this.submodels);
        }

        public ImmutableMap<String, String> getCustomData() {
            return ImmutableMap.copyOf(this.customData);
        }

        public static class Deserializer
        implements JsonDeserializer<Variant> {
            static Deserializer INSTANCE = new Deserializer();
            public String simpleSubmodelKey = null;

            protected jy getBlockLocation(String location) {
                jy tmp = new jy(location);
                return new jy(tmp.b(), "block/" + tmp.a());
            }

            private void throwIfNestedSubmodels(Variant submodel) {
                if (submodel.submodels.size() > 0) {
                    throw new UnsupportedOperationException("Forge BlockStateLoader V1 does not support nested submodels.");
                }
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Variant deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Variant ret = new Variant();
                JsonObject json = element.getAsJsonObject();
                if (json.has("model")) {
                    if (json.get("model").isJsonNull()) {
                        ret.model = null;
                    } else {
                        ret.model = this.getBlockLocation(ni.h((JsonObject)json, (String)"model"));
                    }
                    ret.modelSet = true;
                }
                if (json.has("textures")) {
                    for (Map.Entry e : json.get("textures").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.textures.put(e.getKey(), "");
                            continue;
                        }
                        ret.textures.put(e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                }
                if (json.has("x") || json.has("y")) {
                    int x = ni.a((JsonObject)json, (String)"x", (int)0);
                    int y = ni.a((JsonObject)json, (String)"y", (int)0);
                    ret.state = Optional.of((Object)new TRSRTransformation(bor.a((int)x, (int)y)));
                    if (!ret.state.isPresent()) {
                        throw new JsonParseException("Invalid BlockModelRotation x: " + x + " y: " + y);
                    }
                }
                if (json.has("transform")) {
                    Object transform;
                    if (json.get("transform").isJsonPrimitive() && json.get("transform").getAsJsonPrimitive().isString()) {
                        TRSRTransformation firstperson;
                        transform = json.get("transform").getAsString();
                        if (((String)transform).equals("identity")) {
                            ret.state = Optional.of((Object)TRSRTransformation.identity());
                        } else if (((String)transform).equals("forge:default-block")) {
                            TRSRTransformation thirdperson = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), TRSRTransformation.quatFromYXZDegrees(new Vector3f(10.0f, -45.0f, 170.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null));
                            ret.state = Optional.of((Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.of((Object)bgr.b.b, (Object)thirdperson)));
                        } else if (((String)transform).equals("forge:default-item")) {
                            TRSRTransformation thirdperson = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(0.0f, 0.0625f, -0.1875f), TRSRTransformation.quatFromYXZDegrees(new Vector3f(-90.0f, 0.0f, 0.0f)), new Vector3f(0.55f, 0.55f, 0.55f), null));
                            firstperson = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.125f), TRSRTransformation.quatFromYXZDegrees(new Vector3f(0.0f, -135.0f, 25.0f)), new Vector3f(1.7f, 1.7f, 1.7f), null));
                            ret.state = Optional.of((Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.of((Object)bgr.b.b, (Object)thirdperson, (Object)bgr.b.c, (Object)firstperson)));
                        } else {
                            if (!((String)transform).equals("forge:default-tool")) throw new JsonParseException("transform: unknown default string: " + (String)transform);
                            TRSRTransformation thirdperson = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(0.0f, 0.078125f, -0.21875f), TRSRTransformation.quatFromYXZDegrees(new Vector3f(0.0f, 90.0f, -35.0f)), new Vector3f(0.85f, 0.85f, 0.85f), null));
                            firstperson = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.125f), TRSRTransformation.quatFromYXZDegrees(new Vector3f(0.0f, -135.0f, 25.0f)), new Vector3f(1.7f, 1.7f, 1.7f), null));
                            ret.state = Optional.of((Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.of((Object)bgr.b.b, (Object)thirdperson, (Object)bgr.b.c, (Object)firstperson)));
                        }
                    } else if (!json.get("transform").isJsonObject()) {
                        try {
                            TRSRTransformation base = (TRSRTransformation)context.deserialize(json.get("transform"), TRSRTransformation.class);
                            ret.state = Optional.of((Object)TRSRTransformation.blockCenterToCorner(base));
                        }
                        catch (JsonParseException e) {
                            throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + json.get("transform"));
                        }
                    } else {
                        void var10_26;
                        TRSRTransformation t;
                        transform = json.get("transform").getAsJsonObject();
                        EnumMap transforms = Maps.newEnumMap(bgr.b.class);
                        if (transform.has("thirdperson")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("thirdperson"), TRSRTransformation.class);
                            transform.remove("thirdperson");
                            transforms.put(bgr.b.b, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("firstperson")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("firstperson"), TRSRTransformation.class);
                            transform.remove("firstperson");
                            transforms.put(bgr.b.c, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("head")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("head"), TRSRTransformation.class);
                            transform.remove("head");
                            transforms.put(bgr.b.d, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("gui")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("gui"), TRSRTransformation.class);
                            transform.remove("gui");
                            transforms.put(bgr.b.e, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("ground")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("ground"), TRSRTransformation.class);
                            transform.remove("ground");
                            transforms.put(bgr.b.f, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("fixed")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("fixed"), TRSRTransformation.class);
                            transform.remove("fixed");
                            transforms.put(bgr.b.g, TRSRTransformation.blockCenterToCorner(t));
                        }
                        int k2 = transform.entrySet().size();
                        if (transform.has("matrix")) {
                            --k2;
                        }
                        if (transform.has("translation")) {
                            --k2;
                        }
                        if (transform.has("rotation")) {
                            --k2;
                        }
                        if (transform.has("scale")) {
                            --k2;
                        }
                        if (transform.has("post-rotation")) {
                            --k2;
                        }
                        if (k2 > 0) {
                            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation'");
                        }
                        TRSRTransformation base = TRSRTransformation.identity();
                        if (!transform.entrySet().isEmpty()) {
                            base = (TRSRTransformation)context.deserialize((JsonElement)transform, TRSRTransformation.class);
                            base = TRSRTransformation.blockCenterToCorner(base);
                        }
                        if (transforms.isEmpty()) {
                            TRSRTransformation tRSRTransformation = base;
                        } else {
                            SimpleModelState simpleModelState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)Maps.immutableEnumMap((Map)transforms), (Optional<TRSRTransformation>)Optional.of((Object)base));
                        }
                        ret.state = Optional.of((Object)var10_26);
                    }
                }
                if (json.has("uvlock")) {
                    ret.uvLock = Optional.of((Object)ni.i((JsonObject)json, (String)"uvlock"));
                }
                if (json.has("smooth_lighting")) {
                    ret.smooth = Optional.of((Object)ni.i((JsonObject)json, (String)"smooth_lighting"));
                }
                if (json.has("gui3d")) {
                    ret.gui3d = Optional.of((Object)ni.i((JsonObject)json, (String)"gui3d"));
                }
                if (json.has("weight")) {
                    ret.weight = Optional.of((Object)ni.m((JsonObject)json, (String)"weight"));
                }
                if (json.has("submodel")) {
                    JsonElement submodels = json.get("submodel");
                    if (submodels.isJsonPrimitive()) {
                        if (this.simpleSubmodelKey == null) {
                            throw new RuntimeException("Attempted to use a simple submodel declaration outside a valid state variant declaration.");
                        }
                        String key = this.simpleSubmodelKey;
                        this.simpleSubmodelKey = null;
                        ret.model = this.getBlockLocation(submodels.getAsString());
                        ret.modelSet = true;
                        Variant dummyVar = new Variant();
                        dummyVar.submodels.put(key, Collections.singletonList(ret));
                        dummyVar.simpleSubmodels = Collections.singletonMap(key, SET_VALUE);
                        return dummyVar;
                    }
                    this.simpleSubmodelKey = null;
                    for (Map.Entry submodel : submodels.getAsJsonObject().entrySet()) {
                        void var10_31;
                        JsonElement varEl = (JsonElement)submodel.getValue();
                        if (varEl.isJsonArray()) {
                            ArrayList arrayList = Lists.newArrayList();
                            for (JsonElement e : varEl.getAsJsonArray()) {
                                arrayList.add((Variant)context.deserialize(e, Variant.class));
                            }
                        } else if (varEl.isJsonNull()) {
                            Object var10_29 = null;
                        } else {
                            List<Variant> list = Collections.singletonList((Variant)context.deserialize(varEl, Variant.class));
                        }
                        if (var10_31 != null) {
                            for (Variant part : var10_31) {
                                this.throwIfNestedSubmodels(part);
                            }
                        }
                        ret.submodels.put(submodel.getKey(), var10_31);
                        ret.simpleSubmodels.put(submodel.getKey(), null);
                    }
                }
                if (json.has("custom")) {
                    for (Map.Entry e : json.get("custom").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.customData.put(e.getKey(), null);
                            continue;
                        }
                        ret.customData.put(e.getKey(), ((JsonElement)e.getValue()).toString());
                    }
                }
                this.simpleSubmodelKey = null;
                return ret;
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<ForgeBlockStateV1> {
        static Deserializer INSTANCE = new Deserializer();

        public ForgeBlockStateV1 deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ForgeBlockStateV1 ret = new ForgeBlockStateV1();
            ret.forge_marker = ni.m((JsonObject)json, (String)"forge_marker");
            if (json.has("defaults")) {
                ret.defaults = (Variant)context.deserialize(json.get("defaults"), Variant.class);
                if (ret.defaults.simpleSubmodels.size() > 0) {
                    throw new RuntimeException("\"defaults\" variant cannot contain a simple \"submodel\" definition.");
                }
            }
            HashMap condensed = Maps.newHashMap();
            HashMultimap specified = HashMultimap.create();
            for (Map.Entry e : ni.s((JsonObject)json, (String)"variants").entrySet()) {
                if (((JsonElement)e.getValue()).isJsonArray()) {
                    for (JsonElement a2 : ((JsonElement)e.getValue()).getAsJsonArray()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                        specified.put(e.getKey(), (Object)((Variant)context.deserialize(a2, Variant.class)));
                    }
                    continue;
                }
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (((JsonElement)((Map.Entry)obj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                    HashMap subs = Maps.newHashMap();
                    condensed.put(e.getKey(), subs);
                    for (Map.Entry entry : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey() + "=" + (String)entry.getKey();
                        subs.put(entry.getKey(), (Variant)context.deserialize((JsonElement)entry.getValue(), Variant.class));
                    }
                    continue;
                }
                Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                specified.put(e.getKey(), (Object)((Variant)context.deserialize((JsonElement)e.getValue(), Variant.class)));
            }
            Multimap<String, Variant> permutations = this.getPermutations(condensed);
            for (Map.Entry e : specified.asMap().entrySet()) {
                Collection baseVars = permutations.get(e.getKey());
                ArrayList addVars = Lists.newArrayList();
                for (Variant specVar : (Collection)e.getValue()) {
                    if (!baseVars.isEmpty()) {
                        for (Variant baseVar : baseVars) {
                            addVars.add(new Variant(specVar).sync(baseVar));
                        }
                        continue;
                    }
                    addVars.add(specVar);
                }
                baseVars.clear();
                baseVars.addAll(addVars);
            }
            for (Map.Entry e : permutations.entries()) {
                Variant v = (Variant)e.getValue();
                if (ret.defaults != null) {
                    v.sync(ret.defaults);
                    for (Map.Entry entry : v.simpleSubmodels.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (!v.submodels.containsKey(entry.getKey())) {
                            throw new RuntimeException("This should never happen! Simple submodel is not contained in the submodel map!");
                        }
                        List partList = (List)v.submodels.get(entry.getKey());
                        if (partList.size() > 1) {
                            throw new RuntimeException("This should never happen! Simple submodel has multiple variants!");
                        }
                        Variant part = (Variant)partList.get(0);
                        Optional state = part.state;
                        part.sync(v);
                        part.simpleSubmodels.clear();
                        part.state = state;
                    }
                }
                Iterator iter = v.submodels.values().iterator();
                while (iter.hasNext()) {
                    List list = (List)iter.next();
                    if (list != null) continue;
                    iter.remove();
                }
                if (v.textures != null) {
                    for (Map.Entry tex : v.textures.entrySet()) {
                        if (tex.getValue() == null || ((String)tex.getValue()).charAt(0) != '#') continue;
                        String value = (String)v.textures.get(((String)tex.getValue()).substring(1));
                        if (value == null) {
                            FMLLog.severe("Could not resolve texture name \"" + (String)tex.getValue() + "\" for permutation \"" + (String)e.getKey() + "\"", new Object[0]);
                            for (Map.Entry entry : v.textures.entrySet()) {
                                FMLLog.severe((String)entry.getKey() + "=" + (String)entry.getValue(), new Object[0]);
                            }
                            throw new JsonParseException("Could not resolve texture name \"" + (String)tex.getValue() + "\" for permutation \"" + (String)e.getKey() + "\"");
                        }
                        v.textures.put(tex.getKey(), value);
                    }
                    for (List part : v.submodels.values()) {
                        for (Variant partVar : part) {
                            for (Map.Entry texEntry : v.textures.entrySet()) {
                                if (partVar.textures.containsKey(texEntry.getKey())) continue;
                                partVar.textures.put(texEntry.getKey(), texEntry.getValue());
                            }
                        }
                    }
                }
                if (!v.submodels.isEmpty()) {
                    ret.variants.putAll(e.getKey(), this.getSubmodelPermutations(v, v.submodels));
                    continue;
                }
                ret.variants.put(e.getKey(), (Object)v);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(List<String> sorted, Map<String, Map<String, Variant>> base, int depth, String prefix, Multimap<String, Variant> ret, Variant parent) {
            if (depth == sorted.size()) {
                if (parent != null) {
                    ret.put((Object)prefix, (Object)parent);
                }
                return ret;
            }
            String name = sorted.get(depth);
            for (Map.Entry<String, Variant> e : base.get(name).entrySet()) {
                Variant newHead = parent == null ? new Variant(e.getValue()) : new Variant(parent).sync(e.getValue());
                this.getPermutations(sorted, base, depth + 1, prefix + (depth == 0 ? "" : ",") + name + "=" + e.getKey(), ret, newHead);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(Map<String, Map<String, Variant>> base) {
            ArrayList sorted = Lists.newArrayList(base.keySet());
            Collections.sort(sorted);
            return this.getPermutations(sorted, base, 0, "", (Multimap<String, Variant>)HashMultimap.create(), null);
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, List<String> sorted, Map<String, List<Variant>> map, int depth, Map<String, Variant> parts, List<Variant> ret) {
            if (depth >= sorted.size()) {
                Variant add = new Variant(baseVar);
                for (Map.Entry<String, Variant> part : parts.entrySet()) {
                    add.submodels.put(part.getKey(), Collections.singletonList(part.getValue()));
                }
                ret.add(add);
                return ret;
            }
            String name = sorted.get(depth);
            List<Variant> vars = map.get(sorted.get(depth));
            if (vars != null) {
                for (Variant v : vars) {
                    if (v == null) continue;
                    parts.put(name, v);
                    this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
                    parts.remove(name);
                }
            } else {
                this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
            }
            return ret;
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, Map<String, List<Variant>> variants) {
            ArrayList sorted = Lists.newArrayList(variants.keySet());
            Collections.sort(sorted);
            return this.getSubmodelPermutations(baseVar, sorted, variants, 0, new HashMap<String, Variant>(), new ArrayList<Variant>());
        }
    }
}

