/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends IFlexibleBakedModel {
    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b var1);

    public static class MapWrapper
    implements IPerspectiveAwareModel {
        private final IFlexibleBakedModel parent;
        private final ImmutableMap<bgr.b, TRSRTransformation> transforms;

        public MapWrapper(IFlexibleBakedModel parent, ImmutableMap<bgr.b, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(IFlexibleBakedModel parent, IModelState state) {
            this(parent, MapWrapper.getTransforms(state));
        }

        public static ImmutableMap<bgr.b, TRSRTransformation> getTransforms(IModelState state) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bgr.b type : bgr.b.values()) {
                Optional<TRSRTransformation> tr = state.apply((Optional<? extends IModelPart>)Optional.of((Object)type));
                if (!tr.isPresent()) continue;
                builder.put((Object)type, tr.get());
            }
            return builder.build();
        }

        public static ImmutableMap<bgr.b, TRSRTransformation> getTransforms(bgr transforms) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bgr.b type : bgr.b.values()) {
                builder.put((Object)type, (Object)new TRSRTransformation(transforms.b(type)));
            }
            return builder.build();
        }

        public static Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(IFlexibleBakedModel model, ImmutableMap<bgr.b, TRSRTransformation> transforms, bgr.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && !tr.equals(TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)model, mat);
        }

        public static Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(IFlexibleBakedModel model, IModelState state, bgr.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)cameraTransformType)).or((Object)TRSRTransformation.identity());
            if (tr != TRSRTransformation.identity()) {
                return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrix());
            }
            return Pair.of((Object)model, null);
        }

        public boolean b() {
            return this.parent.b();
        }

        public boolean c() {
            return this.parent.c();
        }

        public boolean d() {
            return this.parent.d();
        }

        public bmi e() {
            return this.parent.e();
        }

        public bgr f() {
            return this.parent.f();
        }

        public List<bgg> a(cq side) {
            return this.parent.a(side);
        }

        public List<bgg> a() {
            return this.parent.a();
        }

        @Override
        public bmu getFormat() {
            return this.parent.getFormat();
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            return MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, cameraTransformType);
        }
    }
}

