/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.base.Objects;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class VertexLighterFlat
extends QuadGatheringTransformer {
    protected final BlockInfo blockInfo = new BlockInfo();
    private int tint = -1;
    protected int posIndex = -1;
    protected int normalIndex = -1;
    protected int colorIndex = -1;
    protected int lightmapIndex = -1;

    @Override
    public void setParent(IVertexConsumer parent) {
        super.setParent(parent);
        if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
            return;
        }
        this.setVertexFormat(VertexLighterFlat.getVertexFormat(parent));
        block6: for (int i = 0; i < this.getVertexFormat().i(); ++i) {
            switch (this.getVertexFormat().c(i).b()) {
                case a: {
                    this.posIndex = i;
                    continue block6;
                }
                case b: {
                    this.normalIndex = i;
                    continue block6;
                }
                case c: {
                    this.colorIndex = i;
                    continue block6;
                }
                case d: {
                    if (this.getVertexFormat().c(i).d() != 1) continue block6;
                    this.lightmapIndex = i;
                    continue block6;
                }
            }
        }
        if (this.posIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with position");
        }
        if (this.lightmapIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with lightmap");
        }
        if (this.colorIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with color");
        }
    }

    private static bmu getVertexFormat(IVertexConsumer parent) {
        bmu format = parent.getVertexFormat();
        if (format.b()) {
            return format;
        }
        format = new bmu(format);
        format.a(new bmv(0, bmv.a.a, bmv.b.b, 4));
        return format;
    }

    @Override
    protected void processQuad() {
        int v;
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        if (this.normalIndex != -1 && (this.quadData[this.normalIndex][0][0] != -1.0f || this.quadData[this.normalIndex][0][1] != -1.0f || this.quadData[this.normalIndex][0][2] != -1.0f)) {
            normal = this.quadData[this.normalIndex];
        } else {
            normal = new float[4][4];
            Vector3f v1 = new Vector3f(position[3]);
            Vector3f t = new Vector3f(position[1]);
            Vector3f v2 = new Vector3f(position[2]);
            v1.sub((Tuple3f)t);
            t.set(position[0]);
            v2.sub((Tuple3f)t);
            v1.cross(v2, v1);
            v1.normalize();
            for (v = 0; v < 4; ++v) {
                normal[v][0] = v1.x;
                normal[v][1] = v1.y;
                normal[v][2] = v1.z;
                normal[v][3] = 0.0f;
            }
        }
        int multiplier = -1;
        if (this.tint != -1) {
            multiplier = this.blockInfo.getColorMultiplier(this.tint);
        }
        bmu format = this.parent.getVertexFormat();
        int count = format.i();
        for (v = 0; v < 4; ++v) {
            float[] fArray = position[v];
            fArray[0] = fArray[0] + this.blockInfo.getShx();
            float[] fArray2 = position[v];
            fArray2[1] = fArray2[1] + this.blockInfo.getShy();
            float[] fArray3 = position[v];
            fArray3[2] = fArray3[2] + this.blockInfo.getShz();
            float x = position[v][0] - 0.5f;
            float y = position[v][1] - 0.5f;
            float z = position[v][2] - 0.5f;
            float blockLight = lightmap[v][0];
            float skyLight = lightmap[v][1];
            this.updateLightmap(normal[v], lightmap[v], x += normal[v][0] * 0.5f, y += normal[v][1] * 0.5f, z += normal[v][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v][0]) {
                    lightmap[v][0] = blockLight;
                }
                if (skyLight > lightmap[v][1]) {
                    lightmap[v][1] = skyLight;
                }
            }
            this.updateColor(normal[v], color[v], x, y, z, this.tint, multiplier);
            if (bfk.a) {
                this.applyAnaglyph(color[v]);
            }
            block8: for (int e = 0; e < count; ++e) {
                bmv element = format.c(e);
                switch (element.b()) {
                    case a: {
                        this.parent.put(e, position[v]);
                        continue block8;
                    }
                    case b: {
                        if (this.normalIndex != -1) {
                            this.parent.put(e, normal[v]);
                            continue block8;
                        }
                    }
                    case c: {
                        this.parent.put(e, color[v]);
                        continue block8;
                    }
                    case d: {
                        if (element.d() == 1) {
                            this.parent.put(e, lightmap[v]);
                            continue block8;
                        }
                    }
                    default: {
                        this.parent.put(e, this.quadData[e][v]);
                    }
                }
            }
        }
        this.tint = -1;
    }

    protected void applyAnaglyph(float[] color) {
        float r = color[0];
        color[0] = (r * 30.0f + color[1] * 59.0f + color[2] * 11.0f) / 100.0f;
        color[1] = (r * 3.0f + color[1] * 7.0f) / 10.0f;
        color[2] = (r * 3.0f + color[2] * 7.0f) / 10.0f;
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        float e1 = 0.99f;
        float e2 = 0.95f;
        cj pos = this.blockInfo.getBlockPos();
        boolean full = this.blockInfo.getBlock().d();
        if ((full || y < -e1) && normal[1] < -e2) {
            pos = pos.b();
        }
        if ((full || y > e1) && normal[1] > e2) {
            pos = pos.a();
        }
        if ((full || z < -e1) && normal[2] < -e2) {
            pos = pos.c();
        }
        if ((full || z > e1) && normal[2] > e2) {
            pos = pos.d();
        }
        if ((full || x < -e1) && normal[0] < -e2) {
            pos = pos.e();
        }
        if ((full || x > e1) && normal[0] > e2) {
            pos = pos.f();
        }
        int brightness = this.blockInfo.getBlock().c(this.blockInfo.getWorld(), pos);
        lightmap[0] = (float)(brightness >> 4 & 0xF) * 32.0f / 65535.0f;
        lightmap[1] = (float)(brightness >> 20 & 0xF) * 32.0f / 65535.0f;
    }

    protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
    }

    @Override
    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    @Override
    public void setQuadOrientation(cq orientation) {
    }

    public void setQuadCulled() {
    }

    @Override
    public void setQuadColored() {
    }

    public void setWorld(adq world) {
        this.blockInfo.setWorld(world);
    }

    public void setBlock(afh block) {
        this.blockInfo.setBlock(block);
    }

    public void setBlockPos(cj blockPos) {
        this.blockInfo.setBlockPos(blockPos);
    }

    public void updateBlockInfo() {
        this.blockInfo.updateShift(true);
    }
}

